/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.featureinfo.LayerIdentifier;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;

abstract class AbstractVectorLayerIdentifier
implements LayerIdentifier {
    private static final double TOLERANCE = 1.0E-6;

    AbstractVectorLayerIdentifier() {
    }

    @Override
    public boolean canHandle(MapLayerInfo layer) {
        int type = layer.getType();
        return type == MapLayerInfo.TYPE_VECTOR || type == MapLayerInfo.TYPE_REMOTE_VECTOR;
    }

    protected List<Rule> getActiveRules(Style style, double scaleDenominator) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            for (Rule r : fts.rules()) {
                if (!(r.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator) || !(r.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator) || r.getSymbolizers() == null || r.getSymbolizers().length <= 0) continue;
                result.add(r);
            }
        }
        return result;
    }
}

