/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension.impl;

import java.io.IOException;
import java.util.List;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.wms.dimension.AbstractFeatureAttributeVisitorSelectionStrategy;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.util.Converters;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class FeatureNearestValueSelectionStrategyImpl
extends AbstractFeatureAttributeVisitorSelectionStrategy {
    private Object toMatch;
    private String fixedCapabilitiesValue;
    private FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();

    public FeatureNearestValueSelectionStrategyImpl(Object toMatch) {
        this(toMatch, null);
    }

    public FeatureNearestValueSelectionStrategyImpl(Object toMatch, String capabilitiesValue) {
        this.toMatch = toMatch;
        this.fixedCapabilitiesValue = capabilitiesValue;
    }

    @Override
    public <T> T getDefaultValue(ResourceInfo resource, String dimensionName, DimensionInfo dimension, Class<T> clz) {
        NearestVisitor nearest;
        CalcResult res;
        String attrName = dimension.getAttribute();
        Class attrType = String.class;
        if (resource instanceof FeatureTypeInfo) {
            try {
                List attrTypes = ((FeatureTypeInfo)resource).attributes();
                for (AttributeTypeInfo attr : attrTypes) {
                    if (!attr.getName().equals(attrName)) continue;
                    attrType = attr.getBinding();
                    break;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((res = this.getCalculatedResult((FeatureTypeInfo)resource, dimension, (FeatureCalc)(nearest = new NearestVisitor((Expression)this.ff.property(dimension.getAttribute()), this.toMatch)))).equals(CalcResult.NULL_RESULT)) {
            return null;
        }
        return (T)Converters.convert((Object)res.getValue(), clz);
    }

    @Override
    public String getCapabilitiesRepresentation(ResourceInfo resource, String dimensionName, DimensionInfo dimensionInfo) {
        if (this.fixedCapabilitiesValue != null) {
            return this.fixedCapabilitiesValue;
        }
        return super.getCapabilitiesRepresentation(resource, dimensionName, dimensionInfo);
    }
}

