/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.wms.dimension.AbstractDefaultValueSelectionStrategy;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class CoverageMinimumValueSelectionStrategyImpl
extends AbstractDefaultValueSelectionStrategy {
    private static Logger LOGGER = Logging.getLogger(CoverageMinimumValueSelectionStrategyImpl.class);

    @Override
    public <T> T getDefaultValue(ResourceInfo resource, String dimensionName, DimensionInfo dimension, Class<T> clz) {
        Object retval = null;
        try {
            GridCoverage2DReader reader = (GridCoverage2DReader)((CoverageInfo)resource).getGridCoverageReader(null, null);
            ReaderDimensionsAccessor dimAccessor = new ReaderDimensionsAccessor(reader);
            if (dimensionName.equals("time")) {
                retval = dimAccessor.getMinTime();
            } else if (dimensionName.equals("elevation")) {
                retval = dimAccessor.getMinElevation();
            } else if (dimensionName.startsWith("custom_dimension_")) {
                String custDimName = dimensionName.substring("custom_dimension_".length());
                String min = reader.getMetadataValue(custDimName.toUpperCase() + "_DOMAIN_MINIMUM");
                if (min != null) {
                    retval = min;
                } else {
                    List domain = dimAccessor.getDomain(custDimName);
                    if (domain.isEmpty()) {
                        retval = null;
                    } else {
                        Collections.sort(domain);
                        retval = domain.get(0);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
        return (T)Converters.convert(retval, clz);
    }
}

