/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.util.Range;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class DimensionFilterBuilder {
    Filter filter = null;
    FilterFactory ff;

    public DimensionFilterBuilder(FilterFactory ff) {
        this.ff = ff;
    }

    public void appendFilters(String startAttributeName, String endAttributeName, List<Object> ranges) {
        if (ranges == null || ranges.size() == 0) {
            return;
        }
        ArrayList<Filter> timeFilters = new ArrayList<Filter>();
        PropertyName attribute = this.ff.property(startAttributeName);
        PropertyName endAttribute = endAttributeName == null ? null : this.ff.property(endAttributeName);
        for (Object datetime : ranges) {
            timeFilters.add(this.buildDimensionFilter(datetime, attribute, endAttribute));
        }
        int size = timeFilters.size();
        Object result = size > 1 ? this.ff.or(timeFilters) : (Filter)timeFilters.get(0);
        this.filter = this.filter == null ? result : this.ff.and(this.filter, (Filter)result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Filter buildDimensionFilter(Object value, PropertyName attribute, PropertyName endAttribute) {
        if (value == null) {
            return Filter.INCLUDE;
        }
        if (value instanceof Range) {
            Range range = (Range)value;
            if (endAttribute == null) {
                return this.ff.between((Expression)attribute, (Expression)this.ff.literal((Object)range.getMinValue()), (Expression)this.ff.literal((Object)range.getMaxValue()));
            }
            Literal qlower = this.ff.literal((Object)range.getMinValue());
            Literal qupper = this.ff.literal((Object)range.getMaxValue());
            PropertyIsLessThanOrEqualTo lower = this.ff.lessOrEqual((Expression)attribute, (Expression)qupper);
            PropertyIsGreaterThanOrEqualTo upper = this.ff.greaterOrEqual((Expression)endAttribute, (Expression)qlower);
            return this.ff.and((Filter)lower, (Filter)upper);
        }
        if (endAttribute == null) {
            return this.ff.equal((Expression)attribute, (Expression)this.ff.literal(value), true);
        }
        PropertyIsGreaterThanOrEqualTo lower = this.ff.greaterOrEqual((Expression)this.ff.literal(value), (Expression)attribute);
        PropertyIsLessThanOrEqualTo upper = this.ff.lessOrEqual((Expression)this.ff.literal(value), (Expression)endAttribute);
        return this.ff.and((Filter)lower, (Filter)upper);
    }

    public Filter getFilter() {
        if (this.filter == null) {
            return Filter.INCLUDE;
        }
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        return (Filter)this.filter.accept((FilterVisitor)visitor, null);
    }
}

