/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.describelayer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.json.JSONException;
import net.sf.json.util.JSONBuilder;
import org.apache.commons.io.IOUtils;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.describelayer.DescribeLayerModel;
import org.geoserver.wms.describelayer.DescribeLayerResponse;
import org.geotools.data.ows.LayerDescription;
import org.geotools.util.logging.Logging;

public class JSONDescribeLayerResponse
extends DescribeLayerResponse {
    protected static final Logger LOGGER = Logging.getLogger(JSONDescribeLayerResponse.class);
    private final JSONType type;
    protected final WMS wms;

    public JSONDescribeLayerResponse(WMS wms, String outputFormat) {
        super(outputFormat);
        this.wms = wms;
        this.type = JSONType.getJSONType((String)outputFormat);
        if (this.type == null) {
            throw new IllegalArgumentException("Not supported mime type for:" + outputFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DescribeLayerModel layers, DescribeLayerRequest request, OutputStream output) throws ServiceException, IOException {
        switch (this.type) {
            case JSON: {
                OutputStreamWriter osw = null;
                BufferedWriter outWriter = null;
                try {
                    osw = new OutputStreamWriter(output, this.wms.getGeoServer().getSettings().getCharset());
                    outWriter = new BufferedWriter(osw);
                    this.writeJSON(outWriter, layers);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outWriter);
                    IOUtils.closeQuietly(osw);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)outWriter);
                IOUtils.closeQuietly((Writer)osw);
            }
            case JSONP: {
                this.writeJSONP(output, layers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJSONP(OutputStream out, DescribeLayerModel layers) throws IOException {
        OutputStreamWriter osw = null;
        BufferedWriter outWriter = null;
        try {
            osw = new OutputStreamWriter(out, this.wms.getGeoServer().getSettings().getCharset());
            outWriter = new BufferedWriter(osw);
            outWriter.write(JSONDescribeLayerResponse.getCallbackFunction() + "(");
            this.writeJSON(outWriter, layers);
            outWriter.write(")");
            ((Writer)outWriter).flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outWriter);
            IOUtils.closeQuietly(osw);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)outWriter);
        IOUtils.closeQuietly((Writer)osw);
    }

    private void writeJSON(Writer outWriter, DescribeLayerModel description) throws IOException {
        try {
            JSONBuilder json = new JSONBuilder(outWriter);
            List<LayerDescription> layers = description.getLayerDescriptions();
            json.object();
            json.key("version").value((Object)description.getVersion());
            json.key("layerDescriptions");
            json.array();
            for (LayerDescription layer : layers) {
                json.object();
                json.key("layerName").value((Object)layer.getName());
                URL url = layer.getOwsURL();
                json.key("owsURL").value((Object)(url != null ? url.toString() : ""));
                json.key("owsType").value((Object)layer.getOwsType());
                json.key("typeName").value((Object)layer.getName());
                json.endObject();
            }
            json.endArray();
            json.endObject();
        }
        catch (JSONException jsonException) {
            ServiceException serviceException = new ServiceException("Error: " + jsonException.getMessage());
            serviceException.initCause((Throwable)jsonException);
            throw serviceException;
        }
    }

    private static String getCallbackFunction() {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return "parseResponse";
        }
        return JSONType.getCallbackFunction((Map)request.getKvp());
    }

    public String getCharset(Operation operation) {
        return this.wms.getGeoServer().getSettings().getCharset();
    }
}

