/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.describelayer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DescribeLayerRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geotools.data.ows.LayerDescription;
import org.geotools.util.logging.Logging;

public class DescribeLayerModel {
    private static final Logger LOGGER = Logging.getLogger(DescribeLayerModel.class);
    private final List<LayerDescription> layerDescriptions = new ArrayList<LayerDescription>();
    private final String version;

    public DescribeLayerModel(DescribeLayerRequest request) throws ServiceException {
        this.version = request.getVersion();
        String baseURL = request.getBaseUrl();
        List<MapLayerInfo> layersInfo = request.getLayers();
        for (MapLayerInfo layer : layersInfo) {
            String owsUrl = null;
            String owsType = null;
            URL owsURL = null;
            if (MapLayerInfo.TYPE_VECTOR == layer.getType()) {
                owsUrl = ResponseUtils.buildURL((String)baseURL, (String)"wfs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                owsUrl = ResponseUtils.appendQueryString((String)owsUrl, (String)"");
                try {
                    owsURL = new URL(owsUrl);
                }
                catch (MalformedURLException e) {
                    LOGGER.warning(e.getLocalizedMessage());
                }
                owsType = "WFS";
            } else if (MapLayerInfo.TYPE_RASTER == layer.getType()) {
                owsUrl = ResponseUtils.buildURL((String)baseURL, (String)"wcs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                owsUrl = ResponseUtils.appendQueryString((String)owsUrl, (String)"");
                try {
                    owsURL = new URL(owsUrl);
                }
                catch (MalformedURLException e) {
                    LOGGER.warning(e.getLocalizedMessage());
                }
                owsType = "WCS";
            } else if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Non vector nor raster layer, LayerDescription will not contain these attributes");
            }
            LayerDescription layerDesc = new LayerDescription();
            layerDesc.setName(layer.getName());
            layerDesc.setOwsType(owsType);
            layerDesc.setOwsURL(owsURL);
            this.layerDescriptions.add(layerDesc);
        }
    }

    public List<LayerDescription> getLayerDescriptions() {
        return this.layerDescriptions;
    }

    public String getVersion() {
        return this.version;
    }
}

