/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.StringModel;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecoration;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geotools.renderer.style.FontCache;
import org.geotools.util.logging.Logging;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

public class TextDecoration
implements MapDecoration {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms.responses");
    private static Font DEFAULT_FONT = new Font("Serif", 0, 12);
    String fontFamily;
    boolean fontBold;
    boolean fontItalic;
    float fontSize;
    float haloRadius;
    Color haloColor;
    String messageTemplate;
    Color fontColor;

    @Override
    public void loadOptions(Map<String, String> options) throws Exception {
        this.messageTemplate = options.get("message");
        if (this.messageTemplate == null) {
            this.messageTemplate = "You forgot to set the 'message' option";
        }
        this.fontFamily = options.get("font-family");
        if (options.get("font-italic") != null) {
            this.fontItalic = Boolean.parseBoolean(options.get("font-italic"));
        }
        if (options.get("font-bold") != null) {
            this.fontBold = Boolean.parseBoolean(options.get("font-bold"));
        }
        if (options.get("font-size") != null) {
            try {
                this.fontSize = Float.parseFloat(options.get("font-size"));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'font-size' must be a float.", e);
            }
        }
        if (options.get("font-color") != null) {
            try {
                this.fontColor = MapDecorationLayout.parseColor(options.get("font-color"));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'font-color' must be a color in #RRGGBB[AA] format.", e);
            }
        }
        if (this.fontColor == null) {
            this.fontColor = Color.BLACK;
        }
        if (options.get("halo-radius") != null) {
            try {
                this.haloRadius = Float.parseFloat(options.get("halo-radius"));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'halo-radius' must be a float.", e);
            }
        }
        if (options.get("halo-color") != null) {
            try {
                this.haloColor = MapDecorationLayout.parseColor(options.get("halo-color"));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "'halo-color' must be a color in #RRGGBB[AA] format.", e);
            }
        }
        if (this.haloRadius > 0.0f && this.haloColor == null) {
            this.haloColor = Color.WHITE;
        }
    }

    Font getFont() {
        Font font = DEFAULT_FONT;
        if (this.fontFamily != null && (font = FontCache.getDefaultInstance().getFont(this.fontFamily)) == null) {
            LOGGER.log(Level.WARNING, "Font " + this.fontFamily + " not found, falling back on the default");
            font = DEFAULT_FONT;
        }
        if (this.fontSize > 0.0f) {
            font = font.deriveFont(this.fontSize);
        }
        if (this.fontItalic) {
            font = font.deriveFont(2);
        }
        if (this.fontBold) {
            font = font.deriveFont(1);
        }
        return font;
    }

    String evaluateMessage(WMSMapContent content) throws IOException, TemplateException {
        final Map env = content.getRequest().getEnv();
        Template t = new Template("name", (Reader)new StringReader(this.messageTemplate), new Configuration());
        final BeansWrapper bw = new BeansWrapper();
        return FreeMarkerTemplateUtils.processTemplateIntoString((Template)t, (Object)new TemplateHashModel(){

            public boolean isEmpty() throws TemplateModelException {
                return env.isEmpty();
            }

            public TemplateModel get(String key) throws TemplateModelException {
                String value = (String)env.get(key);
                if (value != null) {
                    return new StringModel((Object)value, bw);
                }
                return null;
            }
        });
    }

    @Override
    public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContent) throws Exception {
        Font font = this.getFont();
        String message = this.evaluateMessage(mapContent);
        GlyphVector gv = font.createGlyphVector(g2d.getFontRenderContext(), message.toCharArray());
        Shape outline = gv.getOutline();
        Rectangle2D bounds = outline.getBounds2D();
        double width = bounds.getWidth() + (double)(this.haloRadius * 2.0f);
        double height = bounds.getHeight() + (double)(this.haloRadius * 2.0f);
        return new Dimension((int)Math.ceil(width), (int)Math.ceil(height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContent mapContent) throws Exception {
        Font font = this.getFont();
        String message = this.evaluateMessage(mapContent);
        Font oldFont = g2d.getFont();
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        try {
            GlyphVector gv = font.createGlyphVector(g2d.getFontRenderContext(), message.toCharArray());
            AffineTransform at = AffineTransform.getTranslateInstance((float)paintArea.x + this.haloRadius, (float)(paintArea.y + paintArea.height) - this.haloRadius);
            Shape outline = gv.getOutline();
            outline = at.createTransformedShape(outline);
            if (this.haloRadius > 0.0f) {
                g2d.setColor(this.haloColor);
                g2d.setStroke(new BasicStroke(2.0f * this.haloRadius, 1, 1));
                g2d.draw(outline);
            }
            g2d.setFont(font);
            g2d.setColor(this.fontColor);
            g2d.fill(outline);
        }
        finally {
            g2d.setColor(oldColor);
            g2d.setFont(oldFont);
            g2d.setStroke(oldStroke);
        }
    }
}

