/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecoration;

public class ScaleRatioDecoration
implements MapDecoration {
    @Override
    public void loadOptions(Map<String, String> options) {
    }

    @Override
    public Dimension findOptimalSize(Graphics2D g2d, WMSMapContent mapContent) {
        FontMetrics metrics = g2d.getFontMetrics(g2d.getFont());
        return new Dimension(metrics.stringWidth(this.getScaleText(mapContent)), metrics.getHeight());
    }

    public double getScale(WMSMapContent mapContent) {
        return mapContent.getScaleDenominator(true);
    }

    public String getScaleText(WMSMapContent mapContent) {
        return String.format("1 : %0$1.0f", this.getScale(mapContent));
    }

    @Override
    public void paint(Graphics2D g2d, Rectangle paintArea, WMSMapContent mapContent) throws Exception {
        FontMetrics metrics = g2d.getFontMetrics(g2d.getFont());
        Dimension d = new Dimension(metrics.stringWidth(this.getScaleText(mapContent)), metrics.getHeight());
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        float x = (float)(paintArea.getMinX() + (paintArea.getWidth() - d.getWidth()) / 2.0);
        float y = (float)(paintArea.getMaxY() - (paintArea.getHeight() - d.getHeight()) / 2.0);
        Rectangle2D.Double bgRect = new Rectangle2D.Double((double)x - 3.0, (double)y - d.getHeight(), d.getWidth() + 6.0, d.getHeight() + 6.0);
        g2d.setColor(Color.WHITE);
        g2d.fill(bgRect);
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawString(this.getScaleText(mapContent), x, y);
        g2d.draw(bgRect);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }
}

