/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.PngReader;
import it.geosolutions.imageio.plugins.png.PNGWriter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.GetLegendGraphicOutputFormat;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.capabilities.LegendSample;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphic;
import org.geoserver.wms.legendgraphic.PNGLegendOutputFormat;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.FeatureType;

public class LegendSampleImpl
implements CatalogListener,
LegendSample,
GeoServerLifecycleHandler {
    public static final String LEGEND_SAMPLES_FOLDER = "legendsamples";
    private static final Logger LOGGER = Logging.getLogger((String)LegendSampleImpl.class.getPackage().getName());
    private static final String DEFAULT_SAMPLE_FORMAT = "png";
    private Catalog catalog;
    private GeoServerResourceLoader loader;
    private Set<String> invalidated = new HashSet<String>();
    File baseDir;

    public LegendSampleImpl(Catalog catalog, GeoServerResourceLoader loader) {
        this.catalog = catalog;
        this.loader = loader;
        this.baseDir = loader.getBaseDirectory();
        this.clean();
        this.catalog.addListener((CatalogListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        Iterator i$ = this.catalog.getStyles().iterator();
        while (i$.hasNext()) {
            StyleInfo style;
            StyleInfo styleInfo = style = (StyleInfo)i$.next();
            synchronized (styleInfo) {
                Resource styleResource = this.getStyleResource(style);
                try {
                    File sampleFile = this.getSampleFile(style);
                    if (this.isStyleNewerThanSample(styleResource, sampleFile)) {
                        sampleFile.delete();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error cleaning invalid legend sample for " + style.getName(), e);
                }
            }
        }
        this.invalidated = new HashSet<String>();
    }

    private boolean isStyleNewerThanSample(Resource styleResource, File sampleFile) {
        return this.isSampleExisting(sampleFile) && styleResource.getType() == Resource.Type.RESOURCE && styleResource.lastmodified() > sampleFile.lastModified();
    }

    private File getSampleFile(StyleInfo style) throws IOException {
        String fileName = this.getSampleFileName(style);
        return this.getSampleFile(fileName);
    }

    private File getSampleFile(String fileName) {
        return new File(this.getSamplesFolder(), fileName);
    }

    private String getSampleFileName(StyleInfo style) {
        String prefix = "";
        if (style.getWorkspace() != null) {
            prefix = style.getWorkspace().getName() + "_";
        }
        String fileName = prefix + style.getName() + "." + DEFAULT_SAMPLE_FORMAT;
        return fileName;
    }

    private Resource getStyleResource(StyleInfo style) {
        Object[] prefix = new String[]{};
        if (style.getWorkspace() != null) {
            prefix = new String[]{"workspaces", style.getWorkspace().getName()};
        }
        String fileName = style.getFilename();
        String[] pathParts = (String[])ArrayUtils.addAll((Object[])prefix, (Object[])new String[]{"styles", fileName});
        String path = Paths.path((String[])pathParts);
        return this.loader.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getLegendURLSize(StyleInfo style) throws Exception {
        StyleInfo styleInfo = style;
        synchronized (styleInfo) {
            PNGLegendOutputFormat pngOutputFormat = new PNGLegendOutputFormat();
            File sampleLegend = this.getSampleFile(style);
            if (this.isSampleExisting(sampleLegend) && !this.isStyleSampleInvalid(style)) {
                return this.getSizeFromSample(sampleLegend);
            }
            return this.createNewSample(style, pngOutputFormat);
        }
    }

    private boolean isSampleExisting(File sampleLegend) {
        return sampleLegend != null && sampleLegend.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension createNewSample(StyleInfo style, GetLegendGraphicOutputFormat pngOutputFormat) throws Exception {
        GetLegendGraphicRequest legendGraphicRequest = new GetLegendGraphicRequest();
        File sampleLegendFolder = this.getSamplesFolder();
        legendGraphicRequest.setStrict(false);
        legendGraphicRequest.setLayers(Arrays.asList(new FeatureType[]{null}));
        legendGraphicRequest.setStyles(Arrays.asList(style.getStyle()));
        legendGraphicRequest.setFormat(pngOutputFormat.getContentType());
        Object legendGraphic = pngOutputFormat.produceLegendGraphic(legendGraphicRequest);
        if (legendGraphic instanceof BufferedImageLegendGraphic) {
            BufferedImage image = ((BufferedImageLegendGraphic)legendGraphic).getLegend();
            PNGWriter writer = new PNGWriter();
            try (FileOutputStream outStream = null;){
                File sampleFile = new File(sampleLegendFolder.getAbsolutePath() + File.separator + this.getSampleFileName(style));
                if (!sampleFile.getParentFile().exists()) {
                    sampleFile.getParentFile().mkdirs();
                }
                outStream = new FileOutputStream(sampleFile);
                writer.writePNG((RenderedImage)image, (OutputStream)outStream, 0.0f, FilterType.FILTER_NONE);
                this.removeStyleSampleInvalidation(style);
                Dimension dimension = new Dimension(image.getWidth(), image.getHeight());
                return dimension;
            }
        }
        return null;
    }

    private File getSamplesFolder() {
        return new File(this.baseDir + File.separator + LEGEND_SAMPLES_FOLDER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getSizeFromSample(File sampleLegendFile) {
        try (PngReader pngReader = null;){
            pngReader = new PngReader(sampleLegendFile);
            Dimension dimension = new Dimension(pngReader.imgInfo.cols, pngReader.imgInfo.rows);
            return dimension;
        }
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        if (event.getSource() instanceof StyleInfo) {
            this.invalidateStyleSample((StyleInfo)event.getSource());
        }
    }

    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        if (event.getSource() instanceof StyleInfo) {
            this.invalidateStyleSample((StyleInfo)event.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateStyleSample(StyleInfo style) {
        StyleInfo styleInfo = style;
        synchronized (styleInfo) {
            this.invalidated.add(this.getStyleName(style));
        }
    }

    private void removeStyleSampleInvalidation(StyleInfo style) {
        this.invalidated.remove(this.getStyleName(style));
    }

    private boolean isStyleSampleInvalid(StyleInfo style) {
        return this.invalidated.contains(this.getStyleName(style));
    }

    private String getStyleName(StyleInfo styleInfo) {
        return styleInfo.getWorkspace() != null ? styleInfo.getWorkspace().getName() + ":" + styleInfo.getName() : styleInfo.getName();
    }

    public void reloaded() {
        this.clean();
    }

    public void onReset() {
    }

    public void onDispose() {
        this.catalog.removeListener((CatalogListener)this);
    }

    public void beforeReload() {
    }

    public void onReload() {
        this.reloaded();
    }
}

