/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import com.google.common.collect.Iterables;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.DataLinkInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.capabilities.CapabilityUtil;
import org.geoserver.wms.capabilities.DimensionHelper;
import org.geoserver.wms.capabilities.LayerTree;
import org.geoserver.wms.capabilities.LegendSample;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.type.Name;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.springframework.util.Assert;
import org.vfny.geoserver.util.ResponseUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class GetCapabilitiesTransformer
extends TransformerBase {
    public static final String WMS_CAPS_MIME = "application/vnd.ogc.wms_xml";
    static final String[] EXCEPTION_FORMATS = new String[]{"application/vnd.ogc.se_xml", "application/vnd.ogc.se_inimage", "application/vnd.ogc.se_blank"};
    private static final Set<String> SUPPORTED_MDLINK_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("FGDC", "TC211")));
    private String baseURL;
    private Set<String> getMapFormats;
    private Set<String> getLegendGraphicFormats;
    private WMS wmsConfig;
    private Collection<ExtendedCapabilitiesProvider> extCapsProviders;

    public GetCapabilitiesTransformer(WMS wms, String baseURL, Set<String> getMapFormats, Set<String> getLegendGraphicFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders) {
        Assert.notNull((Object)wms);
        Assert.notNull((Object)baseURL, (String)"baseURL");
        Assert.notNull(getMapFormats, (String)"getMapFormats");
        Assert.notNull(getLegendGraphicFormats, (String)"getLegendGraphicFormats");
        this.wmsConfig = wms;
        this.getMapFormats = getMapFormats;
        this.getLegendGraphicFormats = getLegendGraphicFormats;
        this.baseURL = baseURL;
        this.extCapsProviders = extCapsProviders == null ? Collections.EMPTY_LIST : extCapsProviders;
        this.setNamespaceDeclarationEnabled(false);
        this.setIndentation(2);
        Charset encoding = wms.getCharSet();
        this.setEncoding(encoding);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new CapabilitiesTranslator(handler, this.wmsConfig, this.getMapFormats, this.getLegendGraphicFormats, this.extCapsProviders);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        String dtdUrl = org.geoserver.ows.util.ResponseUtils.buildSchemaURL((String)this.baseURL, (String)"wms/1.1.1/WMS_MS_Capabilities.dtd");
        transformer.setOutputProperty("doctype-system", dtdUrl);
        return transformer;
    }

    private static class CapabilitiesTranslator
    extends TransformerBase.TranslatorSupport {
        private static final Logger LOGGER = Logging.getLogger((String)CapabilitiesTranslator.class.getPackage().getName());
        private static final String MIN_DENOMINATOR_ATTR = "min";
        private static final String MAX_DENOMINATOR_ATTR = "max";
        private static final String EPSG = "EPSG:";
        private static AttributesImpl wmsVersion = new AttributesImpl();
        private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
        DimensionHelper dimensionHelper;
        private LegendSample legendSample;
        private GetCapabilitiesRequest request;
        private Set<String> getMapFormats;
        private Set<String> getLegendGraphicFormats;
        private WMS wmsConfig;
        private Collection<ExtendedCapabilitiesProvider> extCapsProviders;
        private final boolean skipping;
        private WMSInfo serviceInfo;

        public CapabilitiesTranslator(ContentHandler handler, WMS wmsConfig, Set<String> getMapFormats, Set<String> getLegendGraphicFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders) {
            super(handler, null, null);
            this.wmsConfig = wmsConfig;
            this.getMapFormats = getMapFormats;
            this.getLegendGraphicFormats = getLegendGraphicFormats;
            this.extCapsProviders = extCapsProviders;
            this.serviceInfo = wmsConfig.getServiceInfo();
            this.dimensionHelper = new DimensionHelper(DimensionHelper.Mode.WMS11, wmsConfig){

                @Override
                protected void element(String element, String content, Attributes atts) {
                    CapabilitiesTranslator.this.element(element, content, atts);
                }

                @Override
                protected void element(String element, String content) {
                    CapabilitiesTranslator.this.element(element, content);
                }
            };
            this.legendSample = (LegendSample)GeoServerExtensions.bean(LegendSample.class);
            this.skipping = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)wmsConfig.getGeoServer().getGlobal().getResourceErrorHandling());
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof GetCapabilitiesRequest)) {
                throw new IllegalArgumentException();
            }
            this.request = (GetCapabilitiesRequest)o;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("producing a capabilities document for ").append(this.request).toString());
            }
            AttributesImpl rootAtts = new AttributesImpl(wmsVersion);
            rootAtts.addAttribute("", "updateSequence", "updateSequence", "", this.wmsConfig.getUpdateSequence() + "");
            this.start("WMT_MS_Capabilities", rootAtts);
            this.handleService();
            this.handleCapability();
            this.end("WMT_MS_Capabilities");
        }

        private void handleService() {
            this.start("Service");
            this.element("Name", "OGC:WMS");
            this.element("Title", this.serviceInfo.getTitle());
            this.element("Abstract", this.serviceInfo.getAbstract());
            this.handleKeywordList(this.serviceInfo.getKeywords());
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
            String onlineResource = this.serviceInfo.getOnlineResource();
            if (onlineResource == null || onlineResource.trim().length() == 0) {
                String requestBaseUrl = this.request.getBaseUrl();
                onlineResource = org.geoserver.ows.util.ResponseUtils.buildURL((String)requestBaseUrl, null, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            } else {
                try {
                    new URL(onlineResource);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "WMS online resource seems to be an invalid URL: '" + onlineResource + "'");
                }
            }
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", onlineResource);
            this.element("OnlineResource", null, orAtts);
            GeoServer geoServer = this.wmsConfig.getGeoServer();
            ContactInfo contact = geoServer.getSettings().getContact();
            this.handleContactInfo(contact);
            String fees = this.serviceInfo.getFees();
            this.element("Fees", fees == null ? "none" : fees);
            String constraints = this.serviceInfo.getAccessConstraints();
            this.element("AccessConstraints", constraints == null ? "none" : constraints);
            this.end("Service");
        }

        public void handleContactInfo(ContactInfo contact) {
            this.start("ContactInformation");
            this.start("ContactPersonPrimary");
            this.element("ContactPerson", contact.getContactPerson());
            this.element("ContactOrganization", contact.getContactOrganization());
            this.end("ContactPersonPrimary");
            this.element("ContactPosition", contact.getContactPosition());
            this.start("ContactAddress");
            this.element("AddressType", contact.getAddressType());
            this.element("Address", contact.getAddress());
            this.element("City", contact.getAddressCity());
            this.element("StateOrProvince", contact.getAddressState());
            this.element("PostCode", contact.getAddressPostalCode());
            this.element("Country", contact.getAddressCountry());
            this.end("ContactAddress");
            this.element("ContactVoiceTelephone", contact.getContactVoice());
            this.element("ContactFacsimileTelephone", contact.getContactFacsimile());
            this.element("ContactElectronicMailAddress", contact.getContactEmail());
            this.end("ContactInformation");
        }

        private void handleKeywordList(List<KeywordInfo> keywords) {
            this.start("KeywordList");
            if (keywords != null) {
                Iterator<KeywordInfo> it = keywords.iterator();
                while (it.hasNext()) {
                    this.element("Keyword", it.next().getValue());
                }
            }
            this.end("KeywordList");
        }

        private void handleMetadataList(Collection<MetadataLinkInfo> metadataURLs) {
            if (metadataURLs == null) {
                return;
            }
            for (MetadataLinkInfo link : metadataURLs) {
                if (!SUPPORTED_MDLINK_TYPES.contains(link.getMetadataType())) continue;
                AttributesImpl lnkAtts = new AttributesImpl();
                lnkAtts.addAttribute("", "type", "type", "", link.getMetadataType());
                this.start("MetadataURL", lnkAtts);
                this.element("Format", link.getType());
                String content = ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)link, (String)this.request.getBaseUrl());
                AttributesImpl orAtts = new AttributesImpl();
                orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
                orAtts.addAttribute("", "xlink:href", "xlink:href", "", content);
                this.element("OnlineResource", null, orAtts);
                this.end("MetadataURL");
            }
        }

        private void handleDataList(Collection<DataLinkInfo> dataURLs) {
            if (dataURLs == null) {
                return;
            }
            for (DataLinkInfo link : dataURLs) {
                this.start("DataURL");
                this.element("Format", link.getType());
                String content = ResponseUtils.proxifyDataLink((DataLinkInfo)link, (String)this.request.getBaseUrl());
                AttributesImpl orAtts = new AttributesImpl();
                orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
                orAtts.addAttribute("", "xlink:href", "xlink:href", "", content);
                this.element("OnlineResource", null, orAtts);
                this.end("DataURL");
            }
        }

        private void handleCapability() {
            this.start("Capability");
            this.handleRequest();
            this.handleException();
            this.handleVendorSpecificCapabilities();
            this.handleSLD();
            this.handleLayers();
            this.end("Capability");
        }

        private void handleRequest() {
            this.start("Request");
            this.start("GetCapabilities");
            this.element("Format", GetCapabilitiesTransformer.WMS_CAPS_MIME);
            String serviceUrl = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wms", (Map)org.geoserver.ows.util.ResponseUtils.params((String[])new String[]{"SERVICE", "WMS"}), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            serviceUrl = org.geoserver.ows.util.ResponseUtils.appendQueryString((String)serviceUrl, (String)"");
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetCapabilities");
            this.start("GetMap");
            ArrayList<String> sortedFormats = new ArrayList<String>(this.getMapFormats);
            Collections.sort(sortedFormats);
            if (sortedFormats.contains("image/png")) {
                sortedFormats.remove("image/png");
                sortedFormats.add(0, "image/png");
            }
            Iterator it = sortedFormats.iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetMap");
            this.start("GetFeatureInfo");
            for (String format : this.wmsConfig.getAllowedFeatureInfoFormats()) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetFeatureInfo");
            this.start("DescribeLayer");
            this.element("Format", GetCapabilitiesTransformer.WMS_CAPS_MIME);
            this.handleDcpType(serviceUrl, null);
            this.end("DescribeLayer");
            this.start("GetLegendGraphic");
            for (String format : this.getLegendGraphicFormats) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetLegendGraphic");
            this.start("GetStyles");
            this.element("Format", "application/vnd.ogc.sld+xml");
            this.handleDcpType(serviceUrl, null);
            this.end("GetStyles");
            this.end("Request");
        }

        private void handleDcpType(String getUrl, String postUrl) {
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute("", "xlink:type", "xlink:type", "", "simple");
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", getUrl);
            this.start("DCPType");
            this.start("HTTP");
            if (getUrl != null) {
                this.start("Get");
                this.element("OnlineResource", null, orAtts);
                this.end("Get");
            }
            if (postUrl != null) {
                orAtts.setAttribute(2, "", "xlink:href", "xlink:href", "", postUrl);
                this.start("Post");
                this.element("OnlineResource", null, orAtts);
                this.end("Post");
            }
            this.end("HTTP");
            this.end("DCPType");
        }

        private void handleException() {
            this.start("Exception");
            for (String exceptionFormat : EXCEPTION_FORMATS) {
                this.element("Format", exceptionFormat);
            }
            this.end("Exception");
        }

        private void handleSLD() {
            AttributesImpl sldAtts = new AttributesImpl();
            String supportsSLD = this.wmsConfig.supportsSLD() ? "1" : "0";
            String supportsUserLayer = this.wmsConfig.supportsUserLayer() ? "1" : "0";
            String supportsUserStyle = this.wmsConfig.supportsUserStyle() ? "1" : "0";
            String supportsRemoteWFS = this.wmsConfig.supportsRemoteWFS() ? "1" : "0";
            sldAtts.addAttribute("", "SupportSLD", "SupportSLD", "", supportsSLD);
            sldAtts.addAttribute("", "UserLayer", "UserLayer", "", supportsUserLayer);
            sldAtts.addAttribute("", "UserStyle", "UserStyle", "", supportsUserStyle);
            sldAtts.addAttribute("", "RemoteWFS", "RemoteWFS", "", supportsRemoteWFS);
            this.start("UserDefinedSymbolization", sldAtts);
            this.end("UserDefinedSymbolization");
        }

        private void handleVendorSpecificCapabilities() {
            int numberRoots = 0;
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                List<String> roots = cp.getVendorSpecificCapabilitiesRoots(this.request);
                if (roots == null) continue;
                numberRoots += roots.size();
            }
            if (numberRoots == 0) {
                return;
            }
            this.start("VendorSpecificCapabilities");
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                try {
                    cp.encode(new ExtendedCapabilitiesProvider.Translator(){

                        public void start(String element) {
                            CapabilitiesTranslator.this.start(element);
                        }

                        public void start(String element, Attributes attributes) {
                            CapabilitiesTranslator.this.start(element, attributes);
                        }

                        public void chars(String text) {
                            CapabilitiesTranslator.this.chars(text);
                        }

                        public void end(String element) {
                            CapabilitiesTranslator.this.end(element);
                        }
                    }, this.serviceInfo, this.request);
                }
                catch (Exception e) {
                    throw new ServiceException("Extended capabilities provider threw error", (Throwable)e);
                }
            }
            this.end("VendorSpecificCapabilities");
        }

        private void handleLayers() {
            List<LayerInfo> layers;
            this.start("Layer");
            if (this.request.getNamespace() != null) {
                List<LayerInfo> allLayers = this.wmsConfig.getLayers();
                layers = new ArrayList<LayerInfo>();
                String namespace = this.wmsConfig.getNamespaceByPrefix(this.request.getNamespace());
                for (LayerInfo layer : allLayers) {
                    Name name = layer.getResource().getQualifiedName();
                    if (!name.getNamespaceURI().equals(namespace)) continue;
                    layers.add(layer);
                }
            } else {
                layers = this.wmsConfig.getLayers();
            }
            this.element("Title", this.serviceInfo.getTitle());
            this.element("Abstract", this.serviceInfo.getAbstract());
            List<String> srsList = this.serviceInfo.getSRS();
            HashSet<String> srs = new HashSet<String>();
            if (srsList != null) {
                srs.addAll(srsList);
            }
            for (ExtendedCapabilitiesProvider provider : this.extCapsProviders) {
                provider.customizeRootCrsList(srs);
            }
            this.handleRootCrsList(srs);
            this.handleRootBbox(layers);
            this.handleAuthorityURL(this.serviceInfo.getAuthorityURLs());
            this.handleLayerIdentifiers(this.serviceInfo.getIdentifiers());
            HashSet<LayerInfo> layersAlreadyProcessed = new HashSet();
            try {
                List<LayerGroupInfo> layerGroups = this.wmsConfig.getLayerGroups();
                layersAlreadyProcessed = this.handleLayerGroups(new ArrayList<LayerGroupInfo>(layerGroups));
            }
            catch (Exception e) {
                throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
            }
            LayerTree featuresLayerTree = new LayerTree(layers);
            this.handleLayerTree(featuresLayerTree, layersAlreadyProcessed);
            this.end("Layer");
        }

        private void handleRootCrsList(Set<String> epsgCodes) {
            AbstractSet capabilitiesCrsIdentifiers;
            if (epsgCodes.isEmpty()) {
                this.comment("All supported EPSG projections:");
                capabilitiesCrsIdentifiers = new LinkedHashSet();
                for (String code : CRS.getSupportedCodes((String)"AUTO")) {
                    if ("WGS84(DD)".equals(code)) continue;
                    capabilitiesCrsIdentifiers.add("AUTO:" + code);
                }
                capabilitiesCrsIdentifiers.addAll(CRS.getSupportedCodes((String)"EPSG"));
            } else {
                this.comment("Limited list of EPSG projections:");
                capabilitiesCrsIdentifiers = new TreeSet<String>(epsgCodes);
            }
            try {
                Iterator it = capabilitiesCrsIdentifiers.iterator();
                while (it.hasNext()) {
                    String currentSRS = this.qualifySRS((String)it.next());
                    this.element("SRS", currentSRS);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }

        private void handleRootBbox(Collection<LayerInfo> layers) {
            Envelope latlonBbox = new Envelope();
            ReferencedEnvelope layerBbox = null;
            LOGGER.finer("Collecting summarized latlonbbox and common SRS...");
            for (LayerInfo layer : layers) {
                ResourceInfo resource = layer.getResource();
                layerBbox = resource.getLatLonBoundingBox();
                if (layerBbox == null) continue;
                latlonBbox.expandToInclude((Envelope)layerBbox);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Summarized LatLonBBox is " + latlonBbox);
            }
            this.handleLatLonBBox(latlonBbox);
            this.handleAdditionalBBox(new ReferencedEnvelope(latlonBbox, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), null, null);
        }

        private boolean isExposable(LayerInfo layer) {
            boolean wmsExposable = false;
            if (layer.getType() == PublishedType.RASTER || layer.getType() == PublishedType.WMS) {
                wmsExposable = true;
            } else {
                try {
                    wmsExposable = layer.getType() == PublishedType.VECTOR && ((FeatureTypeInfo)layer.getResource()).getFeatureType().getGeometryDescriptor() != null;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "An error occurred trying to determine if the layer is geometryless", e);
                }
            }
            return wmsExposable;
        }

        private void handleLayerTree(LayerTree layerTree, Set<LayerInfo> layersAlreadyProcessed) {
            ArrayList<LayerInfo> data = new ArrayList<LayerInfo>(layerTree.getData());
            Collection<LayerTree> children = layerTree.getChildrens();
            Collections.sort(data, new Comparator<LayerInfo>(){

                @Override
                public int compare(LayerInfo o1, LayerInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (LayerInfo layer : data) {
                if (!layer.enabled() || layersAlreadyProcessed.contains(layer) || !this.isExposable(layer)) continue;
                try {
                    this.mark();
                    this.handleLayer(layer);
                    this.commit();
                }
                catch (Exception e) {
                    if (this.skipping) {
                        this.reset();
                        LOGGER.log(Level.WARNING, "Error writing metadata; skipping layer: " + layer.getName(), e);
                        continue;
                    }
                    throw new ServiceException("Error occurred trying to write out metadata for layer: " + layer.getName(), (Throwable)e);
                }
            }
            for (LayerTree childLayerTree : children) {
                this.start("Layer");
                this.element("Name", childLayerTree.getName());
                this.element("Title", childLayerTree.getName());
                this.handleLayerTree(childLayerTree, layersAlreadyProcessed);
                this.end("Layer");
            }
        }

        protected void handleLayer(LayerInfo layer) throws IOException {
            ReferencedEnvelope bbox;
            AttributesImpl qatts = new AttributesImpl();
            boolean queryable = this.wmsConfig.isQueryable(layer);
            qatts.addAttribute("", "queryable", "queryable", "", queryable ? "1" : "0");
            boolean opaque = this.wmsConfig.isOpaque(layer);
            qatts.addAttribute("", "opaque", "opaque", "", opaque ? "1" : "0");
            Integer cascaded = this.wmsConfig.getCascadedHopCount(layer);
            if (cascaded != null) {
                qatts.addAttribute("", "cascaded", "cascaded", "", String.valueOf(cascaded));
            }
            this.start("Layer", qatts);
            this.element("Name", layer.prefixedName());
            this.element("Title", layer.getResource().getTitle());
            this.element("Abstract", layer.getResource().getAbstract());
            this.handleKeywordList(layer.getResource().getKeywords());
            String srs = layer.getResource().getSRS();
            this.element("SRS", srs);
            try {
                bbox = layer.getResource().boundingBox();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error obtaining bounding box for layer " + layer.getName(), e);
            }
            ReferencedEnvelope llbbox = layer.getResource().getLatLonBoundingBox();
            this.handleLatLonBBox((Envelope)llbbox);
            if (bbox != null) {
                this.handleBBox((Envelope)bbox, srs);
                this.handleAdditionalBBox(bbox, srs, layer);
            }
            if (layer.getType() == PublishedType.VECTOR) {
                this.dimensionHelper.handleVectorLayerDimensions(layer);
            } else if (layer.getType() == PublishedType.RASTER) {
                this.dimensionHelper.handleRasterLayerDimensions(layer);
            }
            this.handleAttribution(layer);
            this.handleAuthorityURL(layer.getAuthorityURLs());
            this.handleLayerIdentifiers(layer.getIdentifiers());
            this.handleMetadataList(layer.getResource().getMetadataLinks());
            this.handleDataList(layer.getResource().getDataLinks());
            if (!(layer.getResource() instanceof WMSLayerInfo)) {
                Style ftStyle;
                this.start("Style");
                StyleInfo defaultStyle = layer.getDefaultStyle();
                if (defaultStyle == null) {
                    throw new NullPointerException("Layer " + layer.getName() + " has no default style");
                }
                try {
                    ftStyle = defaultStyle.getStyle();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.element("Name", defaultStyle.prefixedName());
                if (ftStyle.getDescription() != null) {
                    this.element("Title", ftStyle.getDescription().getTitle());
                    this.element("Abstract", ftStyle.getDescription().getAbstract());
                }
                this.handleLegendURL(layer, layer.getLegend(), null, layer.getDefaultStyle());
                this.end("Style");
                Set styles = layer.getStyles();
                for (StyleInfo styleInfo : styles) {
                    try {
                        ftStyle = styleInfo.getStyle();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.start("Style");
                    this.element("Name", styleInfo.prefixedName());
                    if (ftStyle.getDescription() != null) {
                        this.element("Title", ftStyle.getDescription().getTitle());
                        this.element("Abstract", ftStyle.getDescription().getAbstract());
                    }
                    this.handleLegendURL(layer, null, styleInfo, styleInfo);
                    this.end("Style");
                }
            }
            this.handleScaleHint(layer);
            this.end("Layer");
        }

        private void element(String element, InternationalString is) {
            if (is != null) {
                this.element(element, is.toString());
            }
        }

        private void handleScaleHint(LayerInfo layer) {
            try {
                Double maxScaleHint;
                Double minScaleHint;
                boolean scaleUnitPixel;
                NumberRange<Double> scaleDenominators = CapabilityUtil.searchMinMaxScaleDenominator(layer);
                for (ExtendedCapabilitiesProvider provider : this.extCapsProviders) {
                    scaleDenominators = provider.overrideScaleDenominators(layer, scaleDenominators);
                }
                if (scaleDenominators.getMinimum() == 0.0 && scaleDenominators.getMaximum() == Double.POSITIVE_INFINITY) {
                    return;
                }
                boolean bl = scaleUnitPixel = this.wmsConfig.getScalehintUnitPixel() != null && this.wmsConfig.getScalehintUnitPixel() != false;
                if (scaleUnitPixel) {
                    minScaleHint = CapabilityUtil.computeScaleHint((Double)scaleDenominators.getMinValue());
                    maxScaleHint = CapabilityUtil.computeScaleHint((Double)scaleDenominators.getMaxValue());
                } else {
                    minScaleHint = (Double)scaleDenominators.getMinValue();
                    maxScaleHint = (Double)scaleDenominators.getMaxValue();
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", MIN_DENOMINATOR_ATTR, MIN_DENOMINATOR_ATTR, "", String.valueOf(minScaleHint));
                attrs.addAttribute("", MAX_DENOMINATOR_ATTR, MAX_DENOMINATOR_ATTR, "", String.valueOf(maxScaleHint));
                this.element("ScaleHint", null, attrs);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }

        private String qualifySRS(String srs) {
            if (srs.indexOf(58) == -1) {
                srs = EPSG + srs;
            }
            return srs;
        }

        protected void handleLayerGroup(LayerGroupInfo layerGroup, Set<LayerInfo> layersAlreadyProcessed) throws TransformException, FactoryException, IOException {
            String layerName = layerGroup.prefixedName();
            AttributesImpl qatts = new AttributesImpl();
            boolean queryable = this.wmsConfig.isQueryable(layerGroup);
            qatts.addAttribute("", "queryable", "queryable", "", queryable ? "1" : "0");
            this.start("Layer", qatts);
            if (!LayerGroupInfo.Mode.CONTAINER.equals((Object)layerGroup.getMode())) {
                this.element("Name", layerName);
            }
            if (StringUtils.isEmpty((String)layerGroup.getTitle())) {
                this.element("Title", layerName);
            } else {
                this.element("Title", layerGroup.getTitle());
            }
            if (StringUtils.isEmpty((String)layerGroup.getAbstract())) {
                this.element("Abstract", "Layer-Group type layer: " + layerName);
            } else {
                this.element("Abstract", layerGroup.getAbstract());
            }
            ReferencedEnvelope layerGroupBounds = layerGroup.getBounds();
            ReferencedEnvelope latLonBounds = layerGroupBounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            String authority = layerGroupBounds.getCoordinateReferenceSystem().getIdentifiers().toArray()[0].toString();
            this.element("SRS", authority);
            this.handleLatLonBBox((Envelope)latLonBounds);
            this.handleBBox((Envelope)layerGroupBounds, authority);
            if (LayerGroupInfo.Mode.EO.equals((Object)layerGroup.getMode())) {
                LayerInfo rootLayer = layerGroup.getRootLayer();
                if (rootLayer.getType() == PublishedType.VECTOR) {
                    this.dimensionHelper.handleVectorLayerDimensions(rootLayer);
                } else if (rootLayer.getType() == PublishedType.RASTER) {
                    this.dimensionHelper.handleRasterLayerDimensions(rootLayer);
                }
                layersAlreadyProcessed.add(layerGroup.getRootLayer());
            }
            this.handleAuthorityURL(layerGroup.getAuthorityURLs());
            this.handleLayerIdentifiers(layerGroup.getIdentifiers());
            HashSet<MetadataLinkInfo> aggregatedLinks = new HashSet<MetadataLinkInfo>();
            for (LayerInfo layer : Iterables.filter((Iterable)layerGroup.getLayers(), LayerInfo.class)) {
                List metadataLinks = layer.getResource().getMetadataLinks();
                if (metadataLinks == null) continue;
                aggregatedLinks.addAll(metadataLinks);
            }
            this.handleMetadataList(aggregatedLinks);
            if (!LayerGroupInfo.Mode.SINGLE.equals((Object)layerGroup.getMode())) {
                for (PublishedInfo child : layerGroup.getLayers()) {
                    if (child instanceof LayerInfo) {
                        LayerInfo layer = (LayerInfo)child;
                        if (!this.isExposable(layer)) continue;
                        this.handleLayer((LayerInfo)child);
                        layersAlreadyProcessed.add((LayerInfo)child);
                        continue;
                    }
                    this.handleLayerGroup((LayerGroupInfo)child, layersAlreadyProcessed);
                }
            }
            this.end("Layer");
        }

        protected Set<LayerInfo> handleLayerGroups(List<LayerGroupInfo> layerGroups) throws FactoryException, TransformException, IOException {
            HashSet<LayerInfo> layersAlreadyProcessed = new HashSet<LayerInfo>();
            if (layerGroups == null || layerGroups.size() == 0) {
                return layersAlreadyProcessed;
            }
            List<LayerGroupInfo> topLevelGropus = this.filterNestedGroups(layerGroups);
            for (LayerGroupInfo layerGroup : topLevelGropus) {
                try {
                    this.mark();
                    this.handleLayerGroup(layerGroup, layersAlreadyProcessed);
                    this.commit();
                }
                catch (Exception e) {
                    if (this.skipping) {
                        if (layerGroup != null) {
                            LOGGER.log(Level.WARNING, "Skipping layer group " + layerGroup.getName() + " as its caps document element failed to generate", e);
                        } else {
                            LOGGER.log(Level.WARNING, "Skipping a null layer group during caps during caps document generation", e);
                        }
                        this.reset();
                        continue;
                    }
                    throw new ServiceException("Error occurred trying to write out metadata for layer group: " + layerGroup.getName(), (Throwable)e);
                }
            }
            return layersAlreadyProcessed;
        }

        private List<LayerGroupInfo> filterNestedGroups(List<LayerGroupInfo> allGroups) {
            LinkedHashSet<LayerGroupInfo> result = new LinkedHashSet<LayerGroupInfo>(allGroups);
            for (LayerGroupInfo group : allGroups) {
                for (PublishedInfo pi : group.getLayers()) {
                    if (!(pi instanceof LayerGroupInfo)) continue;
                    result.remove(pi);
                }
            }
            return new ArrayList<LayerGroupInfo>(result);
        }

        protected void handleAttribution(LayerInfo layer) {
            boolean logoGood;
            AttributionInfo attribution = layer.getAttribution();
            String title = attribution.getTitle();
            String url = attribution.getHref();
            String logoURL = attribution.getLogoURL();
            String logoType = attribution.getLogoType();
            int logoWidth = attribution.getLogoWidth();
            int logoHeight = attribution.getLogoHeight();
            boolean titleGood = title != null;
            boolean urlGood = url != null;
            boolean bl = logoGood = logoURL != null && logoType != null && logoWidth > 0 && logoHeight > 0;
            if (titleGood || urlGood || logoGood) {
                this.start("Attribution");
                if (titleGood) {
                    this.element("Title", title);
                }
                if (urlGood) {
                    AttributesImpl urlAttributes = new AttributesImpl();
                    urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                    urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                    urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", url);
                    this.element("OnlineResource", null, urlAttributes);
                }
                if (logoGood) {
                    AttributesImpl logoAttributes = new AttributesImpl();
                    logoAttributes.addAttribute("", "", "height", "", "" + logoHeight);
                    logoAttributes.addAttribute("", "", "width", "", "" + logoWidth);
                    this.start("LogoURL", logoAttributes);
                    this.element("Format", logoType);
                    AttributesImpl urlAttributes = new AttributesImpl();
                    urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                    urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                    urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", logoURL);
                    this.element("OnlineResource", null, urlAttributes);
                    this.end("LogoURL");
                }
                this.end("Attribution");
            }
        }

        protected void handleLegendURL(LayerInfo layer, LegendInfo legend, StyleInfo style, StyleInfo sampleStyle) {
            if (legend != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("using user supplied legend URL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(legend.getWidth()));
                attrs.addAttribute("", "height", "height", "", String.valueOf(legend.getHeight()));
                this.start("LegendURL", attrs);
                this.element("Format", legend.getFormat());
                attrs.clear();
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legend.getOnlineResource());
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            } else {
                String defaultFormat;
                int legendWidth = 20;
                int legendHeight = 20;
                if (sampleStyle != null) {
                    try {
                        Dimension dimension = this.legendSample.getLegendURLSize(sampleStyle);
                        if (dimension != null) {
                            legendWidth = (int)dimension.getWidth();
                            legendHeight = (int)dimension.getHeight();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error getting LegendURL dimensions from sample", e);
                    }
                }
                if (null == this.wmsConfig.getLegendGraphicOutputFormat(defaultFormat = "image/png")) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning(new StringBuffer("Default legend format (").append(defaultFormat).append(")is not supported (jai not available?), can't add LegendURL element").toString());
                    }
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding GetLegendGraphic call as LegendURL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(legendWidth));
                attrs.addAttribute("", "height", "height", "", String.valueOf(legendHeight));
                this.start("LegendURL", attrs);
                this.element("Format", defaultFormat);
                attrs.clear();
                String layerName = layer.prefixedName();
                Map params = org.geoserver.ows.util.ResponseUtils.params((String[])new String[]{"request", "GetLegendGraphic", "format", defaultFormat, "width", String.valueOf(20), "height", String.valueOf(20), "layer", layerName});
                if (style != null) {
                    params.put("style", style.getName());
                }
                String legendURL = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wms", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legendURL);
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            }
        }

        private void handleLatLonBBox(Envelope bbox) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("LatLonBoundingBox", null, bboxAtts);
        }

        private void handleBBox(Envelope bbox, String SRS) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "SRS", "SRS", "", SRS);
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("BoundingBox", null, bboxAtts);
        }

        private void handleAdditionalBBox(ReferencedEnvelope bbox, String srs, LayerInfo layer) {
            if (this.serviceInfo.isBBOXForEachCRS().booleanValue() && !this.serviceInfo.getSRS().isEmpty()) {
                for (String crs : this.serviceInfo.getSRS()) {
                    crs = this.qualifySRS(crs);
                    if (srs != null && crs.equals(srs)) continue;
                    try {
                        ReferencedEnvelope tbbox = bbox.transform(CRS.decode((String)crs), true);
                        this.handleBBox((Envelope)tbbox, crs);
                    }
                    catch (Exception e) {
                        LOGGER.warning(String.format("Unable to transform bounding box for '%s' layer to %s", layer != null ? layer.getName() : "root", srs));
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }

        private void handleAuthorityURL(List<AuthorityURLInfo> authorityURLs) {
            if (authorityURLs == null || authorityURLs.isEmpty()) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            for (AuthorityURLInfo url : authorityURLs) {
                String name = url.getName();
                String href = url.getHref();
                if (name == null || href == null) {
                    LOGGER.warning("Ignoring AuthorityURL, name: " + name + ", href: " + href);
                    continue;
                }
                atts.clear();
                atts.addAttribute("", "name", "name", "", name);
                this.start("AuthorityURL", atts);
                atts.clear();
                atts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                atts.addAttribute("", "xlink:href", "xlink:href", "", href);
                this.element("OnlineResource", null, atts);
                this.end("AuthorityURL");
            }
        }

        private void handleLayerIdentifiers(List<LayerIdentifierInfo> identifiers) {
            if (identifiers == null || identifiers.isEmpty()) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            for (LayerIdentifierInfo identifier : identifiers) {
                String authority = identifier.getAuthority();
                String id = identifier.getIdentifier();
                if (authority == null || id == null) {
                    LOGGER.warning("Ignoring layer Identifier, authority: " + authority + ", identifier: " + id);
                    continue;
                }
                atts.clear();
                atts.addAttribute("", "authority", "authority", "", authority);
                this.element("Identifier", id, atts);
            }
        }

        static {
            wmsVersion.addAttribute("", "version", "version", "", "1.1.1");
        }
    }
}

