/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.ISO8601Formatter;
import org.geoserver.wms.WMS;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.feature.type.DateUtil;
import org.geotools.temporal.object.DefaultPeriodDuration;
import org.geotools.util.Converters;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

abstract class DimensionHelper {
    static final Logger LOGGER = Logging.getLogger(DimensionHelper.class);
    Mode mode;
    WMS wms;

    public DimensionHelper(Mode mode, WMS wms) {
        this.mode = mode;
        this.wms = wms;
    }

    protected abstract void element(String var1, String var2);

    protected abstract void element(String var1, String var2, Attributes var3);

    void handleVectorLayerDimensions(LayerInfo layer) {
        boolean hasElevation;
        FeatureTypeInfo typeInfo = (FeatureTypeInfo)layer.getResource();
        DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        DimensionInfo elevInfo = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        boolean hasTime = timeInfo != null && timeInfo.isEnabled();
        boolean bl = hasElevation = elevInfo != null && elevInfo.isEnabled();
        if (!hasTime && !hasElevation) {
            return;
        }
        if (this.mode == Mode.WMS11) {
            String elevUnits = hasElevation ? elevInfo.getUnits() : "";
            String elevUnitSymbol = hasElevation ? elevInfo.getUnitSymbol() : "";
            this.declareWMS11Dimensions(hasTime, hasElevation, elevUnits, elevUnitSymbol, null);
        }
        if (hasTime) {
            try {
                this.handleTimeDimensionVector(typeInfo);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to handle time attribute for layer", e);
            }
        }
        if (hasElevation) {
            try {
                this.handleElevationDimensionVector(typeInfo);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void handleRasterLayerDimensions(LayerInfo layer) throws RuntimeException, IOException {
        boolean hasCustomDimensions;
        CoverageInfo cvInfo = (CoverageInfo)layer.getResource();
        if (cvInfo == null) {
            throw new ServiceException("Unable to acquire coverage resource for layer: " + layer.getName());
        }
        DimensionInfo timeInfo = null;
        DimensionInfo elevInfo = null;
        HashMap<String, DimensionInfo> customDimensions = new HashMap<String, DimensionInfo>();
        GridCoverage2DReader reader = null;
        for (Map.Entry e : cvInfo.getMetadata().entrySet()) {
            DimensionInfo dimInfo;
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (key.equals("time")) {
                timeInfo = (DimensionInfo)Converters.convert(value, DimensionInfo.class);
                continue;
            }
            if (key.equals("elevation")) {
                elevInfo = (DimensionInfo)Converters.convert(value, DimensionInfo.class);
                continue;
            }
            if (!(value instanceof DimensionInfo) || !(dimInfo = (DimensionInfo)value).isEnabled()) continue;
            if (key.startsWith("custom_dimension_")) {
                String dimensionName = key.substring("custom_dimension_".length());
                customDimensions.put(dimensionName, dimInfo);
                continue;
            }
            LOGGER.log(Level.SEVERE, "Skipping custom  dimension with key " + key + " since it does not start with " + "custom_dimension_");
        }
        boolean hasTime = timeInfo != null && timeInfo.isEnabled();
        boolean hasElevation = elevInfo != null && elevInfo.isEnabled();
        boolean bl = hasCustomDimensions = !customDimensions.isEmpty();
        if (!(hasTime || hasElevation || hasCustomDimensions)) {
            return;
        }
        Catalog catalog = cvInfo.getCatalog();
        if (catalog == null) {
            throw new ServiceException("Unable to acquire catalog resource for layer: " + layer.getName());
        }
        CoverageStoreInfo csinfo = cvInfo.getStore();
        if (csinfo == null) {
            throw new ServiceException("Unable to acquire coverage store resource for layer: " + layer.getName());
        }
        try {
            reader = (GridCoverage2DReader)cvInfo.getGridCoverageReader(null, null);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName(), t);
        }
        if (reader == null) {
            throw new ServiceException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
        }
        ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
        if (hasCustomDimensions) {
            for (String key : customDimensions.keySet()) {
                if (dimensions.hasDomain(key)) continue;
                customDimensions.remove(key);
            }
        }
        if (this.mode == Mode.WMS11) {
            String elevUnits = hasElevation ? elevInfo.getUnits() : "";
            String elevUnitSymbol = hasElevation ? elevInfo.getUnitSymbol() : "";
            this.declareWMS11Dimensions(hasTime, hasElevation, elevUnits, elevUnitSymbol, customDimensions);
        }
        if (hasTime && dimensions.hasTime()) {
            this.handleTimeDimensionRaster(cvInfo, timeInfo, dimensions);
        }
        if (hasElevation && dimensions.hasElevation()) {
            this.handleElevationDimensionRaster(cvInfo, elevInfo, dimensions);
        }
        if (hasCustomDimensions) {
            for (String key : customDimensions.keySet()) {
                DimensionInfo dimensionInfo = (DimensionInfo)customDimensions.get(key);
                this.handleCustomDimensionRaster(cvInfo, key, dimensionInfo, dimensions);
            }
        }
    }

    private void handleElevationDimensionRaster(CoverageInfo cvInfo, DimensionInfo elevInfo, ReaderDimensionsAccessor dimensions) throws IOException {
        TreeSet elevations = dimensions.getElevationDomain();
        String elevationMetadata = this.getZDomainRepresentation(elevInfo, elevations);
        Double defaultValue = this.wms.getDefaultElevation((ResourceInfo)cvInfo);
        if (defaultValue == null) {
            defaultValue = 0.0;
        }
        this.writeElevationDimension(elevations, elevationMetadata, elevInfo.getUnits(), elevInfo.getUnitSymbol(), defaultValue);
    }

    private void handleTimeDimensionRaster(CoverageInfo cvInfo, DimensionInfo timeInfo, ReaderDimensionsAccessor dimension) throws IOException {
        TreeSet temporalDomain = dimension.getTimeDomain();
        String timeMetadata = this.getTemporalDomainRepresentation(timeInfo, temporalDomain);
        Date defaultValue = null;
        DimensionDefaultValueSetting defaultSetting = timeInfo.getDefaultValue();
        if (!(defaultSetting == null || defaultSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.NEAREST && defaultSetting.getReferenceValue().equalsIgnoreCase(DimensionDefaultValueSetting.TIME_CURRENT))) {
            defaultValue = this.wms.getDefaultTime((ResourceInfo)cvInfo);
        }
        this.writeTimeDimension(timeMetadata, defaultValue);
    }

    private void handleCustomDimensionRaster(CoverageInfo cvInfo, String dimName, DimensionInfo dimension, ReaderDimensionsAccessor dimAccessor) throws IOException {
        List values = dimAccessor.getDomain(dimName);
        String metadata = this.getCustomDomainRepresentation(dimension, values);
        String defaultValue = this.wms.getDefaultCustomDimensionValue(dimName, (ResourceInfo)cvInfo, String.class);
        this.writeCustomDimension(dimName, metadata, defaultValue, dimension.getUnits(), dimension.getUnitSymbol());
    }

    private void declareWMS11Dimensions(boolean hasTime, boolean hasElevation, String elevUnits, String elevUnitSymbol, Map<String, DimensionInfo> customDimensions) {
        if (hasTime) {
            AttributesImpl timeDim = new AttributesImpl();
            timeDim.addAttribute("", "name", "name", "", "time");
            timeDim.addAttribute("", "units", "units", "", "ISO8601");
            this.element("Dimension", null, timeDim);
        }
        if (hasElevation) {
            this.writeElevationDimensionElement(null, null, elevUnits, elevUnitSymbol);
        }
        if (customDimensions != null) {
            for (String dim : customDimensions.keySet()) {
                DimensionInfo di = customDimensions.get(dim);
                AttributesImpl custDim = new AttributesImpl();
                custDim.addAttribute("", "name", "name", "", dim);
                String units = di.getUnits();
                String unitSymbol = di.getUnitSymbol();
                custDim.addAttribute("", "units", "units", "", units != null ? units : "");
                if (unitSymbol != null) {
                    custDim.addAttribute("", "unitSymbol", "unitSymbol", "", unitSymbol);
                }
                this.element("Dimension", null, custDim);
            }
        }
    }

    protected String getZDomainRepresentation(DimensionInfo dimension, TreeSet<? extends Object> values) {
        String elevationMetadata = null;
        StringBuilder buff = new StringBuilder();
        if (DimensionPresentation.LIST == dimension.getPresentation()) {
            for (Object object : values) {
                if (object instanceof Double) {
                    buff.append(object);
                } else {
                    NumberRange range = (NumberRange)object;
                    buff.append(range.getMinimum()).append("/").append(range.getMaximum()).append("/0");
                }
                buff.append(",");
            }
            elevationMetadata = buff.substring(0, buff.length() - 1).replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(" ", "");
        } else if (DimensionPresentation.CONTINUOUS_INTERVAL == dimension.getPresentation()) {
            NumberRange<Double> range = this.getMinMaxZInterval(values);
            buff.append(range.getMinimum());
            buff.append("/");
            buff.append(range.getMaximum());
            buff.append("/0");
            elevationMetadata = buff.toString();
        } else if (DimensionPresentation.DISCRETE_INTERVAL == dimension.getPresentation()) {
            NumberRange<Double> range = this.getMinMaxZInterval(values);
            buff.append(range.getMinimum());
            buff.append("/");
            buff.append(range.getMaximum());
            buff.append("/");
            BigDecimal bigDecimal = dimension.getResolution();
            if (bigDecimal != null) {
                buff.append(bigDecimal.doubleValue());
            } else if (values.size() >= 2 && this.allDoubles(values)) {
                int count = 2;
                int i = 2;
                Double[] zPositions = new Double[count];
                for (Object object : values) {
                    zPositions[count - i--] = (Double)object;
                    if (i != 0) continue;
                    break;
                }
                double span = zPositions[count - 1] - zPositions[count - 2];
                buff.append(span);
            } else {
                buff.append(0);
            }
            elevationMetadata = buff.toString();
        }
        return elevationMetadata;
    }

    String getTemporalDomainRepresentation(DimensionInfo dimension, TreeSet<? extends Object> values) {
        String timeMetadata = null;
        StringBuilder buff = new StringBuilder();
        ISO8601Formatter df = new ISO8601Formatter();
        if (DimensionPresentation.LIST == dimension.getPresentation()) {
            for (Object object : values) {
                buff.append(df.format(object));
                buff.append(",");
            }
            timeMetadata = buff.substring(0, buff.length() - 1).replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(" ", "");
        } else if (DimensionPresentation.CONTINUOUS_INTERVAL == dimension.getPresentation()) {
            DateRange interval = this.getMinMaxTimeInterval(values);
            buff.append(df.format(interval.getMinValue()));
            buff.append("/");
            buff.append(df.format(interval.getMaxValue()));
            buff.append("/PT1S");
            timeMetadata = buff.toString();
        } else if (DimensionPresentation.DISCRETE_INTERVAL == dimension.getPresentation()) {
            DateRange interval = this.getMinMaxTimeInterval(values);
            buff.append(df.format(interval.getMinValue()));
            buff.append("/");
            buff.append(df.format(interval.getMaxValue()));
            buff.append("/");
            BigDecimal bigDecimal = dimension.getResolution();
            if (bigDecimal != null) {
                buff.append(new DefaultPeriodDuration(bigDecimal.longValue()).toString());
            } else if (values.size() >= 2 && this.allDates(values)) {
                int count = 2;
                int i = 2;
                Date[] timePositions = new Date[count];
                for (Object object : values) {
                    timePositions[count - i--] = (Date)object;
                    if (i != 0) continue;
                    break;
                }
                long durationInMilliSeconds = timePositions[count - 1].getTime() - timePositions[count - 2].getTime();
                buff.append(new DefaultPeriodDuration(durationInMilliSeconds).toString());
            } else {
                buff.append("PT1S");
            }
            timeMetadata = buff.toString();
        }
        return timeMetadata;
    }

    private DateRange getMinMaxTimeInterval(TreeSet<? extends Object> values) {
        Object minValue = values.first();
        Object maxValue = values.last();
        Date min = minValue instanceof DateRange ? ((DateRange)minValue).getMinValue() : (Date)minValue;
        Date max = maxValue instanceof DateRange ? ((DateRange)maxValue).getMaxValue() : (Date)maxValue;
        return new DateRange(min, max);
    }

    private NumberRange<Double> getMinMaxZInterval(TreeSet<? extends Object> values) {
        Object minValue = values.first();
        Object maxValue = values.last();
        Double min = minValue instanceof NumberRange ? (Double)((NumberRange)minValue).getMinValue() : (Double)minValue;
        Double max = maxValue instanceof NumberRange ? (Double)((NumberRange)maxValue).getMaxValue() : (Double)maxValue;
        return new NumberRange(Double.class, (Number)min, (Number)max);
    }

    private boolean allDates(TreeSet<? extends Object> values) {
        for (Object object : values) {
            if (object instanceof Date) continue;
            return false;
        }
        return true;
    }

    private boolean allDoubles(TreeSet<? extends Object> values) {
        for (Object object : values) {
            if (object instanceof Double) continue;
            return false;
        }
        return true;
    }

    String getCustomDomainRepresentation(DimensionInfo dimension, List<String> values) {
        String metadata = null;
        StringBuilder buff = new StringBuilder();
        if (DimensionPresentation.LIST == dimension.getPresentation()) {
            for (String value : values) {
                buff.append(value.trim());
                buff.append(",");
            }
            metadata = buff.substring(0, buff.length() - 1);
        } else if (DimensionPresentation.DISCRETE_INTERVAL == dimension.getPresentation()) {
            buff.append(values.get(0));
            buff.append("/");
            buff.append(values.get(0));
            buff.append("/");
            BigDecimal resolution = dimension.getResolution();
            if (resolution != null) {
                buff.append(resolution);
            }
            metadata = buff.toString();
        }
        return metadata;
    }

    private void handleTimeDimensionVector(FeatureTypeInfo typeInfo) throws IOException {
        String timeMetadata;
        TreeSet<Date> values = this.wms.getFeatureTypeTimes(typeInfo);
        Date defaultValue = null;
        if (values != null && !values.isEmpty()) {
            DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
            timeMetadata = this.getTemporalDomainRepresentation(timeInfo, values);
            DimensionDefaultValueSetting defaultSetting = timeInfo.getDefaultValue();
            if (!(defaultSetting == null || defaultSetting.getStrategyType() == DimensionDefaultValueSetting.Strategy.NEAREST && defaultSetting.getReferenceValue().equalsIgnoreCase(DimensionDefaultValueSetting.TIME_CURRENT))) {
                defaultValue = this.wms.getDefaultTime((ResourceInfo)typeInfo);
            }
        } else {
            timeMetadata = "";
        }
        this.writeTimeDimension(timeMetadata, defaultValue);
    }

    private void handleElevationDimensionVector(FeatureTypeInfo typeInfo) throws IOException {
        TreeSet<Double> elevations = this.wms.getFeatureTypeElevations(typeInfo);
        DimensionInfo di = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        String units = di.getUnits();
        String unitSymbol = di.getUnitSymbol();
        String elevationMetadata = elevations != null && !elevations.isEmpty() ? this.getZDomainRepresentation(di, elevations) : "";
        Double defaultValue = this.wms.getDefaultElevation((ResourceInfo)typeInfo);
        if (defaultValue == null) {
            defaultValue = 0.0;
        }
        this.writeElevationDimension(elevations, elevationMetadata, units, unitSymbol, defaultValue);
    }

    private void writeTimeDimension(String timeMetadata, Date defaultValue) {
        AttributesImpl timeDim = new AttributesImpl();
        String defaultTimeStr = DimensionDefaultValueSetting.TIME_CURRENT;
        if (defaultValue != null) {
            defaultTimeStr = DateUtil.serializeDateTime((long)defaultValue.getTime(), (boolean)true);
        }
        if (this.mode == Mode.WMS11) {
            timeDim.addAttribute("", "name", "name", "", "time");
            timeDim.addAttribute("", "default", "default", "", defaultTimeStr);
            this.element("Extent", timeMetadata, timeDim);
        } else {
            timeDim.addAttribute("", "name", "name", "", "time");
            timeDim.addAttribute("", "default", "default", "", defaultTimeStr);
            timeDim.addAttribute("", "units", "units", "", "ISO8601");
            this.element("Dimension", timeMetadata, timeDim);
        }
    }

    private void writeElevationDimension(TreeSet<? extends Object> elevations, String elevationMetadata, String units, String unitSymbol, double defaultValue) {
        if (this.mode == Mode.WMS11) {
            AttributesImpl elevDim = new AttributesImpl();
            elevDim.addAttribute("", "name", "name", "", "elevation");
            elevDim.addAttribute("", "default", "default", "", Double.toString(defaultValue));
            this.element("Extent", elevationMetadata, elevDim);
        } else {
            this.writeElevationDimensionElement(elevationMetadata, defaultValue, units, unitSymbol);
        }
    }

    private void writeElevationDimensionElement(String elevationMetadata, Double defaultValue, String units, String unitSymbol) {
        String unitSymNotNull;
        AttributesImpl elevDim = new AttributesImpl();
        String unitsNotNull = units;
        String string = unitSymNotNull = unitSymbol == null ? "" : unitSymbol;
        if (units == null) {
            unitsNotNull = "EPSG:5030";
            unitSymNotNull = "m";
        }
        elevDim.addAttribute("", "name", "name", "", "elevation");
        if (defaultValue != null) {
            elevDim.addAttribute("", "default", "default", "", Double.toString(defaultValue));
        }
        elevDim.addAttribute("", "units", "units", "", unitsNotNull);
        if (!"".equals(unitsNotNull) && !"".equals(unitSymNotNull)) {
            elevDim.addAttribute("", "unitSymbol", "unitSymbol", "", unitSymNotNull);
        }
        this.element("Dimension", elevationMetadata, elevDim);
    }

    private void writeCustomDimension(String name, String metadata, String defaultValue, String unit, String unitSymbol) {
        AttributesImpl dim = new AttributesImpl();
        dim.addAttribute("", "name", "name", "", name);
        if (this.mode == Mode.WMS11) {
            if (defaultValue != null) {
                dim.addAttribute("", "default", "default", "", defaultValue);
            }
            this.element("Extent", metadata, dim);
        } else {
            if (defaultValue != null) {
                dim.addAttribute("", "default", "default", "", defaultValue);
            }
            dim.addAttribute("", "units", "units", "", unit != null ? unit : "");
            if (unitSymbol != null && !"".equals(unitSymbol)) {
                dim.addAttribute("", "unitSymbol", "unitSymbol", "", unitSymbol);
            }
            this.element("Dimension", metadata, dim);
        }
    }

    static enum Mode {
        WMS11,
        WMS13;

    }
}

