/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.util.HashSet;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.util.NumberRange;

final class CapabilityUtil {
    private CapabilityUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NumberRange<Double> searchMinMaxScaleDenominator(LayerInfo layer) throws IOException {
        StyleInfo defaultStyle;
        HashSet<StyleInfo> stylesCopy;
        LayerInfo layerInfo = layer;
        synchronized (layerInfo) {
            stylesCopy = new HashSet<StyleInfo>(layer.getStyles());
            defaultStyle = layer.getDefaultStyle();
        }
        if (!stylesCopy.contains(defaultStyle)) {
            stylesCopy.add(defaultStyle);
        }
        double minScaleDenominator = Double.POSITIVE_INFINITY;
        double maxScaleDenominator = Double.NEGATIVE_INFINITY;
        for (StyleInfo styleInfo : stylesCopy) {
            Style style = styleInfo.getStyle();
            for (FeatureTypeStyle fts : style.featureTypeStyles()) {
                for (Rule rule : fts.rules()) {
                    if (rule.getMinScaleDenominator() < minScaleDenominator) {
                        minScaleDenominator = rule.getMinScaleDenominator();
                    }
                    if (!(rule.getMaxScaleDenominator() > maxScaleDenominator)) continue;
                    maxScaleDenominator = rule.getMaxScaleDenominator();
                }
            }
        }
        if (minScaleDenominator == Double.POSITIVE_INFINITY) {
            minScaleDenominator = 0.0;
        }
        if (maxScaleDenominator == Double.NEGATIVE_INFINITY) {
            maxScaleDenominator = Double.POSITIVE_INFINITY;
        }
        assert (minScaleDenominator <= maxScaleDenominator) : "Min <= Max scale is expected";
        return new NumberRange(Double.class, (Number)minScaleDenominator, (Number)maxScaleDenominator);
    }

    public static Double computeScaleHint(Double scaleDenominator) {
        Double sizeStandardRenderPixel = 2.8E-4;
        Double scaleHint = Math.sqrt(Math.pow(scaleDenominator * sizeStandardRenderPixel, 2.0) * 2.0);
        return scaleHint;
    }
}

