/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Request;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSPartialMapException;
import org.geoserver.wms.map.RenderedImageMap;
import org.geotools.util.Version;

public class WMSServiceExceptionHandler
extends ServiceExceptionHandler {
    static final Set<String> FORMATS = new HashSet<String>(Arrays.asList("image/png", "image/png8", "image/gif", "image/jpeg"));
    static final Map<String, String> IMAGEIO_FORMATS = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("image/png", "png");
            this.put("image/png8", "png");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpeg");
        }
    };
    private GeoServer geoServer;

    public WMSServiceExceptionHandler(List services, GeoServer geoServer) {
        super(services);
        this.geoServer = geoServer;
    }

    public void handleServiceException(ServiceException exception, Request request) {
        block15: {
            String exceptions;
            try {
                exceptions = (String)request.getKvp().get("EXCEPTIONS");
                if (exceptions == null) {
                    this.handleXmlException(exception, request);
                    return;
                }
            }
            catch (Exception e) {
                this.handleXmlException(exception, request);
                return;
            }
            boolean verbose = this.geoServer.getSettings().isVerboseExceptions();
            String charset = this.geoServer.getSettings().getCharset();
            if (JSONType.isJsonMimeType((String)exceptions)) {
                JSONType.handleJsonException((Logger)LOGGER, (ServiceException)exception, (Request)request, (String)charset, (boolean)verbose, (boolean)false);
                return;
            }
            if (JSONType.useJsonp((String)exceptions)) {
                JSONType.handleJsonException((Logger)LOGGER, (ServiceException)exception, (Request)request, (String)charset, (boolean)verbose, (boolean)true);
                return;
            }
            if (WMSServiceExceptionHandler.isImageExceptionType(exceptions)) {
                try {
                    int width = (Integer)request.getKvp().get("WIDTH");
                    int height = (Integer)request.getKvp().get("HEIGHT");
                    String format = (String)request.getKvp().get("FORMAT");
                    Color bgcolor = (Color)request.getKvp().get("BGCOLOR");
                    Boolean transparent = (Boolean)request.getKvp().get("TRANSPARENT");
                    if (width > 0 && height > 0 && FORMATS.contains(format)) {
                        this.handleImageException(exception, request, width, height, format, exceptions, bgcolor, transparent);
                        return;
                    }
                    this.handleXmlException(exception, request);
                }
                catch (Exception e) {
                    this.handleXmlException(exception, request);
                }
            } else if (WMSServiceExceptionHandler.isPartialMapExceptionType(exceptions)) {
                try {
                    String format = (String)request.getKvp().get("FORMAT");
                    if (exception instanceof WMSPartialMapException && FORMATS.contains(format)) {
                        this.handlePartialMapException(exception, request, format);
                        break block15;
                    }
                    this.handleXmlException(exception, request);
                }
                catch (Exception e) {
                    this.handleXmlException(exception, request);
                }
            } else {
                this.handleXmlException(exception, request);
            }
        }
    }

    public static boolean isImageExceptionType(String exceptions) {
        return "application/vnd.ogc.se_inimage".equals(exceptions) || "INIMAGE".equals(exceptions) || "BLANK".equals(exceptions) || "application/vnd.ogc.se_blank".equals(exceptions);
    }

    private void handleImageException(ServiceException exception, Request request, int width, int height, String format, String exceptionFormat, Color bgcolor, Boolean transparent) {
        if (("BLANK".equals(exceptionFormat) || "application/vnd.ogc.se_blank".equals(exceptionFormat)) && bgcolor == null && Boolean.TRUE.equals(transparent)) {
            bgcolor = new Color(0, 0, 0, 0);
        }
        if (bgcolor == null) {
            bgcolor = Color.WHITE;
        }
        BufferedImage img = new BufferedImage(width, height, 6);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(bgcolor);
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        if (!"BLANK".equals(exceptionFormat) && !"application/vnd.ogc.se_blank".equals(exceptionFormat)) {
            g.setColor(Color.BLACK);
            this.paintLines(g, this.buildImageExceptionText(exception), width - 2, 35, 5);
        }
        g.dispose();
        try {
            HttpServletResponse response = request.getHttpResponse();
            if ("image/png8".equals(format)) {
                response.setContentType("image/png");
            } else {
                response.setContentType(format);
            }
            ServletOutputStream os = response.getOutputStream();
            ImageIO.write((RenderedImage)img, IMAGEIO_FORMATS.get(format), (OutputStream)os);
            os.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", e);
        }
    }

    public static boolean isPartialMapExceptionType(String exceptions) {
        return "application/vnd.gs.wms_partial".equals(exceptions) || "PARTIALMAP".equals(exceptions);
    }

    private void handlePartialMapException(ServiceException exception, Request request, String format) {
        RenderedImageMap map = (RenderedImageMap)((WMSPartialMapException)exception).getMap();
        try {
            HttpServletResponse response = request.getHttpResponse();
            if ("image/png8".equals(format)) {
                response.setContentType("image/png");
            } else {
                response.setContentType(format);
            }
            ServletOutputStream os = response.getOutputStream();
            ImageIO.write(map.getImage(), IMAGEIO_FORMATS.get(format), (OutputStream)os);
            os.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", e);
        }
    }

    public void handleXmlException(ServiceException exception, Request request) {
        String contentType;
        String dtdLocation = null;
        String schemaLocation = null;
        Version version = WMS.negotiateVersion(request.getVersion());
        if (version == WMS.VERSION_1_1_1) {
            dtdLocation = "wms/1.1.1/WMS_exception_1_1_1.dtd";
            contentType = "application/vnd.ogc.se_xml";
        } else {
            schemaLocation = "wms/1.3.0/exceptions_1_3_0.xsd";
            contentType = "text/xml";
        }
        String tab = "   ";
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"");
        sb.append(" encoding=\"UTF-8\"");
        if (dtdLocation != null) {
            sb.append(" standalone=\"no\"");
        }
        sb.append("?>");
        if (dtdLocation != null) {
            String fullDtdLocation = ResponseUtils.buildSchemaURL((String)ResponseUtils.baseURL((HttpServletRequest)request.getHttpRequest()), (String)dtdLocation);
            sb.append("<!DOCTYPE ServiceExceptionReport SYSTEM \"" + fullDtdLocation + "\"> ");
        }
        sb.append("<ServiceExceptionReport version=\"" + version.toString() + "\" ");
        if (schemaLocation != null && dtdLocation == null) {
            String fullSchemaLocation = ResponseUtils.buildSchemaURL((String)ResponseUtils.baseURL((HttpServletRequest)request.getHttpRequest()), (String)schemaLocation);
            sb.append("xmlns=\"http://www.opengis.net/ogc\" ");
            sb.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
            sb.append("xsi:schemaLocation=\"http://www.opengis.net/ogc " + fullSchemaLocation + "\"");
        }
        sb.append(">");
        sb.append(tab + "<ServiceException");
        if (exception.getCode() != null && !exception.getCode().equals("")) {
            sb.append(" code=\"" + exception.getCode() + "\"");
        }
        if (exception.getLocator() != null && !exception.getLocator().equals("")) {
            sb.append(" locator=\"" + ResponseUtils.encodeXML((String)exception.getLocator()) + "\"");
        }
        sb.append(">");
        if (exception.getMessage() != null) {
            sb.append("\n" + tab + tab);
            OwsUtils.dumpExceptionMessages((ServiceException)exception, (StringBuffer)sb, (boolean)true);
            if (this.geoServer.getSettings().isVerboseExceptions()) {
                ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                exception.printStackTrace(new PrintStream(stackTrace));
                sb.append("\nDetails:\n");
                sb.append(ResponseUtils.encodeXML((String)new String(stackTrace.toByteArray())));
            }
        }
        sb.append("\n</ServiceException>");
        sb.append("</ServiceExceptionReport>");
        HttpServletResponse response = request.getHttpResponse();
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        try {
            response.getOutputStream().write(sb.toString().getBytes());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", e);
        }
    }

    private String buildImageExceptionText(ServiceException exception) {
        StringBuffer sb = new StringBuffer();
        if (exception.getCode() != null && !exception.getCode().equals("")) {
            sb.append("code=\"" + exception.getCode() + "\"");
        }
        if (exception.getLocator() != null && !exception.getLocator().equals("")) {
            sb.append(" locator=\"" + exception.getLocator() + "\"");
        }
        if (exception.getMessage() != null) {
            OwsUtils.dumpExceptionMessages((ServiceException)exception, (StringBuffer)sb, (boolean)false);
            if (this.geoServer.getSettings().isVerboseExceptions()) {
                ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                exception.printStackTrace(new PrintStream(stackTrace));
                sb.append("\nDetails:\n");
                sb.append(new String(stackTrace.toByteArray()));
            }
        }
        return sb.toString();
    }

    void paintLines(Graphics2D g, String text, int lineWidth, int startX, int startY) {
        String[] lines = text.split("\\n");
        Point cursor = new Point(startX, startY);
        FontMetrics metrics = g.getFontMetrics();
        int lineHeight = metrics.getAscent() + metrics.getDescent() + metrics.getLeading();
        FontRenderContext frc = g.getFontRenderContext();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if ("".equals(line)) {
                cursor.y += lineHeight;
                continue;
            }
            AttributedString styledText = new AttributedString(line);
            LineBreakMeasurer measurer = new LineBreakMeasurer(styledText.getIterator(), frc);
            while (measurer.getPosition() < line.length()) {
                TextLayout layout = measurer.nextLayout(lineWidth - startX);
                cursor.y = (int)((float)cursor.y + layout.getAscent());
                float dx = layout.isLeftToRight() ? 0.0f : (float)lineWidth - layout.getAdvance();
                layout.draw(g, (float)cursor.x + dx, cursor.y);
                cursor.y = (int)((float)cursor.y + (layout.getDescent() + layout.getLeading()));
            }
        }
    }
}

