/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.WatermarkInfoImpl;

public class WMSInfoImpl
extends ServiceInfoImpl
implements WMSInfo {
    List<String> srs = new ArrayList<String>();
    Boolean bboxForEachCRS;
    WatermarkInfo watermark = new WatermarkInfoImpl();
    WMSInfo.WMSInterpolation interpolation = WMSInfo.WMSInterpolation.Nearest;
    boolean getFeatureInfoMimeTypeCheckingEnabled;
    Set<String> getFeatureInfoMimeTypes = new HashSet<String>();
    boolean getMapMimeTypeCheckingEnabled;
    Set<String> getMapMimeTypes = new HashSet<String>();
    protected List<AuthorityURLInfo> authorityURLs = new ArrayList<AuthorityURLInfo>(2);
    protected List<LayerIdentifierInfo> identifiers = new ArrayList<LayerIdentifierInfo>(2);
    int maxBuffer;
    int maxRequestMemory;
    int maxRenderingTime;
    int maxRenderingErrors;
    private String capabilitiesErrorHandling;

    public WMSInfoImpl() {
        this.authorityURLs = new ArrayList<AuthorityURLInfo>(2);
        this.identifiers = new ArrayList<LayerIdentifierInfo>(2);
    }

    @Override
    public int getMaxRequestMemory() {
        return this.maxRequestMemory;
    }

    @Override
    public void setMaxRequestMemory(int maxRequestMemory) {
        this.maxRequestMemory = maxRequestMemory;
    }

    @Override
    public WatermarkInfo getWatermark() {
        return this.watermark;
    }

    @Override
    public void setWatermark(WatermarkInfo watermark) {
        this.watermark = watermark;
    }

    @Override
    public void setInterpolation(WMSInfo.WMSInterpolation interpolation) {
        this.interpolation = interpolation;
    }

    @Override
    public WMSInfo.WMSInterpolation getInterpolation() {
        return this.interpolation;
    }

    @Override
    public List<String> getSRS() {
        return this.srs;
    }

    public void setSRS(List<String> srs) {
        this.srs = srs;
    }

    @Override
    public Boolean isBBOXForEachCRS() {
        if (this.bboxForEachCRS != null) {
            return this.bboxForEachCRS;
        }
        Boolean bool = (Boolean)this.getMetadata().get("bboxForEachCRS", Boolean.class);
        return bool != null && bool != false;
    }

    @Override
    public void setBBOXForEachCRS(Boolean bboxForEachCRS) {
        this.bboxForEachCRS = bboxForEachCRS;
    }

    @Override
    public int getMaxBuffer() {
        return this.maxBuffer;
    }

    @Override
    public void setMaxBuffer(int maxBuffer) {
        this.maxBuffer = maxBuffer;
    }

    @Override
    public int getMaxRenderingTime() {
        return this.maxRenderingTime;
    }

    @Override
    public void setMaxRenderingTime(int maxRenderingTime) {
        this.maxRenderingTime = maxRenderingTime;
    }

    @Override
    public int getMaxRenderingErrors() {
        return this.maxRenderingErrors;
    }

    @Override
    public void setMaxRenderingErrors(int maxRenderingErrors) {
        this.maxRenderingErrors = maxRenderingErrors;
    }

    @Override
    public List<AuthorityURLInfo> getAuthorityURLs() {
        return this.authorityURLs;
    }

    public void setAuthorityURLs(List<AuthorityURLInfo> urls) {
        this.authorityURLs = urls;
    }

    @Override
    public List<LayerIdentifierInfo> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<LayerIdentifierInfo> identifiers) {
        this.identifiers = identifiers;
    }

    @Override
    public Set<String> getGetFeatureInfoMimeTypes() {
        return this.getFeatureInfoMimeTypes;
    }

    public void setGetFeatureInfoMimeTypes(Set<String> getFeatureInfoMimeTypes) {
        this.getFeatureInfoMimeTypes = getFeatureInfoMimeTypes;
    }

    @Override
    public Set<String> getGetMapMimeTypes() {
        return this.getMapMimeTypes;
    }

    public void setGetMapMimeTypes(Set<String> getMapMimeTypes) {
        this.getMapMimeTypes = getMapMimeTypes;
    }

    @Override
    public boolean isGetFeatureInfoMimeTypeCheckingEnabled() {
        return this.getFeatureInfoMimeTypeCheckingEnabled;
    }

    @Override
    public void setGetFeatureInfoMimeTypeCheckingEnabled(boolean getFeatureInfoMimeTypeCheckingEnabled) {
        this.getFeatureInfoMimeTypeCheckingEnabled = getFeatureInfoMimeTypeCheckingEnabled;
    }

    @Override
    public boolean isGetMapMimeTypeCheckingEnabled() {
        return this.getMapMimeTypeCheckingEnabled;
    }

    @Override
    public void setGetMapMimeTypeCheckingEnabled(boolean getMapMimeTypeCheckingEnabled) {
        this.getMapMimeTypeCheckingEnabled = getMapMimeTypeCheckingEnabled;
    }
}

