/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.JAIInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetLegendGraphicOutputFormat;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSExtensions;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.dimension.DimensionDefaultValueSelectionStrategy;
import org.geoserver.wms.dimension.DimensionDefaultValueSelectionStrategyFactory;
import org.geoserver.wms.dimension.DimensionFilterBuilder;
import org.geoserver.wms.featureinfo.GetFeatureInfoOutputFormat;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.OperationType;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.styling.Style;
import org.geotools.util.Converters;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class WMS
implements ApplicationContextAware {
    public static final Version VERSION_1_1_1 = new Version("1.1.1");
    public static final Version VERSION_1_3_0 = new Version("1.3.0");
    public static final String JPEG_COMPRESSION = "jpegCompression";
    public static final int JPEG_COMPRESSION_DEFAULT = 25;
    public static final String PNG_COMPRESSION = "pngCompression";
    public static final int PNG_COMPRESSION_DEFAULT = 25;
    public static final String MAX_ALLOWED_FRAMES = "maxAllowedFrames";
    public static final int MAX_ALLOWED_FRAMES_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_RENDERING_TIME = "maxAnimatorRenderingTime";
    public static final String MAX_RENDERING_SIZE = "maxRenderingSize";
    public static final String FRAMES_DELAY = "framesDelay";
    public static final int FRAMES_DELAY_DEFAULT = 1000;
    public static final String LOOP_CONTINUOUSLY = "loopContinuously";
    public static final Boolean LOOP_CONTINUOUSLY_DEFAULT = Boolean.FALSE;
    public static final String SCALEHINT_MAPUNITS_PIXEL = "scalehintMapunitsPixel";
    public static final Boolean SCALEHINT_MAPUNITS_PIXEL_DEFAULT = Boolean.FALSE;
    static final Logger LOGGER = Logging.getLogger(WMS.class);
    public static final String WEB_CONTAINER_KEY = "WMS";
    public static final String SVG_SIMPLE = "Simple";
    public static final String SVG_BATIK = "Batik";
    public static String KML_REFLECTOR_MODE = "kmlReflectorMode";
    public static final String KML_REFLECTOR_MODE_REFRESH = "refresh";
    public static final String KML_REFLECTOR_MODE_SUPEROVERLAY = "superoverlay";
    public static final String KML_REFLECTOR_MODE_DOWNLOAD = "download";
    public static final String KML_REFLECTOR_MODE_DEFAULT = "refresh";
    public static final String KML_SUPEROVERLAY_MODE = "kmlSuperoverlayMode";
    public static final String KML_SUPEROVERLAY_MODE_AUTO = "auto";
    public static final String KML_SUPEROVERLAY_MODE_RASTER = "raster";
    public static final String KML_SUPEROVERLAY_MODE_OVERVIEW = "overview";
    public static final String KML_SUPEROVERLAY_MODE_HYBRID = "hybrid";
    public static final String KML_SUPEROVERLAY_MODE_CACHED = "cached";
    public static final String KML_SUPEROVERLAY_MODE_DEFAULT = "auto";
    public static final String KML_KMLATTR = "kmlAttr";
    public static final boolean KML_KMLATTR_DEFAULT = true;
    public static final String KML_KMLPLACEMARK = "kmlPlacemark";
    public static final boolean KML_KMLPLACEMARK_DEFAULT = false;
    public static final String KML_KMSCORE = "kmlKmscore";
    public static final int KML_KMSCORE_DEFAULT = 40;
    public static Boolean ENABLE_MAP_WRAPPING = null;
    public static String MAP_WRAPPING_KEY = "mapWrapping";
    public static Boolean ENABLE_ADVANCED_PROJECTION = null;
    public static String ADVANCED_PROJECTION_KEY = "advancedProjectionHandling";
    private ExecutorService animatorExecutorService;
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    private final GeoServer geoserver;
    private ApplicationContext applicationContext;
    private DimensionDefaultValueSelectionStrategyFactory defaultDimensionValueFactory;

    public WMS(GeoServer geoserver) {
        this.geoserver = geoserver;
    }

    public Catalog getCatalog() {
        return this.geoserver.getCatalog();
    }

    public WMSInfo getServiceInfo() {
        return (WMSInfo)this.geoserver.getService(WMSInfo.class);
    }

    public Style getStyleByName(String styleName) throws IOException {
        StyleInfo styleInfo = this.getCatalog().getStyleByName(styleName);
        return styleInfo == null ? null : styleInfo.getStyle();
    }

    public LayerInfo getLayerByName(String layerName) {
        return this.getCatalog().getLayerByName(layerName);
    }

    public LayerGroupInfo getLayerGroupByName(String layerGroupName) {
        return this.getCatalog().getLayerGroupByName(layerGroupName);
    }

    public boolean isEnabled() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return serviceInfo.isEnabled();
    }

    public static Version negotiateVersion(String requestedVersion) {
        return WMS.negotiateVersion(requestedVersion != null ? new Version(requestedVersion) : null);
    }

    public static Version negotiateVersion(Version requestedVersion) {
        if (null == requestedVersion) {
            return VERSION_1_3_0;
        }
        if (VERSION_1_1_1.equals((Object)requestedVersion)) {
            return VERSION_1_1_1;
        }
        if (VERSION_1_3_0.equals((Object)requestedVersion)) {
            return VERSION_1_3_0;
        }
        if (requestedVersion.compareTo(VERSION_1_3_0) < 0) {
            return VERSION_1_1_1;
        }
        return VERSION_1_3_0;
    }

    public String getVersion() {
        WMSInfo serviceInfo = this.getServiceInfo();
        List versions = serviceInfo.getVersions();
        String version = versions.size() > 0 ? ((Version)versions.get(0)).toString() : "1.1.1";
        return version;
    }

    public GeoServer getGeoServer() {
        return this.geoserver;
    }

    public void setAnimatorExecutorService(ExecutorService animatorExecutorService) {
        this.animatorExecutorService = animatorExecutorService;
    }

    public ExecutorService getAnimatorExecutorService() {
        return this.animatorExecutorService;
    }

    public WMSInfo.WMSInterpolation getInterpolation() {
        return this.getServiceInfo().getInterpolation();
    }

    public JAIInfo.PngEncoderType getPNGEncoderType() {
        JAIInfo jaiInfo = this.getJaiInfo();
        return jaiInfo.getPngEncoderType();
    }

    public Boolean getJPEGNativeAcceleration() {
        JAIInfo jaiInfo = this.getJaiInfo();
        return jaiInfo.isJpegAcceleration();
    }

    private JAIInfo getJaiInfo() {
        GeoServer geoServer = this.getGeoServer();
        GeoServerInfo global = geoServer.getGlobal();
        return global.getJAI();
    }

    public Charset getCharSet() {
        GeoServer geoServer2 = this.getGeoServer();
        String charset = geoServer2.getSettings().getCharset();
        return Charset.forName(charset);
    }

    public String getProxyBaseUrl() {
        GeoServer geoServer = this.getGeoServer();
        return geoServer.getSettings().getProxyBaseUrl();
    }

    public long getUpdateSequence() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        return global.getUpdateSequence();
    }

    public int getWatermarkTransparency() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getTransparency();
    }

    public int getWatermarkPosition() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        WatermarkInfo.Position position = watermark.getPosition();
        return position.getCode();
    }

    public boolean isGlobalWatermarking() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.isEnabled();
    }

    public String getGlobalWatermarkingURL() {
        WatermarkInfo watermark = this.getServiceInfo().getWatermark();
        return watermark.getURL();
    }

    public FeatureTypeInfo getFeatureTypeInfo(Name name) {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo resource = (FeatureTypeInfo)catalog.getResourceByName(name, FeatureTypeInfo.class);
        return resource;
    }

    public CoverageInfo getCoverageInfo(Name name) {
        Catalog catalog = this.getCatalog();
        CoverageInfo resource = (CoverageInfo)catalog.getResourceByName(name, CoverageInfo.class);
        return resource;
    }

    public WMSLayerInfo getWMSLayerInfo(Name name) {
        Catalog catalog = this.getCatalog();
        WMSLayerInfo resource = (WMSLayerInfo)catalog.getResourceByName(name, WMSLayerInfo.class);
        return resource;
    }

    public ResourceInfo getResourceInfo(Name name) {
        Catalog catalog = this.getCatalog();
        ResourceInfo resource = catalog.getResourceByName(name, ResourceInfo.class);
        return resource;
    }

    public List<LayerInfo> getLayers() {
        Catalog catalog = this.getCatalog();
        return catalog.getLayers();
    }

    public String getNamespaceByPrefix(String prefix) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo namespaceInfo = catalog.getNamespaceByPrefix(prefix);
        return namespaceInfo == null ? null : namespaceInfo.getURI();
    }

    public List<LayerGroupInfo> getLayerGroups() {
        Catalog catalog = this.getCatalog();
        List layerGroups = catalog.getLayerGroups();
        return layerGroups;
    }

    public boolean supportsSLD() {
        return true;
    }

    public boolean supportsUserLayer() {
        return true;
    }

    public boolean supportsUserStyle() {
        return true;
    }

    public boolean supportsRemoteWFS() {
        return true;
    }

    public void setSvgRenderer(String svgRendererHint) {
        WMSInfo serviceInfo = this.getServiceInfo();
        serviceInfo.getMetadata().put("svgRenderer", (Serializable)((Object)svgRendererHint));
        this.getGeoServer().save((ServiceInfo)serviceInfo);
    }

    public String getSvgRenderer() {
        WMSInfo serviceInfo = this.getServiceInfo();
        String svgRendererHint = (String)((Object)serviceInfo.getMetadata().get((Object)"svgRenderer"));
        return svgRendererHint;
    }

    public boolean isSvgAntiAlias() {
        WMSInfo serviceInfo = this.getServiceInfo();
        Boolean svgAntiAlias = (Boolean)Converters.convert((Object)serviceInfo.getMetadata().get((Object)"svgAntiAlias"), Boolean.class);
        return svgAntiAlias == null ? true : svgAntiAlias;
    }

    public int getPngCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), PNG_COMPRESSION, 25);
    }

    public int getJpegCompression() {
        WMSInfo serviceInfo = this.getServiceInfo();
        return this.getMetadataPercentage(serviceInfo.getMetadata(), JPEG_COMPRESSION, 25);
    }

    public boolean isContinuousMapWrappingEnabled() {
        Boolean enabled = this.getMetadataValue(MAP_WRAPPING_KEY, ENABLE_MAP_WRAPPING, Boolean.class);
        return enabled;
    }

    public boolean isAdvancedProjectionHandlingEnabled() {
        Boolean enabled = this.getMetadataValue(ADVANCED_PROJECTION_KEY, ENABLE_ADVANCED_PROJECTION, Boolean.class);
        return enabled;
    }

    public int getMaxAllowedFrames() {
        return this.getMetadataValue(MAX_ALLOWED_FRAMES, Integer.MAX_VALUE, Integer.class);
    }

    public Long getMaxAnimatorRenderingTime() {
        return this.getMetadataValue(MAX_RENDERING_TIME, null, Long.class);
    }

    public Long getMaxRenderingSize() {
        return this.getMetadataValue(MAX_RENDERING_SIZE, null, Long.class);
    }

    public Integer getFramesDelay() {
        return this.getMetadataValue(FRAMES_DELAY, 1000, Integer.class);
    }

    public Boolean getLoopContinuously() {
        return this.getMetadataValue(LOOP_CONTINUOUSLY, LOOP_CONTINUOUSLY_DEFAULT, Boolean.class);
    }

    public Boolean getScalehintUnitPixel() {
        return this.getMetadataValue(SCALEHINT_MAPUNITS_PIXEL, SCALEHINT_MAPUNITS_PIXEL_DEFAULT, Boolean.class);
    }

    int getMetadataPercentage(MetadataMap metadata, String key, int defaultValue) {
        Integer parsedValue = (Integer)Converters.convert((Object)metadata.get((Object)key), Integer.class);
        if (parsedValue == null) {
            return defaultValue;
        }
        int value = parsedValue;
        if (value < 0 || value > 100) {
            LOGGER.warning("Invalid percertage value for '" + key + "', it should be between 0 and 100");
            return defaultValue;
        }
        return value;
    }

    <T> T getMetadataValue(String key, T defaultValue, Class<T> clazz) {
        if (this.getServiceInfo() == null) {
            return defaultValue;
        }
        MetadataMap metadata = this.getServiceInfo().getMetadata();
        Object parsedValue = Converters.convert((Object)metadata.get((Object)key), clazz);
        if (parsedValue == null) {
            return defaultValue;
        }
        return (T)parsedValue;
    }

    public int getNumDecimals() {
        return this.getGeoServer().getSettings().getNumDecimals();
    }

    public String getNameSpacePrefix(String nsUri) {
        Catalog catalog = this.getCatalog();
        NamespaceInfo ns = catalog.getNamespaceByURI(nsUri);
        return ns == null ? null : ns.getPrefix();
    }

    public int getMaxBuffer() {
        return this.getServiceInfo().getMaxBuffer();
    }

    public int getMaxRequestMemory() {
        return this.getServiceInfo().getMaxRequestMemory();
    }

    public int getMaxRenderingTime() {
        return this.getServiceInfo().getMaxRenderingTime();
    }

    public int getMaxRenderingErrors() {
        return this.getServiceInfo().getMaxRenderingErrors();
    }

    public String getKmlReflectorMode() {
        String value = (String)((Object)this.getServiceInfo().getMetadata().get((Object)KML_REFLECTOR_MODE));
        return value != null ? value : "refresh";
    }

    public String getKmlSuperoverlayMode() {
        String value = (String)((Object)this.getServiceInfo().getMetadata().get((Object)KML_SUPEROVERLAY_MODE));
        return value != null ? value : "auto";
    }

    public boolean getKmlKmAttr() {
        Boolean kmAttr = (Boolean)Converters.convert((Object)this.getServiceInfo().getMetadata().get((Object)KML_KMLATTR), Boolean.class);
        return kmAttr == null ? true : kmAttr;
    }

    public boolean getKmlPlacemark() {
        Boolean kmAttr = (Boolean)Converters.convert((Object)this.getServiceInfo().getMetadata().get((Object)KML_KMLPLACEMARK), Boolean.class);
        return kmAttr == null ? false : kmAttr;
    }

    public int getKmScore() {
        return this.getMetadataPercentage(this.getServiceInfo().getMetadata(), KML_KMSCORE, 40);
    }

    public Collection<GetMapOutputFormat> getAllowedMapFormats() {
        ArrayList<GetMapOutputFormat> result = new ArrayList<GetMapOutputFormat>();
        for (GetMapOutputFormat producer : WMSExtensions.findMapProducers(this.applicationContext)) {
            if (!this.isAllowedGetMapFormat(producer)) continue;
            result.add(producer);
        }
        return result;
    }

    public Collection<GetMapOutputFormat> getAvailableMapFormats() {
        return WMSExtensions.findMapProducers(this.applicationContext);
    }

    public Set<String> getAvailableMapFormatNames() {
        List<GetMapOutputFormat> producers = WMSExtensions.findMapProducers(this.applicationContext);
        HashSet<String> formats = new HashSet<String>();
        for (GetMapOutputFormat producer : producers) {
            formats.addAll(producer.getOutputFormatNames());
        }
        return formats;
    }

    public Set<String> getAllowedMapFormatNames() {
        List<GetMapOutputFormat> producers = WMSExtensions.findMapProducers(this.applicationContext);
        HashSet<String> formats = new HashSet<String>();
        for (GetMapOutputFormat producer : producers) {
            if (!this.isAllowedGetMapFormat(producer)) continue;
            formats.addAll(producer.getOutputFormatNames());
        }
        return formats;
    }

    public boolean isAllowedGetMapFormat(GetMapOutputFormat format) {
        if (!this.getServiceInfo().isGetMapMimeTypeCheckingEnabled()) {
            return true;
        }
        Set<String> mimeTypes = this.getServiceInfo().getGetMapMimeTypes();
        return mimeTypes.contains(format.getMimeType());
    }

    public boolean isAllowedGetFeatureInfoFormat(GetFeatureInfoOutputFormat format) {
        if (!this.getServiceInfo().isGetFeatureInfoMimeTypeCheckingEnabled()) {
            return true;
        }
        Set<String> mimeTypes = this.getServiceInfo().getGetFeatureInfoMimeTypes();
        return mimeTypes.contains(format.getContentType());
    }

    public ServiceException unallowedGetFeatureInfoFormatException(String requestFormat) {
        ServiceException e = new ServiceException("Getting feature info using " + requestFormat + " is not allowed", "ForbiddenFormat");
        e.setCode("ForbiddenFormat");
        return e;
    }

    public ServiceException unallowedGetMapFormatException(String requestFormat) {
        ServiceException e = new ServiceException("Creating maps using " + requestFormat + " is not allowed", "ForbiddenFormat");
        e.setCode("ForbiddenFormat");
        return e;
    }

    public Set<String> getAvailableLegendGraphicsFormats() {
        List<GetLegendGraphicOutputFormat> formats = WMSExtensions.findLegendGraphicFormats(this.applicationContext);
        HashSet<String> mimeTypes = new HashSet<String>();
        for (GetLegendGraphicOutputFormat format : formats) {
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public List<ExtendedCapabilitiesProvider> getAvailableExtendedCapabilitiesProviders() {
        return WMSExtensions.findExtendedCapabilitiesProviders(this.applicationContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.defaultDimensionValueFactory = (DimensionDefaultValueSelectionStrategyFactory)GeoServerExtensions.extensions(DimensionDefaultValueSelectionStrategyFactory.class).get(0);
        if (ENABLE_MAP_WRAPPING == null) {
            String wrapping = GeoServerExtensions.getProperty((String)"ENABLE_MAP_WRAPPING", (ApplicationContext)applicationContext);
            ENABLE_MAP_WRAPPING = wrapping == null ? Boolean.valueOf(true) : Boolean.valueOf(wrapping);
        }
        if (ENABLE_ADVANCED_PROJECTION == null) {
            String projection = GeoServerExtensions.getProperty((String)"ENABLE_ADVANCED_PROJECTION", (ApplicationContext)applicationContext);
            ENABLE_ADVANCED_PROJECTION = projection == null ? Boolean.valueOf(true) : Boolean.valueOf(projection);
        }
    }

    public GetFeatureInfoOutputFormat getFeatureInfoOutputFormat(String requestFormat) {
        List<GetFeatureInfoOutputFormat> outputFormats = WMSExtensions.findFeatureInfoFormats(this.applicationContext);
        for (GetFeatureInfoOutputFormat format : outputFormats) {
            if (!format.canProduce(requestFormat)) continue;
            return format;
        }
        return null;
    }

    public List<String> getAvailableFeatureInfoFormats() {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        for (GetFeatureInfoOutputFormat format : WMSExtensions.findFeatureInfoFormats(this.applicationContext)) {
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public List<String> getAllowedFeatureInfoFormats() {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        for (GetFeatureInfoOutputFormat format : WMSExtensions.findFeatureInfoFormats(this.applicationContext)) {
            if (!this.isAllowedGetFeatureInfoFormat(format)) continue;
            mimeTypes.add(format.getContentType());
        }
        return mimeTypes;
    }

    public GetMapOutputFormat getMapOutputFormat(String mimeType) {
        GetMapOutputFormat outputFormat = WMSExtensions.findMapProducer(mimeType, this.applicationContext);
        return outputFormat;
    }

    public GetLegendGraphicOutputFormat getLegendGraphicOutputFormat(String outputFormat) {
        GetLegendGraphicOutputFormat format = WMSExtensions.findLegendGraphicFormat(outputFormat, this.applicationContext);
        return format;
    }

    public static Version version(String version) {
        return WMS.version(version, false);
    }

    public static Version version(String version, boolean exact) {
        if (version == null || 0 == version.trim().length()) {
            return null;
        }
        if (VERSION_1_1_1.toString().equals(version)) {
            return VERSION_1_1_1;
        }
        if (VERSION_1_3_0.toString().equals(version)) {
            return VERSION_1_3_0;
        }
        return exact ? null : new Version(version);
    }

    public static String toInternalSRS(String srs, Version version) {
        if (VERSION_1_3_0.equals((Object)version) && srs != null && srs.toUpperCase().startsWith("EPSG:")) {
            srs = srs.toUpperCase().replace("EPSG:", "urn:x-ogc:def:crs:EPSG:");
        }
        return srs;
    }

    public boolean isQueryable(LayerInfo layer) {
        try {
            if (layer.getResource() instanceof WMSLayerInfo) {
                WMSLayerInfo info = (WMSLayerInfo)layer.getResource();
                Layer wl = info.getWMSLayer(null);
                if (!wl.isQueryable()) {
                    return false;
                }
                WMSCapabilities caps = info.getStore().getWebMapServer(null).getCapabilities();
                OperationType featureInfo = caps.getRequest().getGetFeatureInfo();
                if (featureInfo == null || !featureInfo.getFormats().contains("application/vnd.ogc.gml")) {
                    return false;
                }
            }
            return layer.isQueryable();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to determin if the layer is queryable, assuming it's not", e);
            return false;
        }
    }

    public boolean isOpaque(LayerInfo layer) {
        return layer.isOpaque();
    }

    public Integer getCascadedHopCount(LayerInfo layer) {
        if (!(layer.getResource() instanceof WMSLayerInfo)) {
            return null;
        }
        WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)layer.getResource();
        int cascaded = 1;
        try {
            Layer wmsLayer = wmsLayerInfo.getWMSLayer(null);
            cascaded = 1 + wmsLayer.getCascaded();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Unable to determina WMSLayer cascaded hop count", e);
        }
        return cascaded;
    }

    public boolean isQueryable(LayerGroupInfo layerGroup) {
        for (PublishedInfo published : layerGroup.getLayers()) {
            if (!(published instanceof LayerInfo ? !this.isQueryable((LayerInfo)published) : !this.isQueryable((LayerGroupInfo)published))) continue;
            return false;
        }
        return true;
    }

    public GeneralParameterValue[] getWMSReadParameters(GetMapRequest request, MapLayerInfo mapLayerInfo, Filter layerFilter, List<Object> times, List<Object> elevations, GridCoverage2DReader reader, boolean readGeom) throws IOException {
        DimensionInfo elevationInfo;
        int i;
        ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
        CoverageInfo coverage = mapLayerInfo.getCoverage();
        MetadataMap metadata = coverage.getMetadata();
        GeneralParameterValue[] readParameters = CoverageUtils.getParameters((ParameterValueGroup)readParametersDescriptor, (Map)coverage.getParameters(), (boolean)readGeom);
        ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
        DimensionInfo timeInfo = (DimensionInfo)metadata.get("time", DimensionInfo.class);
        ArrayList parameterDescriptors = new ArrayList(readParametersDescriptor.getDescriptor().descriptors());
        Set dynamicParameters = reader.getDynamicParameters();
        parameterDescriptors.addAll(dynamicParameters);
        if (timeInfo != null && timeInfo.isEnabled()) {
            ArrayList<Object> fixedTimes = new ArrayList<Object>(times);
            for (i = 0; i < fixedTimes.size(); ++i) {
                if (fixedTimes.get(i) != null) continue;
                fixedTimes.set(i, this.getDefaultTime((ResourceInfo)coverage));
            }
            readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, fixedTimes, (String[])new String[]{"TIME", "Time"});
        }
        if ((elevationInfo = (DimensionInfo)metadata.get("elevation", DimensionInfo.class)) != null && elevationInfo.isEnabled()) {
            ArrayList<Object> fixedElevations = new ArrayList<Object>(elevations);
            for (int i2 = 0; i2 < fixedElevations.size(); ++i2) {
                if (fixedElevations.get(i2) != null) continue;
                fixedElevations.set(i2, this.getDefaultElevation((ResourceInfo)coverage));
            }
            readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, fixedElevations, (String[])new String[]{"ELEVATION", "Elevation"});
        }
        if (layerFilter != null && readParameters != null) {
            for (i = 0; i < readParameters.length; ++i) {
                GeneralParameterValue param = readParameters[i];
                GeneralParameterDescriptor pd = param.getDescriptor();
                if (!pd.getName().getCode().equalsIgnoreCase("FILTER")) continue;
                ParameterValue pv = (ParameterValue)pd.createValue();
                if (layerFilter == Filter.INCLUDE) break;
                pv.setValue((Object)layerFilter);
                readParameters[i] = pv;
                break;
            }
        }
        ArrayList customDomains = new ArrayList(dimensions.getCustomDomains());
        for (String domain : new ArrayList(customDomains)) {
            List<String> values = request.getCustomDimension(domain);
            if (values == null) continue;
            readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, values, (String[])new String[]{domain});
            customDomains.remove(domain);
        }
        if (!customDomains.isEmpty()) {
            for (String name : customDomains) {
                DimensionInfo customInfo = (DimensionInfo)metadata.get("custom_dimension_" + name, DimensionInfo.class);
                if (customInfo == null || !customInfo.isEnabled()) continue;
                ArrayList<String> val = new ArrayList<String>(1);
                val.add(this.getDefaultCustomDimensionValue(name, (ResourceInfo)coverage, String.class));
                readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, val, (String[])new String[]{name});
            }
        }
        return readParameters;
    }

    public Collection<RenderedImageMapResponse> getAvailableMapResponses() {
        return WMSExtensions.findMapResponses(this.applicationContext);
    }

    public TreeSet<Date> getFeatureTypeTimes(FeatureTypeInfo typeInfo) throws IOException {
        DimensionInfo time = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        if (time == null || !time.isEnabled()) {
            throw new ServiceException("Layer " + typeInfo.getPrefixedName() + " does not have time support enabled");
        }
        FeatureCollection collection = this.getDimensionCollection(typeInfo, time);
        TreeSet<Date> result = new TreeSet<Date>();
        if (time.getPresentation() == DimensionPresentation.LIST) {
            UniqueVisitor visitor = new UniqueVisitor(time.getAttribute());
            collection.accepts((FeatureVisitor)visitor, null);
            Set values = visitor.getUnique();
            if (values.size() <= 0) {
                result = null;
            } else {
                values.remove(null);
                result.addAll(values);
            }
        } else {
            MinVisitor min = new MinVisitor(time.getAttribute());
            collection.accepts((FeatureVisitor)min, null);
            CalcResult minResult = min.getResult();
            if (minResult != CalcResult.NULL_RESULT) {
                result.add((Date)min.getMin());
                MaxVisitor max = new MaxVisitor(time.getAttribute());
                collection.accepts((FeatureVisitor)max, null);
                result.add((Date)max.getMax());
            }
        }
        return result;
    }

    public TreeSet<Double> getFeatureTypeElevations(FeatureTypeInfo typeInfo) throws IOException {
        DimensionInfo elevation = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        if (elevation == null || !elevation.isEnabled()) {
            throw new ServiceException("Layer " + typeInfo.getPrefixedName() + " does not have elevation support enabled");
        }
        FeatureCollection collection = this.getDimensionCollection(typeInfo, elevation);
        TreeSet<Double> result = new TreeSet<Double>();
        if (elevation.getPresentation() == DimensionPresentation.LIST || elevation.getPresentation() == DimensionPresentation.DISCRETE_INTERVAL && elevation.getResolution() == null) {
            UniqueVisitor visitor = new UniqueVisitor(elevation.getAttribute());
            collection.accepts((FeatureVisitor)visitor, null);
            Set values = visitor.getUnique();
            if (values.size() <= 0) {
                result = null;
            } else {
                for (Object value : values) {
                    result.add(((Number)value).doubleValue());
                }
            }
        } else {
            MinVisitor min = new MinVisitor(elevation.getAttribute());
            collection.accepts((FeatureVisitor)min, null);
            CalcResult calcResult = min.getResult();
            if (calcResult != CalcResult.NULL_RESULT) {
                result.add(((Number)((Object)min.getMin())).doubleValue());
                MaxVisitor max = new MaxVisitor(elevation.getAttribute());
                collection.accepts((FeatureVisitor)max, null);
                result.add(((Number)((Object)max.getMax())).doubleValue());
            }
        }
        return result;
    }

    public Date getCurrentTime(ResourceInfo resourceInfo) {
        return this.getDefaultTime(resourceInfo);
    }

    public Date getDefaultTime(ResourceInfo resourceInfo) {
        DimensionInfo time = (DimensionInfo)resourceInfo.getMetadata().get("time", DimensionInfo.class);
        if (time == null || !time.isEnabled()) {
            throw new ServiceException("Layer " + resourceInfo.prefixedName() + " does not have time support enabled");
        }
        DimensionDefaultValueSelectionStrategy strategy = this.getDefaultValueStrategy(resourceInfo, "time", time);
        return strategy.getDefaultValue(resourceInfo, "time", time, Date.class);
    }

    public Double getDefaultElevation(ResourceInfo resourceInfo) {
        DimensionInfo elevation = (DimensionInfo)resourceInfo.getMetadata().get("elevation", DimensionInfo.class);
        if (elevation == null || !elevation.isEnabled()) {
            throw new ServiceException("Layer " + resourceInfo.prefixedName() + " does not have elevation support enabled");
        }
        DimensionDefaultValueSelectionStrategy strategy = this.getDefaultValueStrategy(resourceInfo, "elevation", elevation);
        return strategy.getDefaultValue(resourceInfo, "elevation", elevation, Double.class);
    }

    public <T> T getDefaultCustomDimensionValue(String dimensionName, ResourceInfo resourceInfo, Class<T> clz) {
        DimensionInfo customDim = (DimensionInfo)resourceInfo.getMetadata().get("custom_dimension_" + dimensionName, DimensionInfo.class);
        if (customDim == null || !customDim.isEnabled()) {
            throw new ServiceException("Layer " + resourceInfo.prefixedName() + " does not have support enabled for dimension " + dimensionName);
        }
        DimensionDefaultValueSelectionStrategy strategy = this.getDefaultValueStrategy(resourceInfo, "custom_dimension_" + dimensionName, customDim);
        return strategy.getDefaultValue(resourceInfo, "custom_dimension_" + dimensionName, customDim, clz);
    }

    DimensionDefaultValueSelectionStrategy getDefaultValueStrategy(ResourceInfo resource, String dimensionName, DimensionInfo dimensionInfo) {
        if (this.defaultDimensionValueFactory != null) {
            return this.defaultDimensionValueFactory.getStrategy(resource, dimensionName, dimensionInfo);
        }
        return null;
    }

    FeatureCollection getDimensionCollection(FeatureTypeInfo typeInfo, DimensionInfo dimension) throws IOException {
        FeatureSource source = null;
        try {
            source = typeInfo.getFeatureSource(null, GeoTools.getDefaultHints());
        }
        catch (IOException e) {
            throw new ServiceException("Could not get the feauture source to list time info for layer " + typeInfo.getPrefixedName(), (Throwable)e);
        }
        Query dimQuery = new Query(source.getSchema().getName().getLocalPart());
        dimQuery.setPropertyNames(Arrays.asList(dimension.getAttribute()));
        return source.getFeatures(dimQuery);
    }

    public Filter getTimeElevationToFilter(List<Object> times, List<Object> elevations, FeatureTypeInfo typeInfo) throws IOException {
        DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get("time", DimensionInfo.class);
        DimensionInfo elevationInfo = (DimensionInfo)typeInfo.getMetadata().get("elevation", DimensionInfo.class);
        DimensionFilterBuilder builder = new DimensionFilterBuilder(ff);
        if (timeInfo != null && timeInfo.isEnabled() && times != null) {
            ArrayList<Object> defaultedTimes = new ArrayList<Object>(times.size());
            for (Object datetime : times) {
                if (datetime == null) {
                    datetime = this.getDefaultTime((ResourceInfo)typeInfo);
                }
                defaultedTimes.add(datetime);
            }
            builder.appendFilters(timeInfo.getAttribute(), timeInfo.getEndAttribute(), defaultedTimes);
        }
        if (elevationInfo != null && elevationInfo.isEnabled() && elevations != null) {
            ArrayList<Object> defaultedElevations = new ArrayList<Object>(elevations.size());
            for (Object elevation : elevations) {
                if (elevation == null) {
                    elevation = this.getDefaultElevation((ResourceInfo)typeInfo);
                }
                defaultedElevations.add(elevation);
            }
            builder.appendFilters(elevationInfo.getAttribute(), elevationInfo.getEndAttribute(), defaultedElevations);
        }
        Filter result = builder.getFilter();
        return result;
    }

    public static Coordinate pixelToWorld(double x, double y, ReferencedEnvelope map, double width, double height) {
        AffineTransform at = WMS.worldToScreenTransform(map, width, height);
        Point2D result = null;
        try {
            result = at.inverseTransform(new Point2D.Double(x, y), new Point2D.Double());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        Coordinate c = new Coordinate(result.getX(), result.getY());
        return c;
    }

    public static AffineTransform worldToScreenTransform(ReferencedEnvelope mapExtent, double width, double height) {
        boolean swap;
        CoordinateReferenceSystem crs = mapExtent.getCoordinateReferenceSystem();
        boolean bl = swap = crs != null && CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST;
        if (swap) {
            mapExtent = new ReferencedEnvelope(mapExtent.getMinY(), mapExtent.getMaxY(), mapExtent.getMinX(), mapExtent.getMaxX(), null);
        }
        double scaleX = width / mapExtent.getWidth();
        double scaleY = height / mapExtent.getHeight();
        double tx = -mapExtent.getMinX() * scaleX;
        double ty = mapExtent.getMinY() * scaleY + height;
        AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, -scaleY, tx, ty);
        if (swap) {
            at.concatenate(new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        }
        return at;
    }

    public static WMS get() {
        return (WMS)GeoServerExtensions.bean(WMS.class);
    }
}

