/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.RenderedImageList;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.CachedGridReaderLayer;
import org.geoserver.wms.GetMapCallback;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RenderingVariables;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.map.MetatileMapOutputFormat;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WebMapServer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.filter.Filters;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.WMSLayer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GetMap {
    private static final Logger LOGGER = Logging.getLogger(GetMap.class);
    private FilterFactory ff;
    private final WMS wms;
    private List<GetMapCallback> callbacks;

    public GetMap(WMS wms) {
        this.wms = wms;
        this.ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        this.callbacks = GeoServerExtensions.extensions(GetMapCallback.class);
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.ff = filterFactory;
    }

    public void setGetMapCallbacks(List<GetMapCallback> callbacks) {
        this.callbacks.clear();
        this.callbacks.addAll(callbacks);
    }

    public WebMap run(GetMapRequest request) throws ServiceException {
        request = this.fireInitRequest(request);
        WMSMapContent mapContent = new WMSMapContent(request);
        mapContent.setGetMapCallbacks(this.callbacks);
        try {
            WebMap map = this.run(request, mapContent);
            map = this.fireFinished(map);
            return map;
        }
        catch (Throwable t) {
            this.fireFailed(t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new ServiceException("Internal error ", t);
        }
    }

    private GetMapRequest fireInitRequest(GetMapRequest request) {
        for (GetMapCallback callback : this.callbacks) {
            request = callback.initRequest(request);
        }
        return request;
    }

    private void fireMapContentInit(WMSMapContent mapContent) {
        for (GetMapCallback callback : this.callbacks) {
            callback.initMapContent(mapContent);
        }
    }

    private WMSMapContent fireBeforeRender(WMSMapContent mapContent) {
        for (GetMapCallback callback : this.callbacks) {
            mapContent = callback.beforeRender(mapContent);
        }
        return mapContent;
    }

    private WebMap fireFinished(WebMap result) {
        for (GetMapCallback callback : this.callbacks) {
            result = callback.finished(result);
        }
        return result;
    }

    private void fireFailed(Throwable t) {
        for (GetMapCallback callback : this.callbacks) {
            callback.failed(t);
        }
    }

    public WebMap run(GetMapRequest request, WMSMapContent mapContent) throws ServiceException, IOException {
        boolean isMultivaluedSupported;
        this.assertMandatory(request);
        String outputFormat = request.getFormat();
        GetMapOutputFormat delegate = this.getDelegate(outputFormat);
        boolean isTiled = MetatileMapOutputFormat.isRequestTiled(request, delegate);
        MapProducerCapabilities cap = delegate.getCapabilities(request.getFormat());
        if (cap != null && !cap.isTiledRequestsSupported() && isTiled) {
            throw new ServiceException("Format " + request.getFormat() + " does not support tiled requests");
        }
        if (MetatileMapOutputFormat.isRequestTiled(request, delegate)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Tiled request detected, activating on the fly meta tiler");
            }
            delegate = new MetatileMapOutputFormat(request, (RenderedImageMapOutputFormat)delegate);
        }
        List<Object> times = request.getTime();
        int numTimes = times.size();
        List<Object> elevations = request.getElevation();
        int numElevations = elevations.size();
        boolean bl = isMultivaluedSupported = cap != null ? cap.isMultivalueRequestsSupported() : false;
        if (numTimes > 1 && isMultivaluedSupported) {
            WebMap map = null;
            ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
            for (Object currentTime : times) {
                map = this.executeInternal(mapContent, request, delegate, Arrays.asList(currentTime), elevations);
                mapContent.layers().clear();
                images.add(((RenderedImageMap)map).getImage());
            }
            RenderedImageList imageList = new RenderedImageList(images);
            return new RenderedImageMap(mapContent, (RenderedImage)imageList, map.getMimeType());
        }
        if (numElevations > 1 && isMultivaluedSupported) {
            WebMap map = null;
            ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
            for (Object currentElevation : elevations) {
                map = this.executeInternal(mapContent, request, delegate, times, Arrays.asList(currentElevation));
                mapContent.layers().clear();
                images.add(((RenderedImageMap)map).getImage());
            }
            RenderedImageList imageList = new RenderedImageList(images);
            return new RenderedImageMap(mapContent, (RenderedImage)imageList, map.getMimeType());
        }
        return this.executeInternal(mapContent, request, delegate, times, elevations);
    }

    WebMap executeInternal(WMSMapContent mapContent, GetMapRequest request, GetMapOutputFormat delegate, List<Object> times, List<Object> elevations) throws IOException {
        Envelope envelope = request.getBbox();
        List<MapLayerInfo> layers = request.getLayers();
        List<Map<String, String>> viewParams = request.getViewParams();
        Style[] styles = request.getStyles().toArray(new Style[0]);
        Filter[] filters = this.buildLayersFilters(request.getFilter(), layers);
        CoordinateReferenceSystem mapcrs = request.getCrs();
        if (mapcrs != null) {
            mapContent.getViewport().setBounds(new ReferencedEnvelope(envelope, mapcrs));
        } else {
            mapContent.getViewport().setBounds(new ReferencedEnvelope(envelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        }
        mapContent.setMapWidth(request.getWidth());
        mapContent.setMapHeight(request.getHeight());
        mapContent.setAngle(request.getAngle());
        mapContent.setBgColor(request.getBgColor());
        mapContent.setTransparent(request.isTransparent());
        mapContent.setBuffer(request.getBuffer());
        mapContent.setPalette(request.getPalette());
        if (request.getWidth() <= 0 || request.getHeight() <= 0 || mapContent.getRenderingArea().getSpan(0) <= 0.0 || mapContent.getRenderingArea().getSpan(1) <= 0.0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("We are not going to render anything because either the area is null or the dimensions are not positive.");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up map");
        }
        this.fireMapContentInit(mapContent);
        boolean cachingPossible = request.isGet();
        String featureVersion = request.getFeatureVersion();
        int maxAge = Integer.MAX_VALUE;
        for (int i = 0; i < layers.size(); ++i) {
            CachedGridReaderLayer layer;
            FeatureLayer featureLayer;
            FeatureSource<? extends FeatureType, ? extends Feature> source;
            MapLayerInfo mapLayerInfo = layers.get(i);
            if (cachingPossible &= mapLayerInfo.isCachingEnabled()) {
                maxAge = Math.min(maxAge, mapLayerInfo.getCacheMaxAge());
            } else {
                cachingPossible = false;
            }
            Style layerStyle = styles[i];
            Filter layerFilter = SimplifyingFilterVisitor.simplify((Filter)filters[i]);
            int layerType = mapLayerInfo.getType();
            if (layerType == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                source = mapLayerInfo.getRemoteFeatureSource();
                featureLayer = new FeatureLayer((FeatureSource)source, layerStyle);
                featureLayer.setTitle(((SimpleFeatureType)mapLayerInfo.getRemoteFeatureSource().getSchema()).getTypeName());
                Query definitionQuery = new Query(((SimpleFeatureType)source.getSchema()).getTypeName());
                definitionQuery.setFilter(layerFilter);
                definitionQuery.setVersion(featureVersion);
                int maxFeatures = request.getMaxFeatures() != null ? request.getMaxFeatures() : Integer.MAX_VALUE;
                definitionQuery.setMaxFeatures(maxFeatures);
                featureLayer.setQuery(definitionQuery);
                mapContent.addLayer((org.geotools.map.Layer)featureLayer);
                layer = featureLayer;
                continue;
            }
            if (layerType == MapLayerInfo.TYPE_VECTOR) {
                Integer startIndex;
                try {
                    source = mapLayerInfo.getFeatureSource(true);
                }
                catch (IOException exp) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, new StringBuffer("Getting feature source: ").append(exp.getMessage()).toString(), exp);
                    }
                    throw new ServiceException("Internal error", (Throwable)exp);
                }
                featureLayer = new FeatureLayer(source, layerStyle);
                featureLayer.setTitle(mapLayerInfo.getFeature().prefixedName());
                featureLayer.getUserData().put("abstract", mapLayerInfo.getDescription());
                Filter dimensionFilter = this.wms.getTimeElevationToFilter(times, elevations, mapLayerInfo.getFeature());
                Filter filter = SimplifyingFilterVisitor.simplify((Filter)Filters.and((FilterFactory)this.ff, (Filter)layerFilter, (Filter)dimensionFilter));
                Query definitionQuery = new Query(source.getSchema().getName().getLocalPart());
                definitionQuery.setVersion(featureVersion);
                definitionQuery.setFilter(filter);
                if (viewParams != null) {
                    definitionQuery.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, viewParams.get(i)));
                }
                if ((startIndex = request.getStartIndex()) != null) {
                    QueryCapabilities queryCapabilities = source.getQueryCapabilities();
                    if (queryCapabilities.isOffsetSupported()) {
                        definitionQuery.setStartIndex(startIndex);
                    } else {
                        throw new ServiceException("startIndex is not supported for the " + mapLayerInfo.getName() + " layer");
                    }
                }
                int maxFeatures = request.getMaxFeatures() != null ? request.getMaxFeatures() : Integer.MAX_VALUE;
                definitionQuery.setMaxFeatures(maxFeatures);
                featureLayer.setQuery(definitionQuery);
                mapContent.addLayer((org.geotools.map.Layer)featureLayer);
                layer = featureLayer;
                continue;
            }
            if (layerType == MapLayerInfo.TYPE_RASTER) {
                GridCoverage2DReader reader = (GridCoverage2DReader)mapLayerInfo.getCoverageReader();
                if (reader != null) {
                    GeneralParameterValue[] readParameters = this.wms.getWMSReadParameters(request, mapLayerInfo, layerFilter, times, elevations, reader, false);
                    try {
                        try {
                            layer = new CachedGridReaderLayer(reader, layerStyle, readParameters);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        layer.setTitle(mapLayerInfo.getCoverage().prefixedName());
                        mapContent.addLayer((org.geotools.map.Layer)layer);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Wrapping GC in feature source: " + e.getLocalizedMessage(), e);
                        }
                        throw new ServiceException("Internal error : unable to get reader for this coverage layer " + mapLayerInfo);
                    }
                }
                throw new ServiceException(new StringBuffer("Internal error : unable to get reader for this coverage layer ").append(mapLayerInfo.toString()).toString());
            }
            if (layerType == MapLayerInfo.TYPE_WMS) {
                WMSLayer lastWMS;
                WebMapServer otherWMS;
                org.geotools.map.Layer lastLayer;
                WMSLayerInfo wmsLayer = (WMSLayerInfo)mapLayerInfo.getResource();
                WebMapServer wms = wmsLayer.getStore().getWebMapServer(null);
                Layer gt2Layer = wmsLayer.getWMSLayer(null);
                boolean merged = false;
                if (mapContent.layers().size() > 0 && (lastLayer = (org.geotools.map.Layer)mapContent.layers().get(mapContent.layers().size() - 1)) instanceof WMSLayer && (otherWMS = (lastWMS = (WMSLayer)lastLayer).getWebMapServer()).equals(wms)) {
                    lastWMS.addLayer(gt2Layer);
                    merged = true;
                }
                if (merged) continue;
                WMSLayer Layer2 = new WMSLayer(wms, gt2Layer);
                Layer2.setTitle(wmsLayer.prefixedName());
                mapContent.addLayer((org.geotools.map.Layer)Layer2);
                continue;
            }
            throw new IllegalArgumentException("Unkown layer type " + layerType);
        }
        RenderingVariables.setupEnvironmentVariables(mapContent);
        GetMap.setupRenderingBuffer(mapContent, layers);
        mapContent = this.fireBeforeRender(mapContent);
        WebMap map = delegate.produceMap(mapContent);
        if (cachingPossible) {
            map.setResponseHeader("Cache-Control", "max-age=" + maxAge + ", must-revalidate");
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            calendar.add(13, maxAge);
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            map.setResponseHeader("Expires", format.format(calendar.getTime()));
        }
        return map;
    }

    public static void setupRenderingBuffer(WMSMapContent map, List<MapLayerInfo> layers) {
        if (map.getBuffer() > 0) {
            return;
        }
        int[] layerBuffers = new int[layers.size()];
        boolean computeBuffer = false;
        for (int i = 0; i < layers.size(); ++i) {
            Integer layerBuffer;
            LayerInfo layerInfo = layers.get(i).getLayerInfo();
            if (layerInfo == null || (layerBuffer = (Integer)layerInfo.getMetadata().get("buffer", Integer.class)) == null || layerBuffer <= 0) continue;
            computeBuffer = true;
            layerBuffers[i] = layerBuffer;
        }
        if (computeBuffer) {
            double scaleDenominator = map.getScaleDenominator(true);
            int buffer = 0;
            for (int i = 0; i < layers.size(); ++i) {
                int layerBuffer = layerBuffers[i];
                if (layerBuffer == 0) {
                    layerBuffer = GetMap.computeLayerBuffer(((org.geotools.map.Layer)map.layers().get(i)).getStyle(), scaleDenominator);
                }
                if (layerBuffer <= buffer) continue;
                buffer = layerBuffer;
            }
            map.setBuffer(buffer);
        }
    }

    static int computeLayerBuffer(Style style, double scaleDenominator) {
        double TOLERANCE = 1.0E-6;
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            for (Rule rule : fts.rules()) {
                if (!(rule.getMinScaleDenominator() - 1.0E-6 <= scaleDenominator) || !(rule.getMaxScaleDenominator() + 1.0E-6 > scaleDenominator)) continue;
                estimator.visit(rule);
            }
        }
        return estimator.getBuffer();
    }

    private void assertMandatory(GetMapRequest request) throws ServiceException {
        if (0 >= request.getWidth() || 0 >= request.getHeight()) {
            throw new ServiceException("Missing or invalid requested map size. Parameters WIDTH and HEIGHT shall be present and be integers > 0. Got WIDTH=" + request.getWidth() + ", HEIGHT=" + request.getHeight(), "MissingOrInvalidParameter");
        }
        if (request.getLayers().size() == 0) {
            throw new ServiceException("No layers have been requested", "LayerNotDefined");
        }
        if (request.getStyles().size() == 0) {
            throw new ServiceException("No styles have been requested", "StyleNotDefined");
        }
        if (request.getFormat() == null) {
            throw new ServiceException("No output map format requested", "InvalidFormat");
        }
        Envelope env = request.getBbox();
        if (env == null) {
            throw new ServiceException("GetMap requests must include a BBOX parameter.", "MissingBBox");
        }
        if (env.isNull() || env.getWidth() <= 0.0 || env.getHeight() <= 0.0) {
            throw new ServiceException(new StringBuffer("The request bounding box has zero area: ").append(env).toString(), "InvalidBBox");
        }
    }

    private Filter[] buildLayersFilters(List<Filter> requestFilters, List<MapLayerInfo> layers) {
        int nLayers = layers.size();
        if (requestFilters == null || requestFilters.size() == 0) {
            requestFilters = Collections.nCopies(layers.size(), Filter.INCLUDE);
        } else if (requestFilters.size() != nLayers) {
            throw new IllegalArgumentException("requested filters and number of layers do not match");
        }
        Filter[] combinedList = new Filter[nLayers];
        for (int i = 0; i < nLayers; ++i) {
            MapLayerInfo layer = layers.get(i);
            Filter userRequestedFilter = requestFilters.get(i);
            if (layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR || layer.getType() == MapLayerInfo.TYPE_RASTER) {
                combinedList[i] = userRequestedFilter;
                continue;
            }
            if (layer.getType() != MapLayerInfo.TYPE_VECTOR) continue;
            Filter layerDefinitionFilter = layer.getFeature().filter();
            if (layerDefinitionFilter == null) {
                layerDefinitionFilter = Filter.INCLUDE;
            }
            And combined = this.ff.and(layerDefinitionFilter, userRequestedFilter);
            FeatureTypeConstraint[] featureTypeConstraints = layer.getLayerFeatureConstraints();
            if (featureTypeConstraints != null) {
                ArrayList<Filter> filters = new ArrayList<Filter>();
                for (int j = 0; j < featureTypeConstraints.length; ++j) {
                    FeatureTypeConstraint featureTypeConstraint = featureTypeConstraints[j];
                    filters.add(featureTypeConstraint.getFilter());
                }
                combined = this.ff.and((Filter)combined, (Filter)this.ff.and(filters));
            }
            combinedList[i] = combined;
        }
        return combinedList;
    }

    private GetMapOutputFormat getDelegate(String outputFormat) throws ServiceException {
        GetMapOutputFormat producer = this.wms.getMapOutputFormat(outputFormat);
        if (producer == null) {
            ServiceException e = new ServiceException("There is no support for creating maps in " + outputFormat + " format", "InvalidFormat");
            e.setCode("InvalidFormat");
            throw e;
        }
        if (!this.wms.isAllowedGetMapFormat(producer)) {
            throw this.wms.unallowedGetMapFormatException(outputFormat);
        }
        return producer;
    }
}

