/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.WMS;
import org.geoserver.wms.capabilities.Capabilities_1_3_0_Transformer;
import org.geoserver.wms.capabilities.GetCapabilitiesTransformer;
import org.geotools.util.Version;
import org.geotools.xml.transform.TransformerBase;

public class GetCapabilities {
    private final WMS wms;

    public GetCapabilities(WMS wms) {
        this.wms = wms;
    }

    public TransformerBase run(GetCapabilitiesRequest request) throws ServiceException {
        TransformerBase transformer;
        long geoUS;
        Version version = WMS.version(request.getVersion());
        if (version == null) {
            throw new IllegalArgumentException("version not supplied.");
        }
        long reqUS = -1L;
        if (request.getUpdateSequence() != null && !"".equals(request.getUpdateSequence().trim())) {
            try {
                reqUS = Long.parseLong(request.getUpdateSequence());
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException("GeoServer only accepts numbers in the updateSequence parameter");
            }
        }
        if (reqUS > (geoUS = this.wms.getUpdateSequence())) {
            throw new ServiceException("Client supplied an updateSequence that is greater than the current server updateSequence", "InvalidUpdateSequence");
        }
        if (reqUS == geoUS) {
            throw new ServiceException("WMS capabilities document is current (updateSequence = " + geoUS + ")", "CurrentUpdateSequence");
        }
        Set<String> legendFormats = this.wms.getAvailableLegendGraphicsFormats();
        String baseUrl = request.getBaseUrl();
        if (WMS.VERSION_1_1_1.equals((Object)version)) {
            Set<String> mapFormats = this.wms.getAllowedMapFormatNames();
            List<ExtendedCapabilitiesProvider> extCapsProviders = this.wms.getAvailableExtendedCapabilitiesProviders();
            transformer = new GetCapabilitiesTransformer(this.wms, baseUrl, mapFormats, legendFormats, extCapsProviders);
        } else if (WMS.VERSION_1_3_0.equals((Object)version)) {
            Collection<GetMapOutputFormat> mapFormats = this.wms.getAllowedMapFormats();
            List<ExtendedCapabilitiesProvider> extCapsProviders = this.wms.getAvailableExtendedCapabilitiesProviders();
            transformer = new Capabilities_1_3_0_Transformer(this.wms, baseUrl, mapFormats, extCapsProviders);
        } else {
            throw new IllegalArgumentException("Unknown version: " + version);
        }
        return transformer;
    }
}

