/*
 * Decompiled with CFR 0.152.
 */
package simple.util.cache;

import java.util.HashMap;

public class CacheList {
    private static final int DEFAULT_SIZE = 16;
    private HashMap map;
    private Entry root;
    private Entry tail;
    private int maxSize;
    private int items;

    public CacheList() {
        this(16);
    }

    public CacheList(int maxSize) {
        this.map = new HashMap((maxSize + 1) * 2, 0.2f);
        this.maxSize = maxSize;
    }

    public synchronized void insert(Object key, Object obj) {
        Entry entry = new Entry();
        entry.data = obj;
        entry.key = key;
        this.remove(key);
        this.map.put(key, entry);
        this.insert(entry);
        this.clean();
    }

    /*
     * Unable to fully structure code
     */
    private void clean() {
        if (this.items > this.maxSize) ** GOTO lbl6
        return;
        while (!((float)this.items <= (float)this.maxSize * 0.8f)) {
            this.remove(this.tail.key);
lbl6:
            // 2 sources

            if (this.tail != null) continue;
        }
    }

    private void insert(Entry entry) {
        if (this.items == 0) {
            Entry end = new Entry();
            Entry start = entry;
            start.prev = null;
            end.next = null;
            end.prev = start;
            start.next = end;
            this.root = start;
            this.tail = end;
        } else if (this.items == 1) {
            Entry end = this.root;
            Entry start = entry;
            start.prev = null;
            end.next = null;
            end.prev = start;
            start.next = end;
            this.root = start;
            this.tail = end;
        } else {
            Entry next = this.root;
            Entry start = entry;
            start.prev = null;
            start.next = next;
            next.prev = start;
            this.root = start;
        }
        ++this.items;
    }

    public synchronized boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    public synchronized Object lookup(Object key) {
        Object entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        this.top((Entry)entry);
        return this.root.data;
    }

    private void top(Entry entry) {
        if (entry != null && entry != this.root && this.items > 0) {
            if (entry == this.tail) {
                Entry end = this.tail.prev;
                Entry start = entry;
                Entry next = this.root;
                end.next = null;
                start.prev = null;
                start.next = next;
                next.prev = start;
                this.root = start;
                this.tail = end;
            } else {
                Entry prev = entry.prev;
                Entry next = entry.next;
                Entry start = entry;
                next.prev = prev;
                prev.next = next;
                start.prev = null;
                start.next = null;
                start.next = this.root;
                this.root.prev = start;
                this.root = start;
            }
        }
    }

    public synchronized Object remove(Object key) {
        return this.remove((Entry)this.map.remove(key));
    }

    private Object remove(Entry entry) {
        if (entry != null && this.items > 0) {
            if (this.root == this.tail) {
                this.root = null;
            } else if (entry == this.tail) {
                this.tail = this.tail.prev;
                this.tail.next = null;
            } else if (entry == this.root) {
                this.root = this.root.next;
                this.root.prev = null;
            } else {
                entry.prev.next = entry.next;
                entry.next.prev = entry.prev;
            }
            --this.items;
            return entry.data;
        }
        return null;
    }

    public synchronized void resize(int maxSize) {
        this.maxSize = maxSize;
        this.clean();
    }

    public synchronized int length() {
        return this.items;
    }

    public synchronized int capacity() {
        return this.maxSize;
    }

    public synchronized void clear() {
        if (this.items > 0) {
            this.map.clear();
        }
        this.root = null;
        this.tail = null;
        this.items = 0;
    }

    private class Entry {
        public Object data;
        public Object key;
        public Entry next;
        public Entry prev;

        private Entry() {
        }
    }
}

