/*
 * Decompiled with CFR 0.152.
 */
package simple.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import simple.util.Match;
import simple.util.cache.CacheList;

public class Resolver
implements Serializable {
    private static final int DEFAULT_CACHE = 512;
    private transient CacheList cache;
    private Vector matches;
    private int size;

    public Resolver() {
        this(512);
    }

    public Resolver(int size) {
        this.cache = new CacheList(size);
        this.matches = new Vector();
        this.size = size;
    }

    public synchronized String resolve(String text) {
        Entry entry;
        if (this.cache.contains(text) && (entry = (Entry)this.cache.lookup(text)) != null) {
            return entry.match;
        }
        char[] array = text.toCharArray();
        int pos = this.matches.size() - 1;
        while (pos >= 0) {
            Entry entry2 = (Entry)this.matches.elementAt(pos);
            if (this.match(array, entry2.array)) {
                this.cache.insert(text, entry2);
                return entry2.match;
            }
            --pos;
        }
        return null;
    }

    public synchronized void insert(String pattern, String match) {
        if (match.length() > 0) {
            Entry entry = new Entry(pattern, match);
            this.matches.addElement(entry);
            this.cache.clear();
        }
    }

    public synchronized void insert(String pattern, String match, int pos) {
        if (match.length() > 0) {
            Entry entry = new Entry(pattern, match);
            this.matches.insertElementAt(entry, pos);
            this.cache.clear();
        }
    }

    public synchronized void remove(int pos) {
        this.matches.removeElementAt(pos);
        this.cache.clear();
    }

    public synchronized void remove(String pattern) {
        this.matches.remove(new Entry(pattern, ""));
        this.cache.clear();
    }

    public synchronized void remove(Match match) {
        this.matches.remove(match);
        this.cache.clear();
    }

    public synchronized Match[] getMatches() {
        Match[] list = new Match[this.matches.size()];
        return this.matches.toArray(list);
    }

    public synchronized Match getMatch(int pos) {
        return (Match)this.matches.elementAt(pos);
    }

    public synchronized Match getMatch(String pattern) {
        int index = this.indexOf(pattern);
        return index >= 0 ? this.getMatch(index) : null;
    }

    public synchronized int indexOf(String pattern) {
        return this.matches.indexOf(new Entry(pattern, ""));
    }

    public synchronized int indexOf(String pattern, int from) {
        return this.matches.indexOf(new Entry(pattern, ""));
    }

    public synchronized boolean contains(String pattern) {
        return this.matches.contains(new Entry(pattern, ""));
    }

    public synchronized boolean contains(Match match) {
        return this.matches.contains(match);
    }

    public synchronized boolean isEmpty() {
        return this.matches.isEmpty();
    }

    public synchronized int size() {
        return this.matches.size();
    }

    public synchronized void clear() {
        this.matches.clear();
        this.cache.clear();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cache = new CacheList(this.size);
    }

    private boolean match(char[] str, char[] wild) {
        return this.match(str, 0, wild, 0);
    }

    /*
     * Unable to fully structure code
     */
    private boolean match(char[] str, int off, char[] wild, int pos) {
        while (pos < wild.length && off < str.length) {
            block7: {
                if (wild[pos] != '*') break block7;
                while (wild[pos] == '*') {
                    if (++pos < wild.length) continue;
                    return true;
                }
                if (wild[pos] != '?' || ++pos < wild.length) ** GOTO lbl13
                return true;
lbl-1000:
                // 1 sources

                {
                    if (str[off] == wild[pos] || wild[pos] == '?') {
                        if (wild[pos - 1] == '?') break;
                        if (this.match(str, off, wild, pos)) {
                            return true;
                        }
                    }
                    ++off;
lbl13:
                    // 2 sources

                    ** while (off < str.length)
                }
lbl14:
                // 2 sources

                if (str.length == off) {
                    return false;
                }
            }
            if (str[off++] == wild[pos++] || wild[pos - 1] == '?') continue;
            return false;
        }
        if (wild.length != pos) ** GOTO lbl23
        return str.length == off;
lbl-1000:
        // 1 sources

        {
            if (++pos < wild.length) continue;
            return true;
lbl23:
            // 2 sources

            ** while (wild[pos] == '*')
        }
lbl24:
        // 1 sources

        return false;
    }

    private class Entry
    implements Match {
        public char[] array;
        public String pattern;
        public String match;

        public Entry(String pattern, String match) {
            this.array = pattern.toCharArray();
            this.match = match.toString();
            this.pattern = pattern;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getMatch() {
            return this.match;
        }

        public boolean equals(Match item) {
            if (this.match.equals("") || item.getMatch().equals("")) {
                return item.getPattern().equals(this.pattern);
            }
            return item.getMatch().equals(this.match) && item.getPattern().equals(this.pattern);
        }

        public boolean equals(Object item) {
            if (item instanceof Match) {
                return this.equals((Match)item);
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.pattern) + "=" + this.match;
        }
    }
}

