/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import java.io.File;
import simple.http.Request;
import simple.http.Response;
import simple.http.serve.CacheContext;
import simple.http.serve.Component;
import simple.http.serve.Context;
import simple.http.serve.DirectoryComponent;
import simple.http.serve.FileComponent;
import simple.http.serve.Resource;
import simple.http.serve.ResourceEngine;

public class FileEngine
implements ResourceEngine {
    protected Context context;

    public FileEngine() {
        this(new CacheContext());
    }

    public FileEngine(Context context) {
        this.context = context;
    }

    public Resource resolve(String target) {
        return this.resolve(target, this.context.getFile(target));
    }

    protected Resource resolve(String target, File file) {
        if (file.isDirectory()) {
            return new DirectoryComponent(this.context, target);
        }
        if (file.isFile()) {
            return new FileComponent(this.context, target);
        }
        return new Component(this.context){

            protected void process(Request req, Response resp) {
                this.handle(req, resp, 404);
            }
        };
    }
}

