/*
 * Decompiled with CFR 0.152.
 */
package simple.http.load;

import simple.http.Request;
import simple.http.Response;
import simple.http.load.Service;
import simple.http.serve.Component;
import simple.http.serve.Context;
import simple.http.serve.Resource;

public abstract class Redirect
extends Service {
    public Redirect(Context context) {
        super(context);
    }

    protected void process(Request req, Response resp) throws Exception {
        this.redirect(req, resp).handle(req, resp);
    }

    public Resource lookup(String target) throws Exception {
        return this.engine.lookup(target);
    }

    public Resource resolve(String target) throws Exception {
        if (target.startsWith("/")) {
            return this.engine.resolve(target);
        }
        return new Delegate(this.context, target);
    }

    public abstract Resource redirect(Request var1, Response var2) throws Exception;

    private class Delegate
    extends Component {
        private String target;

        public Delegate(Context context, String target) {
            this.target = target.replaceFirst("\\?.*", "");
            this.context = context;
        }

        protected void process(Request req, Response resp) throws Exception {
            String query = "?" + req.getParameters();
            if (query.length() > 1) {
                this.target = String.valueOf(this.target) + query;
            }
            resp.set("Location", this.target);
            this.handle(req, resp, 302);
        }
    }
}

