/*
 * Decompiled with CFR 0.152.
 */
package simple.http;

import java.io.IOException;
import java.io.OutputStream;
import simple.http.MonitoredOutputStream;
import simple.http.OutputMonitor;

class FixedOutputStream
extends MonitoredOutputStream {
    private boolean finished;
    private int count;
    private int limit;

    public FixedOutputStream(OutputStream out, OutputMonitor mon, int limit) {
        super(out, mon);
        this.limit = limit;
        if (limit <= 0) {
            mon.notifyFinished(out);
            this.finished = true;
        }
    }

    protected void writeBytes(byte[] buf, int off, int len) throws IOException {
        int remaining = this.limit - this.count;
        int min = Math.min(len, remaining);
        if (!this.finished) {
            this.out.write(buf, off, min);
            if (this.count + min == this.limit) {
                this.mon.notifyFinished(this.out);
                this.finished = true;
            }
            this.count += min;
        }
    }

    protected void flushBytes() throws IOException {
        this.out.flush();
    }

    protected void doClose() throws IOException {
        if (!this.finished) {
            throw new IOException("Bad close");
        }
    }
}

