/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wms;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.meta.ServiceContact;
import org.geowebcache.config.meta.ServiceInformation;
import org.geowebcache.config.meta.ServiceProvider;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.WMSDimensionProvider;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.XMLBuilder;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.layer.meta.MetadataURL;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.ServletUtils;
import org.geowebcache.util.URLMangler;

public class WMSGetCapabilities {
    private static Log log = LogFactory.getLog(WMSGetCapabilities.class);
    private TileLayerDispatcher tld;
    private String urlStr;
    private boolean includeVendorSpecific = false;

    protected WMSGetCapabilities(TileLayerDispatcher tld, HttpServletRequest servReq, String baseUrl, String contextPath, URLMangler urlMangler) {
        this.tld = tld;
        this.urlStr = urlMangler.buildURL(baseUrl, contextPath, "/service/wms") + "?SERVICE=WMS&";
        String[] tiledKey = new String[]{"TILED"};
        Map tiledValue = ServletUtils.selectedStringsFromMap((Map)servReq.getParameterMap(), (String)servReq.getCharacterEncoding(), (String[])tiledKey);
        if (tiledValue != null && tiledValue.size() > 0) {
            this.includeVendorSpecific = Boolean.parseBoolean((String)tiledValue.get("TILED"));
        }
    }

    protected void writeResponse(HttpServletResponse response) {
        Charset encoding = StandardCharsets.UTF_8;
        byte[] data = this.generateGetCapabilities(encoding).getBytes(encoding);
        response.setStatus(200);
        response.setContentType("application/vnd.ogc.wms_xml");
        response.setCharacterEncoding(encoding.name());
        response.setContentLength(data.length);
        response.setHeader("content-disposition", "inline;filename=wms-getcapabilities.xml");
        try (ServletOutputStream os = response.getOutputStream();){
            os.write(data);
            os.flush();
        }
        catch (IOException ioe) {
            log.debug((Object)("Caught IOException" + ioe.getMessage()));
        }
    }

    String generateGetCapabilities(Charset encoding) {
        StringBuilder str = new StringBuilder();
        XMLBuilder xml = new XMLBuilder((Appendable)str);
        try {
            xml.header("1.0", encoding);
            xml.appendUnescaped("<!DOCTYPE WMT_MS_Capabilities SYSTEM \"http://schemas.opengis.net/wms/1.1.1/capabilities_1_1_1.dtd\" ");
            if (this.includeVendorSpecific) {
                xml.appendUnescaped("[\n");
                xml.appendUnescaped("<!ELEMENT VendorSpecificCapabilities (TileSet*) >\n");
                xml.appendUnescaped("<!ELEMENT TileSet (SRS, BoundingBox?, Resolutions, Width, Height, Format, Layers*, Styles*) >\n");
                xml.appendUnescaped("<!ELEMENT Resolutions (#PCDATA) >\n");
                xml.appendUnescaped("<!ELEMENT Width (#PCDATA) >\n");
                xml.appendUnescaped("<!ELEMENT Height (#PCDATA) >\n");
                xml.appendUnescaped("<!ELEMENT Layers (#PCDATA) >\n");
                xml.appendUnescaped("<!ELEMENT Styles (#PCDATA) >\n");
                xml.appendUnescaped("]");
            }
            xml.appendUnescaped(">\n");
            xml.indentElement("WMT_MS_Capabilities").attribute("version", "1.1.1");
            this.service(xml);
            this.capability(xml);
            xml.endElement();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return str.toString();
    }

    private void service(XMLBuilder xml) throws IOException {
        ServiceInformation servInfo = this.tld.getServiceInformation();
        xml.indentElement("Service");
        xml.indentElement("Name").text("OGC:WMS").endElement();
        if (servInfo == null) {
            xml.indentElement("Title").text("Web Map Service - GeoWebCache").endElement();
        } else {
            xml.indentElement("Title").text(servInfo.getTitle()).endElement();
            xml.indentElement("Abstract").text(servInfo.getDescription()).endElement();
            if (servInfo.getKeywords() != null) {
                xml.indentElement("KeywordList");
                Iterator keywordIter = servInfo.getKeywords().iterator();
                while (keywordIter.hasNext()) {
                    xml.indentElement("Keyword").text((String)keywordIter.next()).endElement();
                }
                xml.endElement();
            }
        }
        this.onlineResource(xml, this.urlStr);
        this.serviceContact(xml);
        if (servInfo != null) {
            xml.indentElement("Fees").text(servInfo.getFees()).endElement();
            xml.indentElement("AccessConstraints").text(servInfo.getAccessConstraints()).endElement();
        }
        xml.endElement();
    }

    private void serviceContact(XMLBuilder xml) throws IOException {
        ServiceInformation servInfo = this.tld.getServiceInformation();
        if (servInfo == null) {
            return;
        }
        ServiceProvider servProv = servInfo.getServiceProvider();
        if (servProv == null) {
            return;
        }
        ServiceContact servCont = servProv.getServiceContact();
        xml.indentElement("ContactInformation");
        if (servProv.getProviderName() != null || servCont != null) {
            xml.indentElement("ContactPersonPrimary");
            if (servCont != null) {
                xml.simpleElement("ContactPerson", servCont.getIndividualName(), true);
            }
            xml.simpleElement("ContactOrganization", servProv.getProviderName(), true);
            xml.endElement();
            if (servCont != null) {
                xml.simpleElement("ContactPosition", servCont.getPositionName(), true);
                xml.indentElement("ContactAddress");
                xml.simpleElement("AddressType", servCont.getAddressType(), true);
                xml.simpleElement("Address", servCont.getAddressStreet(), true);
                xml.simpleElement("City", servCont.getAddressCity(), true);
                xml.simpleElement("StateOrProvince", servCont.getAddressAdministrativeArea(), true);
                xml.simpleElement("PostCode", servCont.getAddressPostalCode(), true);
                xml.simpleElement("Country", servCont.getAddressCountry(), true);
                xml.endElement();
                xml.simpleElement("ContactVoiceTelephone", servCont.getPhoneNumber(), true);
                xml.simpleElement("ContactFacsimileTelephone", servCont.getFaxNumber(), true);
                xml.simpleElement("ContactElectronicMailAddress", servCont.getAddressEmail(), true);
            }
        }
        xml.endElement();
    }

    private void capability(XMLBuilder xml) throws IOException {
        xml.indentElement("Capability");
        xml.indentElement("Request");
        this.capabilityRequestGetCapabilities(xml);
        this.capabilityRequestGetMap(xml);
        this.capabilityRequestGetFeatureInfo(xml);
        this.capabilityRequestDescribeLayer(xml);
        this.capabilityRequestGetLegendGraphic(xml);
        xml.endElement();
        this.capabilityException(xml);
        if (this.includeVendorSpecific) {
            this.capabilityVendorSpecific(xml);
        }
        this.capabilityLayerOuter(xml);
        xml.endElement();
    }

    XMLBuilder onlineResource(XMLBuilder xml, String url) throws IOException {
        return xml.indentElement("OnlineResource").attribute("xmlns:xlink", "http://www.w3.org/1999/xlink").attribute("xlink:type", "simple").attribute("xlink:href", url).endElement();
    }

    XMLBuilder dcpType(XMLBuilder xml, String url) throws IOException {
        xml.indentElement("DCPType");
        xml.indentElement("HTTP");
        xml.indentElement("Get");
        this.onlineResource(xml, url);
        xml.endElement();
        xml.endElement();
        xml.endElement();
        return xml;
    }

    XMLBuilder capability(XMLBuilder xml, String name, Collection<String> formats, String url) throws IOException {
        xml.indentElement(name);
        for (String format : formats) {
            xml.simpleElement("Format", format, true);
        }
        this.dcpType(xml, url);
        xml.endElement();
        return xml;
    }

    private void capabilityRequestGetCapabilities(XMLBuilder xml) throws IOException {
        this.capability(xml, "GetCapabilities", Collections.singleton("application/vnd.ogc.wms_xml"), this.urlStr);
    }

    private void capabilityRequestGetMap(XMLBuilder xml) throws IOException {
        Iterable layerIter = this.tld.getLayerList();
        HashSet<String> formats = new HashSet<String>();
        for (TileLayer layer : layerIter) {
            if (!layer.isEnabled() || !layer.isAdvertised()) continue;
            if (layer.getMimeTypes() != null) {
                for (MimeType mime : layer.getMimeTypes()) {
                    formats.add(mime.getFormat());
                }
                continue;
            }
            formats.add("image/png");
            formats.add("image/jpeg");
        }
        this.capability(xml, "GetMap", formats, this.urlStr);
    }

    private void capabilityRequestGetFeatureInfo(XMLBuilder xml) throws IOException {
        Iterable layerIter = this.tld.getLayerList();
        HashSet<String> formats = new HashSet<String>();
        for (TileLayer layer : layerIter) {
            if (!layer.isEnabled() || !layer.isAdvertised()) continue;
            if (layer.getMimeTypes() != null) {
                for (MimeType mime : layer.getInfoMimeTypes()) {
                    formats.add(mime.getFormat());
                }
                continue;
            }
            formats.add("text/plain");
            formats.add("text/html");
            formats.add("application/vnd.ogc.gml");
        }
        this.capability(xml, "GetFeatureInfo", formats, this.urlStr);
    }

    private void capabilityRequestDescribeLayer(XMLBuilder xml) throws IOException {
        this.capability(xml, "DescribeLayer", Collections.singleton("application/vnd.ogc.wms_xml"), this.urlStr);
    }

    private void capabilityRequestGetLegendGraphic(XMLBuilder xml) throws IOException {
        this.capability(xml, "GetLegendGraphic", Arrays.asList("image/png", "image/jpeg", "image/gif"), this.urlStr);
    }

    private void capabilityException(XMLBuilder xml) throws IOException {
        xml.indentElement("Exception");
        xml.simpleElement("Format", "application/vnd.ogc.se_xml", true);
        xml.endElement();
    }

    private void capabilityVendorSpecific(XMLBuilder xml) throws IOException {
        xml.indentElement("VendorSpecificCapabilities");
        Iterable layerIter = this.tld.getLayerList();
        for (TileLayer layer : layerIter) {
            if (!layer.isEnabled() || !layer.isAdvertised()) continue;
            for (String gridSetId : layer.getGridSubsets()) {
                GridSubset grid = layer.getGridSubset(gridSetId);
                ArrayList<String> formats = new ArrayList<String>(2);
                if (layer.getMimeTypes() != null) {
                    for (MimeType mime : layer.getMimeTypes()) {
                        formats.add(mime.getFormat());
                    }
                } else {
                    formats.add(ImageMime.png.getFormat());
                    formats.add(ImageMime.jpeg.getFormat());
                }
                List<String> styles = this.getStyles(layer.getParameterFilters());
                for (String format : formats) {
                    for (String style : styles) {
                        try {
                            this.capabilityVendorSpecificTileset(xml, layer, grid, format, style);
                        }
                        catch (GeoWebCacheException e) {
                            log.error((Object)e.getMessage());
                        }
                    }
                }
            }
        }
        xml.endElement();
    }

    private List<String> getStyles(List<ParameterFilter> parameterFilters) {
        ArrayList<String> styles = new ArrayList<String>(2);
        styles.add("");
        if (parameterFilters != null) {
            for (ParameterFilter filter : parameterFilters) {
                if (!"STYLES".equalsIgnoreCase(filter.getKey())) continue;
                String defaultStyle = filter.getDefaultValue();
                for (String style : filter.getLegalValues()) {
                    if (defaultStyle.equals(style)) continue;
                    styles.add(style);
                }
            }
        }
        return styles;
    }

    private void capabilityVendorSpecificTileset(XMLBuilder xml, TileLayer layer, GridSubset grid, String formatStr, String styleName) throws GeoWebCacheException, IOException {
        String srsStr = grid.getSRS().toString();
        StringBuilder resolutionsStr = new StringBuilder();
        double[] res = grid.getResolutions();
        for (int i = 0; i < res.length; ++i) {
            resolutionsStr.append(Double.toString(res[i]) + " ");
        }
        String[] bs = this.boundsPrep(grid.getCoverageBestFitBounds());
        xml.indentElement("TileSet");
        xml.simpleElement("SRS", srsStr, true);
        xml.boundingBox(srsStr, (Object)bs[0], (Object)bs[1], (Object)bs[2], (Object)bs[3]);
        xml.simpleElement("Resolutions", resolutionsStr.toString(), true);
        xml.simpleElement("Width", Integer.toString(grid.getTileWidth()), true);
        xml.simpleElement("Height", Integer.toString(grid.getTileHeight()), true);
        xml.simpleElement("Format", formatStr, true);
        xml.simpleElement("Layers", layer.getName(), true);
        xml.simpleElement("Styles", ServletUtils.URLEncode((String)styleName), true);
        xml.endElement();
    }

    private void capabilityLayerOuter(XMLBuilder xml) throws IOException {
        xml.indentElement("Layer");
        xml.simpleElement("Title", "GeoWebCache WMS", true);
        xml.simpleElement("Abstract", "Note that not all GeoWebCache instances provide a full WMS service.", true);
        xml.latLonBoundingBox((Object)-180.0, (Object)-90.0, (Object)180.0, (Object)90.0);
        Iterable layerIter = this.tld.getLayerList();
        for (TileLayer layer : layerIter) {
            if (!layer.isEnabled() || !layer.isAdvertised()) continue;
            try {
                this.capabilityLayerInner(xml, layer);
            }
            catch (GeoWebCacheException e) {
                log.error((Object)e.getMessage());
            }
        }
        xml.endElement();
    }

    private void capabilityLayerInner(XMLBuilder xml, TileLayer layer) throws GeoWebCacheException, IOException {
        xml.indentElement("Layer");
        if (layer.isQueryable()) {
            xml.attribute("queryable", "1");
        }
        xml.simpleElement("Name", layer.getName(), true);
        if (layer.getMetaInformation() != null) {
            LayerMetaInformation metaInfo = layer.getMetaInformation();
            xml.simpleElement("Title", metaInfo.getTitle(), true);
            xml.simpleElement("Abstract", metaInfo.getDescription(), true);
        } else {
            xml.simpleElement("Title", layer.getName(), true);
        }
        if (layer.getMetadataURLs() != null) {
            for (MetadataURL metadataURL : layer.getMetadataURLs()) {
                xml.indentElement("MetadataURL");
                xml.attribute("type", metadataURL.getType());
                xml.simpleElement("Format", metadataURL.getFormat(), true);
                this.onlineResource(xml, metadataURL.getUrl().toString());
                xml.endElement();
            }
        }
        TreeSet<SRS> srsSet = new TreeSet<SRS>();
        HashSet<GridSubset> gridSubsetSet = new HashSet<GridSubset>();
        for (String gridSetId : layer.getGridSubsets()) {
            GridSubset curGridSubSet = layer.getGridSubset(gridSetId);
            SRS curSRS = curGridSubSet.getSRS();
            if (srsSet.contains(curSRS)) continue;
            srsSet.add(curSRS);
            gridSubsetSet.add(curGridSubSet);
        }
        for (SRS curSRS : srsSet) {
            xml.simpleElement("SRS", curSRS.toString(), true);
        }
        GridSubset epsg4326GridSubSet = layer.getGridSubsetForSRS(SRS.getEPSG4326());
        if (null != epsg4326GridSubSet) {
            String[] bs = this.boundsPrep(epsg4326GridSubSet.getCoverageBestFitBounds());
            xml.latLonBoundingBox((Object)bs[0], (Object)bs[1], (Object)bs[2], (Object)bs[3]);
        }
        for (GridSubset curGridSubSet : gridSubsetSet) {
            String[] bs = this.boundsPrep(curGridSubSet.getCoverageBestFitBounds());
            xml.boundingBox(curGridSubSet.getSRS().toString(), (Object)bs[0], (Object)bs[1], (Object)bs[2], (Object)bs[3]);
        }
        if (layer.getParameterFilters() != null) {
            StringBuilder dims = new StringBuilder();
            StringBuilder extents = new StringBuilder();
            for (ParameterFilter parameterFilter : layer.getParameterFilters()) {
                if (!(parameterFilter instanceof WMSDimensionProvider)) continue;
                ((WMSDimensionProvider)parameterFilter).appendDimensionElement(dims, "      ");
                ((WMSDimensionProvider)parameterFilter).appendExtentElement(extents, "      ");
            }
            if (dims.length() > 0 && extents.length() > 0) {
                xml.appendUnescaped(dims.toString());
                xml.appendUnescaped(extents.toString());
            }
        }
        xml.endElement();
    }

    String[] boundsPrep(BoundingBox bbox) {
        String[] bs = new String[]{Double.toString(bbox.getMinX()), Double.toString(bbox.getMinY()), Double.toString(bbox.getMaxX()), Double.toString(bbox.getMaxY())};
        return bs;
    }
}

