/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io;

import com.sun.media.imageioimpl.plugins.gif.GIFImageWriterSpi;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;

public class ImageIOInitializer {
    private static final Logger LOGGER = Logger.getLogger(ImageIOInitializer.class.toString());
    private IIORegistry registry;
    private List<String> excludedSpis;
    private static ImageIOInitializer instance;

    public static synchronized ImageIOInitializer getInstance(ArrayList<String> excludedSpis) {
        if (instance == null) {
            instance = new ImageIOInitializer(excludedSpis);
        }
        return instance;
    }

    private ImageIOInitializer(List<String> excludedSpis) {
        this.excludedSpis = excludedSpis;
        this.registry = IIORegistry.getDefaultInstance();
        ImageWriterSpi provider = (ImageWriterSpi)this.registry.getServiceProviderByClass(GIFImageWriterSpi.class);
        if (provider == null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Something must be registered");
            }
            ImageIO.scanForPlugins();
            this.removeSpis();
        }
    }

    private void removeSpis() {
        if (this.excludedSpis != null && !this.excludedSpis.isEmpty()) {
            for (String spi : this.excludedSpis) {
                try {
                    Class<?> clazz = Class.forName(spi);
                    Object provider = this.registry.getServiceProviderByClass(clazz);
                    if (provider == null) continue;
                    this.registry.deregisterServiceProvider(provider);
                }
                catch (ClassNotFoundException e) {
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                }
            }
        }
    }

    public synchronized IIORegistry getRegistry() {
        if (this.registry == null) {
            this.registry = IIORegistry.getDefaultInstance();
        }
        return this.registry;
    }

    public List<String> getExcludedSpis() {
        return this.excludedSpis;
    }

    public void setExcludedSpis(List<String> excludedSpis) {
        this.excludedSpis = excludedSpis;
    }
}

