/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io;

import java.awt.image.RenderedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geowebcache.io.ImageEncoder;
import org.geowebcache.mime.MimeType;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ImageEncoderContainer
implements ApplicationContextAware {
    private Collection<ImageEncoder> encoders;
    private Map<String, ImageEncoder> mapEncoders;

    public void encode(RenderedImage image, MimeType mimeType, Object destination, boolean aggressiveOutputStreamOptimization, Map<String, Object> map) throws Exception {
        if (this.mapEncoders == null) {
            throw new IllegalArgumentException("ApplicationContext must be set before encoding");
        }
        this.mapEncoders.get(mimeType.getMimeType()).encode(image, destination, aggressiveOutputStreamOptimization, mimeType, map);
    }

    public boolean isAggressiveOutputStreamSupported(String mimeType) {
        if (this.mapEncoders == null) {
            throw new IllegalArgumentException("ApplicationContext must be set before checking the AggressiveOutputStrean support");
        }
        return this.mapEncoders.get(mimeType).isAggressiveOutputStreamSupported();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.encoders = context.getBeansOfType(ImageEncoder.class).values();
        if (this.encoders == null || this.encoders.isEmpty()) {
            throw new IllegalArgumentException("No Encoder found");
        }
        this.mapEncoders = new HashMap<String, ImageEncoder>();
        for (ImageEncoder encoder : this.encoders) {
            List<String> supportedMimeTypes = encoder.getSupportedMimeTypes();
            for (String mimeType : supportedMimeTypes) {
                if (this.mapEncoders.containsKey(mimeType)) continue;
                this.mapEncoders.put(mimeType, encoder);
            }
        }
    }
}

