/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.io;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geowebcache.io.ImageDecoder;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ImageDecoderContainer
implements ApplicationContextAware {
    private Collection<ImageDecoder> decoders;
    private Map<String, ImageDecoder> mapDecoders;

    public BufferedImage decode(String mimeType, Object input, boolean aggressiveInputStreamOptimization, Map<String, Object> map) throws Exception {
        if (this.mapDecoders == null) {
            throw new IllegalArgumentException("ApplicationContext must be set before decoding");
        }
        return this.mapDecoders.get(mimeType).decode(input, aggressiveInputStreamOptimization, map);
    }

    public boolean isAggressiveInputStreamSupported(String mimeType) {
        if (this.mapDecoders == null) {
            throw new IllegalArgumentException("ApplicationContext must be set before checking the AggressiveInputStrean support");
        }
        return this.mapDecoders.get(mimeType).isAggressiveInputStreamSupported();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.decoders = context.getBeansOfType(ImageDecoder.class).values();
        if (this.decoders == null || this.decoders.isEmpty()) {
            throw new IllegalArgumentException("No Encoder found");
        }
        this.mapDecoders = new HashMap<String, ImageDecoder>();
        for (ImageDecoder encoder : this.decoders) {
            List<String> supportedMimeTypes = encoder.getSupportedMimeTypes();
            for (String mimeType : supportedMimeTypes) {
                if (this.mapDecoders.containsKey(mimeType)) continue;
                this.mapDecoders.put(mimeType, encoder);
            }
        }
    }
}

