/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.Point;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.Encoder;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class PointEncoder
extends GeometryEncoder<Point> {
    static final QualifiedName POINT = new QualifiedName("http://www.opengis.net/gml", "Point", "gml");
    static final QualifiedName POS = new QualifiedName("http://www.opengis.net/gml", "pos", "gml");
    QualifiedName point;
    QualifiedName pos;

    protected PointEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.point = POINT.derive(gmlPrefix);
        this.pos = POS.derive(gmlPrefix);
    }

    public void encode(Point geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.point, (Attributes)atts);
        handler.startElement(this.pos, null);
        handler.position(geometry.getCoordinate().x, geometry.getCoordinate().y);
        handler.endElement(this.pos);
        handler.endElement(this.point);
    }
}

