/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.LineStringEncoder;
import org.geotools.gml3.simple.LinearRingEncoder;
import org.geotools.xml.Encoder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class MultiLineStringEncoder
extends GeometryEncoder<Geometry> {
    static final QualifiedName MULTI_CURVE = new QualifiedName("http://www.opengis.net/gml", "MultiCurve", "gml");
    static final QualifiedName CURVE_MEMBER = new QualifiedName("http://www.opengis.net/gml", "curveMember", "gml");
    LineStringEncoder lse;
    LinearRingEncoder lre;
    CurveEncoder ce;
    QualifiedName multiCurve;
    QualifiedName curveMember;

    protected MultiLineStringEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.lse = new LineStringEncoder(encoder, gmlPrefix);
        this.lre = new LinearRingEncoder(encoder, gmlPrefix);
        this.ce = new CurveEncoder(encoder, gmlPrefix);
        this.multiCurve = MULTI_CURVE.derive(gmlPrefix);
        this.curveMember = CURVE_MEMBER.derive(gmlPrefix);
    }

    public void encode(Geometry geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.multiCurve, (Attributes)atts);
        this.encodeMembers(geometry, handler);
        handler.endElement(this.multiCurve);
    }

    protected void encodeMembers(Geometry geometry, GMLWriter handler) throws SAXException, Exception {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            handler.startElement(this.curveMember, null);
            LineString line = (LineString)geometry.getGeometryN(i);
            if (line instanceof CurvedGeometry) {
                this.ce.encode(line, null, handler);
            } else if (line instanceof LinearRing) {
                this.lre.encode(line, null, handler);
            } else {
                this.lse.encode(line, null, handler);
            }
            handler.endElement(this.curveMember);
        }
    }
}

