/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml2.simple.FeatureCollectionEncoderDelegate;
import org.geotools.gml2.simple.GMLDelegate;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.gml3.simple.CurveEncoder;
import org.geotools.gml3.simple.EnvelopeEncoder;
import org.geotools.gml3.simple.LineStringEncoder;
import org.geotools.gml3.simple.LinearRingEncoder;
import org.geotools.gml3.simple.MultiLineStringEncoder;
import org.geotools.gml3.simple.MultiPointEncoder;
import org.geotools.gml3.simple.MultiPolygonEncoder;
import org.geotools.gml3.simple.PointEncoder;
import org.geotools.gml3.simple.PolygonEncoder;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.XSD;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.AttributesImpl;

public class GML3FeatureCollectionEncoderDelegate
extends FeatureCollectionEncoderDelegate {
    public GML3FeatureCollectionEncoderDelegate(SimpleFeatureCollection features, Encoder encoder) {
        super(features, encoder, (GMLDelegate)new GML3Delegate(encoder));
    }

    static class GML3Delegate
    implements GMLDelegate {
        SrsSyntax srsSyntax;
        static final QualifiedName FEATURE_MEMBERS = new QualifiedName("http://www.opengis.net/gml", GML.featureMembers.getLocalPart(), "gml");
        static final QualifiedName FEATURE_MEMBER = new QualifiedName("http://www.opengis.net/gml", GML.featureMember.getLocalPart(), "gml");
        QualifiedName featureMembers;
        QualifiedName featureMember;
        private String gmlPrefix;
        private int numDecimals;
        private boolean encodeSeparateMember;

        public GML3Delegate(Encoder encoder) {
            this.gmlPrefix = encoder.getNamespaces().getPrefix("http://www.opengis.net/gml");
            this.featureMembers = FEATURE_MEMBERS.derive(this.gmlPrefix);
            this.featureMember = FEATURE_MEMBER.derive(this.gmlPrefix);
            this.srsSyntax = (SrsSyntax)encoder.getContext().getComponentInstanceOfType(SrsSyntax.class);
            this.numDecimals = this.getNumDecimals(encoder.getConfiguration());
            this.encodeSeparateMember = encoder.getConfiguration().hasProperty(GMLConfiguration.ENCODE_FEATURE_MEMBER);
        }

        private int getNumDecimals(Configuration configuration) {
            GMLConfiguration config = configuration instanceof GMLConfiguration ? (GMLConfiguration)configuration : (GMLConfiguration)configuration.getDependency(GMLConfiguration.class);
            if (config == null) {
                return 6;
            }
            return config.getNumDecimals();
        }

        public List getFeatureProperties(SimpleFeature f, XSDElementDeclaration element, Encoder e) {
            return GML3EncodingUtils.INSTANCE.AbstractFeatureTypeGetProperties(f, element, e.getSchemaIndex(), e.getConfiguration());
        }

        public EnvelopeEncoder createEnvelopeEncoder(Encoder e) {
            return new EnvelopeEncoder(e, this.gmlPrefix);
        }

        public void setSrsNameAttribute(AttributesImpl atts, CoordinateReferenceSystem crs) {
            atts.addAttribute(null, "srsName", "srsName", null, GML3EncodingUtils.toURI(crs, this.srsSyntax).toString());
        }

        public void setGeometryDimensionAttribute(AttributesImpl atts, int dimension) {
            atts.addAttribute(null, "srsDimension", "srsDimension", null, String.valueOf(dimension));
        }

        public void initFidAttribute(AttributesImpl atts) {
            atts.addAttribute("http://www.opengis.net/gml", "id", "gml:id", null, "");
        }

        public void startFeatures(GMLWriter handler) throws Exception {
            if (!this.encodeSeparateMember) {
                handler.startElement(this.featureMembers, null);
            }
        }

        public void startFeature(GMLWriter handler) throws Exception {
            if (this.encodeSeparateMember) {
                handler.startElement(this.featureMember, null);
            }
        }

        public void endFeature(GMLWriter handler) throws Exception {
            if (this.encodeSeparateMember) {
                handler.endElement(this.featureMember);
            }
        }

        public void endFeatures(GMLWriter handler) throws Exception {
            if (!this.encodeSeparateMember) {
                handler.endElement(this.featureMembers);
            }
        }

        public void registerGeometryEncoders(Map<Class, GeometryEncoder> encoders, Encoder encoder) {
            encoders.put(Point.class, new PointEncoder(encoder, this.gmlPrefix));
            encoders.put(MultiPoint.class, new MultiPointEncoder(encoder, this.gmlPrefix));
            encoders.put(LineString.class, new LineStringEncoder(encoder, this.gmlPrefix));
            encoders.put(LinearRing.class, new LinearRingEncoder(encoder, this.gmlPrefix));
            encoders.put(MultiLineString.class, new MultiLineStringEncoder(encoder, this.gmlPrefix));
            encoders.put(Polygon.class, new PolygonEncoder(encoder, this.gmlPrefix));
            encoders.put(MultiPolygon.class, new MultiPolygonEncoder(encoder, this.gmlPrefix));
            encoders.put(CircularString.class, new CurveEncoder(encoder, this.gmlPrefix));
            encoders.put(CompoundCurve.class, new CurveEncoder(encoder, this.gmlPrefix));
            encoders.put(CircularRing.class, new CurveEncoder(encoder, this.gmlPrefix));
            encoders.put(CompoundRing.class, new CurveEncoder(encoder, this.gmlPrefix));
        }

        public String getGmlPrefix() throws Exception {
            return this.gmlPrefix;
        }

        public boolean supportsTuples() {
            return false;
        }

        public void startTuple(GMLWriter output) {
        }

        public void endTuple(GMLWriter output) {
        }

        public XSD getSchema() {
            return GML.getInstance();
        }

        public int getNumDecimals() {
            return this.numDecimals;
        }

        public boolean forceDecimalEncoding() {
            return false;
        }
    }
}

