/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.tms;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.io.XMLBuilder;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.layer.meta.LayerMetaInformation;
import org.geowebcache.mime.MimeType;
import org.geowebcache.util.URLMangler;

public class TMSDocumentFactory {
    TileLayerDispatcher tld;
    GridSetBroker gsb;
    String baseUrl;
    private final String contextPath;
    private final URLMangler urlMangler;
    Charset encoding;

    protected TMSDocumentFactory(TileLayerDispatcher tld, GridSetBroker gsb, String baseUrl, String contextPath, URLMangler urlMangler) {
        this(tld, gsb, baseUrl, contextPath, urlMangler, StandardCharsets.UTF_8);
    }

    protected TMSDocumentFactory(TileLayerDispatcher tld, GridSetBroker gsb, String baseUrl, String contextPath, URLMangler urlMangler, Charset encoding) {
        this.tld = tld;
        this.gsb = gsb;
        this.baseUrl = baseUrl;
        this.contextPath = contextPath;
        this.urlMangler = urlMangler;
        this.encoding = encoding;
    }

    protected String getTileMapServiceDoc() {
        StringBuilder str = new StringBuilder();
        XMLBuilder xml = new XMLBuilder((Appendable)str);
        try {
            xml.header("1.0", this.encoding);
            xml.indentElement("TileMapService").attribute("version", "1.0.0").attribute("services", this.urlMangler.buildURL(this.baseUrl, this.contextPath, ""));
            xml.simpleElement("Title", "Tile Map Service", true);
            xml.simpleElement("Abstract", "A Tile Map Service served by GeoWebCache", true);
            xml.indentElement("TileMaps");
            Iterable iter = this.tld.getLayerList();
            for (TileLayer layer : iter) {
                if (!layer.isEnabled() || !layer.isAdvertised()) continue;
                this.tileMapsForLayer(xml, layer);
            }
            xml.endElement();
            xml.endElement();
            return str.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void tileMapsForLayer(XMLBuilder xml, TileLayer layer) throws IOException {
        for (String gridSetId : layer.getGridSubsets()) {
            GridSubset gridSub = layer.getGridSubset(gridSetId);
            for (MimeType mimeType : layer.getMimeTypes()) {
                xml.indentElement("TileMap").attribute("title", this.tileMapTitle(layer)).attribute("srs", gridSub.getSRS().toString()).attribute("profile", this.profileForGridSet(gridSub.getGridSet())).attribute("href", this.tileMapUrl(layer, gridSub, mimeType)).endElement();
            }
        }
    }

    protected String getTileMapDoc(TileLayer layer, GridSubset gridSub, GridSetBroker gsb, MimeType mimeType) {
        StringBuilder str = new StringBuilder();
        XMLBuilder xml = new XMLBuilder((Appendable)str);
        try {
            xml.header("1.0", this.encoding);
            xml.indentElement("TileMap").attribute("version", "1.0.0").attribute("tilemapservice", this.urlMangler.buildURL(this.baseUrl, this.contextPath, "/service/tms/1.0.0"));
            xml.simpleElement("Title", this.tileMapTitle(layer), true);
            xml.simpleElement("Abstract", this.tileMapDescription(layer), true);
            xml.simpleElement("SRS", gridSub.getSRS().toString(), true);
            double[] coords = gridSub.getCoverageBestFitBounds().getCoords();
            xml.boundingBox(null, (Object)coords[0], (Object)coords[1], (Object)coords[2], (Object)coords[3]);
            xml.indentElement("Origin").attribute("x", Double.toString(coords[0])).attribute("y", Double.toString(coords[1])).endElement();
            xml.indentElement("TileFormat").attribute("width", Integer.toString(gridSub.getTileWidth())).attribute("height", Integer.toString(gridSub.getTileHeight())).attribute("mime-type", mimeType.getMimeType()).attribute("extension", mimeType.getFileExtension()).endElement();
            xml.indentElement("TileSets").attribute("profile", this.profileForGridSet(gridSub.getGridSet()));
            double[] resolutions = gridSub.getResolutions();
            int resIdx = 0;
            for (int zoom = gridSub.getZoomStart(); zoom <= gridSub.getZoomStop(); ++zoom) {
                xml.indentElement("TileSet");
                xml.attribute("href", this.tileMapUrl(layer, gridSub, mimeType, zoom));
                xml.attribute("units-per-pixel", Double.toString(resolutions[resIdx]));
                xml.attribute("order", Integer.toString(resIdx));
                xml.endElement();
                ++resIdx;
            }
            xml.endElement();
            xml.endElement();
            return str.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String profileForGridSet(GridSet gridSet) {
        if (gridSet == this.gsb.WORLD_EPSG4326) {
            return "global-geodetic";
        }
        if (gridSet == this.gsb.WORLD_EPSG3857) {
            return "global-mercator";
        }
        return "local";
    }

    private String tileMapUrl(TileLayer tl, GridSubset gridSub, MimeType mimeType) {
        return this.urlMangler.buildURL(this.baseUrl, this.contextPath, "/service/tms/1.0.0/" + this.tileMapName(tl, gridSub, mimeType));
    }

    private String tileMapUrl(TileLayer tl, GridSubset gridSub, MimeType mimeType, int z) {
        return this.tileMapUrl(tl, gridSub, mimeType) + "/" + z;
    }

    private String tileMapName(TileLayer tl, GridSubset gridSub, MimeType mimeType) {
        try {
            String name = URLEncoder.encode(tl.getName(), "UTF-8");
            String gridSubset = URLEncoder.encode(gridSub.getName(), "UTF-8");
            return name + "@" + gridSubset + "@" + mimeType.getFileExtension();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String tileMapTitle(TileLayer tl) {
        LayerMetaInformation metaInfo = tl.getMetaInformation();
        if (metaInfo != null && metaInfo.getTitle() != null) {
            return metaInfo.getTitle();
        }
        return tl.getName();
    }

    private String tileMapDescription(TileLayer tl) {
        LayerMetaInformation metaInfo = tl.getMetaInformation();
        if (metaInfo != null && metaInfo.getDescription() != null) {
            return metaInfo.getDescription();
        }
        return "";
    }
}

