/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.wcs.WCSInfo;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Interpolate;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.coverage.processing.operation.SelectSampleDimension;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.vfny.geoserver.wcs.WcsException;

public class WCSUtils {
    private static final Logger LOGGER = Logging.getLogger(WCSUtils.class);
    public static final String ELEVATION = "ELEVATION";
    public static final Hints LENIENT_HINT = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final Hints hints = new Hints();

    public static GridCoverage2D resample(GridCoverage2D coverage, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, GridGeometry2D gridGeometry, Interpolation interpolation) throws WcsException {
        ParameterValueGroup param = PROCESSOR.getOperation("Resample").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("CoordinateReferenceSystem").setValue((Object)targetCRS);
        param.parameter("GridGeometry").setValue((Object)gridGeometry);
        param.parameter("InterpolationType").setValue((Object)interpolation);
        return (GridCoverage2D)((Resample)PROCESSOR.getOperation("Resample")).doOperation(param, hints);
    }

    public static GridCoverage2D crop(GridCoverage2D coverage, org.opengis.geometry.Envelope bounds) {
        ReferencedEnvelope cropBounds = new ReferencedEnvelope(bounds);
        ReferencedEnvelope coverageBounds = new ReferencedEnvelope(coverage.getEnvelope());
        if (cropBounds.contains((Envelope)coverageBounds)) {
            return coverage;
        }
        Polygon polygon = JTS.toGeometry((ReferencedEnvelope)cropBounds);
        MultiPolygon roi = polygon.getFactory().createMultiPolygon(new Polygon[]{polygon});
        ParameterValueGroup param = PROCESSOR.getOperation("CoverageCrop").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("Envelope").setValue((Object)bounds);
        param.parameter("ROI").setValue((Object)roi);
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }

    public static GridCoverage2D interpolate(GridCoverage2D coverage, Interpolation interpolation) throws WcsException {
        if (interpolation != null) {
            ParameterValueGroup param = PROCESSOR.getOperation("Interpolate").getParameters();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("Type").setValue((Object)interpolation);
            return (GridCoverage2D)((Interpolate)PROCESSOR.getOperation("Interpolate")).doOperation(param, hints);
        }
        return coverage;
    }

    public static Coverage bandSelect(Map params, GridCoverage coverage) throws WcsException {
        int numDimensions = coverage.getNumSampleDimensions();
        HashMap<String, Integer> dims = new HashMap<String, Integer>();
        ArrayList selectedBands = new ArrayList();
        for (int d = 0; d < numDimensions; ++d) {
            dims.put("band" + (d + 1), new Integer(d));
        }
        if (params != null && !params.isEmpty()) {
            for (String param : params.keySet()) {
                if (!param.equalsIgnoreCase("BAND")) continue;
                try {
                    String values = (String)params.get(param);
                    if (values.indexOf("/") > 0) {
                        String[] minMaxRes = values.split("/");
                        int min = (int)Math.round(Double.parseDouble(minMaxRes[0]));
                        int max = (int)Math.round(Double.parseDouble(minMaxRes[1]));
                        double res = minMaxRes.length > 2 ? Double.parseDouble(minMaxRes[2]) : 0.0;
                        for (int v = min; v <= max; ++v) {
                            String key = param.toLowerCase() + v;
                            if (!dims.containsKey(key)) continue;
                            selectedBands.add(dims.get(key));
                        }
                        continue;
                    }
                    String[] bands = values.split(",");
                    for (int v = 0; v < bands.length; ++v) {
                        String key = param.toLowerCase() + bands[v];
                        if (!dims.containsKey(key)) continue;
                        selectedBands.add(dims.get(key));
                    }
                    if (selectedBands.size() != 0) continue;
                    throw new Exception("WRONG PARAM VALUES.");
                }
                catch (Exception e) {
                    throw new WcsException("Band parameters incorrectly specified: " + e.getLocalizedMessage());
                }
            }
        }
        int length = selectedBands.size();
        int[] bands = new int[length];
        for (int b = 0; b < length; ++b) {
            bands[b] = (Integer)selectedBands.get(b);
        }
        return WCSUtils.bandSelect(coverage, bands);
    }

    public static Coverage bandSelect(GridCoverage coverage, int[] bands) {
        GridCoverage bandSelectedCoverage;
        if (bands != null && bands.length > 0) {
            ParameterValueGroup param = PROCESSOR.getOperation("SelectSampleDimension").getParameters();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("SampleDimensions").setValue((Object)bands);
            bandSelectedCoverage = ((SelectSampleDimension)PROCESSOR.getOperation("SelectSampleDimension")).doOperation(param, hints);
        } else {
            bandSelectedCoverage = coverage;
        }
        return bandSelectedCoverage;
    }

    public static void checkOutputLimits(WCSInfo info, GridEnvelope2D gridRange2D, SampleModel sampleModel) {
        long limit = info.getMaxOutputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long actual = WCSUtils.getCoverageSize(gridRange2D, sampleModel);
        if (actual > limit) {
            throw new WcsException("This request is trying to generate too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of bytes to be " + "written in the output is " + WCSUtils.formatBytes(actual));
        }
    }

    public static void checkInputLimits(WCSInfo info, GridCoverage2D coverage) {
        long limit = info.getMaxInputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long actual = WCSUtils.getCoverageSize(coverage.getGridGeometry().getGridRange2D(), coverage.getRenderedImage().getSampleModel());
        if (actual > limit) {
            throw new WcsException("This request is trying to read too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of " + "bytes to be read is " + WCSUtils.formatBytes(actual));
        }
    }

    static long getCoverageSize(GridEnvelope2D envelope, SampleModel sm) {
        long pixelsNumber = WCSUtils.computePixelsNumber(envelope);
        long pixelSize = 0L;
        int numBands = sm.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            pixelSize += (long)sm.getSampleSize(i);
        }
        return pixelsNumber * pixelSize / 8L;
    }

    public static void checkInputLimits(WCSInfo info, CoverageInfo meta, GridCoverage2DReader reader, GridGeometry2D gridGeometry) throws WcsException {
        long limit = info.getMaxInputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long actual = 0L;
        try {
            GeneralEnvelope requestedEnvelope = new GeneralEnvelope(gridGeometry.getEnvelope());
            CoordinateReferenceSystem requestCRS = requestedEnvelope.getCoordinateReferenceSystem();
            CoordinateReferenceSystem nativeCRS = reader.getCoordinateReferenceSystem();
            if (!CRS.equalsIgnoreMetadata((Object)requestCRS, (Object)nativeCRS)) {
                requestedEnvelope = CRS.transform((org.opengis.geometry.Envelope)requestedEnvelope, (CoordinateReferenceSystem)nativeCRS);
            }
            requestedEnvelope.intersect((org.opengis.geometry.Envelope)reader.getOriginalEnvelope());
            if (!requestedEnvelope.isEmpty()) {
                MathTransform crsToGrid = meta.getGrid().getGridToCRS().inverse();
                GeneralEnvelope requestedGrid = CRS.transform((MathTransform)crsToGrid, (org.opengis.geometry.Envelope)requestedEnvelope);
                double[] spans = new double[requestedGrid.getDimension()];
                double[] resolutions = new double[requestedGrid.getDimension()];
                for (int i = 0; i < spans.length; ++i) {
                    spans[i] = requestedGrid.getSpan(i);
                    resolutions[i] = requestedEnvelope.getSpan(i) / spans[i];
                }
                OverviewPolicy policy = info.getOverviewPolicy();
                double[] readResoutions = reader.getReadingResolutions(policy, resolutions);
                double[] baseResolutions = reader.getReadingResolutions(OverviewPolicy.IGNORE, resolutions);
                for (int i = 0; i < spans.length; ++i) {
                    int n = i;
                    spans[n] = spans[n] * (readResoutions[i] / baseResolutions[i]);
                }
                long pixels = 1L;
                for (int i = 0; i < requestedGrid.getDimension(); ++i) {
                    pixels = (long)((double)pixels * Math.ceil(requestedGrid.getSpan(i)));
                }
                long pixelSize = 0L;
                if (meta.getDimensions() != null) {
                    for (CoverageDimensionInfo dimension : meta.getDimensions()) {
                        int size = WCSUtils.guessSizeFromRange(dimension.getRange());
                        if (size == 0) {
                            LOGGER.log(Level.INFO, "Failed to guess the size of dimension " + dimension.getName() + ", skipping the pre-read check");
                            pixelSize = -1L;
                            break;
                        }
                        pixelSize += (long)size;
                    }
                }
                actual = pixels * pixelSize / 8L;
            }
        }
        catch (Throwable t) {
            throw new WcsException("An error occurred while checking serving limits", t);
        }
        if (actual < 0L) {
            LOGGER.log(Level.INFO, "Warning, we could not estimate the amount of bytes to be read from the coverage source for the current request");
        }
        if (actual > limit) {
            throw new WcsException("This request is trying to read too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of bytes " + "to be read is " + WCSUtils.formatBytes(actual));
        }
    }

    static int guessSizeFromRange(NumberRange range) {
        double min = range.getMinimum();
        double max = range.getMaximum();
        double diff = max - min;
        if (diff <= 255.0) {
            return 8;
        }
        if (diff <= 65535.0) {
            return 16;
        }
        if (diff <= 4.294967295E9) {
            return 32;
        }
        if (diff <= 3.4028234663852886E38) {
            return 32;
        }
        return 64;
    }

    static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        if (bytes < 0x100000L) {
            return new DecimalFormat("#.##").format((double)bytes / 1024.0) + "KB";
        }
        return new DecimalFormat("#.##").format((double)bytes / 1024.0 / 1024.0) + "MB";
    }

    public static Hints getReaderHints(WCSInfo wcs) {
        Hints hints = new Hints();
        hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        if (wcs.getOverviewPolicy() == null) {
            hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)OverviewPolicy.IGNORE));
        } else {
            hints.add((RenderingHints)new Hints((RenderingHints.Key)Hints.OVERVIEW_POLICY, (Object)wcs.getOverviewPolicy()));
        }
        hints.put((Object)Hints.DECIMATION_POLICY, (Object)(wcs.isSubsamplingEnabled() ? DecimationPolicy.ALLOW : DecimationPolicy.DISALLOW));
        return hints;
    }

    public static Filter getRequestFilter() {
        List list;
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return null;
        }
        Object filter = request.getKvp().get("FILTER");
        if (!(filter instanceof Filter) && (filter = request.getKvp().get("CQL_FILTER")) instanceof List && (list = (List)filter).size() > 0) {
            filter = list.get(0);
        }
        if (!(filter instanceof Filter)) {
            filter = request.getKvp().get("FEATURE_ID");
        }
        if (filter instanceof Filter) {
            return (Filter)filter;
        }
        return null;
    }

    public static void checkOutputLimits(WCSInfo wcs, GridCoverage2D gc, int[] indexes) {
        long limit = wcs.getMaxOutputMemory() * 1024L;
        if (limit <= 0L) {
            return;
        }
        long pixelsNumber = WCSUtils.computePixelsNumber(gc.getGridGeometry().getGridRange2D());
        long pixelSize = 0L;
        RenderedImage image = gc.getRenderedImage();
        SampleModel sm = image.getSampleModel();
        for (int band : indexes) {
            pixelSize += (long)sm.getSampleSize(band);
        }
        long actual = pixelsNumber * pixelSize / 8L;
        if (actual > limit) {
            throw new WcsException("This request is trying to generate too much data, the limit is " + WCSUtils.formatBytes(limit) + " but the actual amount of bytes to be " + "written in the output is " + WCSUtils.formatBytes(actual));
        }
    }

    private static long computePixelsNumber(GridEnvelope2D rasterEnvelope) {
        long pixelsNumber = 1L;
        int dimensions = rasterEnvelope.getDimension();
        for (int i = 0; i < dimensions; ++i) {
            pixelsNumber *= (long)rasterEnvelope.getSpan(i);
        }
        return pixelsNumber;
    }

    public static <T> GeneralParameterValue[] replaceParameter(GeneralParameterValue[] readParameters, Object value, ParameterDescriptor<T> pd) {
        for (GeneralParameterValue gpv : readParameters) {
            if (!gpv.getDescriptor().getName().equals(pd.getName())) continue;
            ((ParameterValue)gpv).setValue(value);
            return readParameters;
        }
        GeneralParameterValue[] readParametersClone = new GeneralParameterValue[readParameters.length + 1];
        System.arraycopy(readParameters, 0, readParametersClone, 0, readParameters.length);
        ParameterValue pv = pd.createValue();
        pv.setValue(value);
        readParametersClone[readParameters.length] = pv;
        return readParametersClone;
    }
}

