/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import it.geosolutions.imageio.plugins.tiff.TIFFCompressor;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFLZWCompressor;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.responses.BaseCoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.vfny.geoserver.wcs.WcsException;

public class GeoTIFFCoverageResponseDelegate
extends BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    private static final Logger LOGGER = Logging.getLogger((String)GeoTIFFCoverageResponseDelegate.class.toString());
    private static final float DEFAULT_JPEG_COMPRESSION_QUALITY = 0.75f;
    private static final GeoTiffFormat GEOTIF_FORMAT = new GeoTiffFormat();
    public static final String GEOTIFF_CONTENT_TYPE = "image/tiff";

    public GeoTIFFCoverageResponseDelegate(GeoServer geoserver) {
        super(geoserver, Arrays.asList("tif", "tiff", "geotiff", "TIFF", "GEOTIFF", "GeoTIFF", "image/geotiff"), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("tiff", "tif");
                this.put("tiff", "tif");
                this.put("geotiff", "tif");
                this.put("TIFF", "tif");
                this.put("GEOTIFF", "tif");
                this.put("GeoTIFF", "tif");
                this.put("image/geotiff", "tif");
                this.put(GeoTIFFCoverageResponseDelegate.GEOTIFF_CONTENT_TYPE, "tif");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("tiff", GeoTIFFCoverageResponseDelegate.GEOTIFF_CONTENT_TYPE);
                this.put("tif", GeoTIFFCoverageResponseDelegate.GEOTIFF_CONTENT_TYPE);
                this.put("geotiff", GeoTIFFCoverageResponseDelegate.GEOTIFF_CONTENT_TYPE);
                this.put("TIFF", GeoTIFFCoverageResponseDelegate.GEOTIFF_CONTENT_TYPE);
                this.put("GEOTIFF", GeoTIFFCoverageResponseDelegate.GEOTIFF_CONTENT_TYPE);
                this.put("GeoTIFF", GeoTIFFCoverageResponseDelegate.GEOTIFF_CONTENT_TYPE);
                this.put("image/geotiff", GeoTIFFCoverageResponseDelegate.GEOTIFF_CONTENT_TYPE);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(GridCoverage2D sourceCoverage, String outputFormat, Map<String, String> econdingParameters, OutputStream output) throws IOException {
        Utilities.ensureNonNull((String)"sourceCoverage", (Object)sourceCoverage);
        Utilities.ensureNonNull((String)"econdingParameters", econdingParameters);
        GeoTiffWriteParams wp = new GeoTiffWriteParams();
        this.handleCompression(econdingParameters, wp);
        this.handleTiling(econdingParameters, wp, sourceCoverage);
        this.handleInterleaving(econdingParameters, wp, sourceCoverage);
        ParameterValueGroup writerParams = GEOTIF_FORMAT.getWriteParameters();
        writerParams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)wp);
        if (((WCSInfo)this.geoserver.getService(WCSInfo.class)).isLatLon()) {
            writerParams.parameter(GeoTiffFormat.RETAIN_AXES_ORDER.getName().toString()).setValue(true);
        }
        GeoTiffWriter writer = (GeoTiffWriter)GEOTIF_FORMAT.getWriter((Object)output);
        try {
            if (writer != null) {
                writer.write((GridCoverage)sourceCoverage, writerParams.values().toArray(new GeneralParameterValue[1]));
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.dispose();
                }
            }
            catch (Throwable e) {}
            sourceCoverage.dispose(false);
        }
    }

    private void handleInterleaving(Map<String, String> encondingParameters, GeoTiffWriteParams wp, GridCoverage2D sourceCoverage) throws WcsException {
        String interleavingS;
        if (encondingParameters.containsKey("interleave") && !(interleavingS = encondingParameters.get("interleave")).equals("pixel")) {
            if (interleavingS.equals("band")) {
                throw new OWS20Exception("Banded Interleaving not supported", this.ows20Code(WcsException.WcsExceptionCode.InterleavingNotSupported), interleavingS);
            }
            throw new OWS20Exception("Invalid Interleaving type provided", this.ows20Code(WcsException.WcsExceptionCode.InterleavingInvalid), interleavingS);
        }
    }

    private OWS20Exception.OWSExceptionCode ows20Code(WcsException.WcsExceptionCode code) {
        return new OWS20Exception.OWSExceptionCode(code.toString(), Integer.valueOf(404));
    }

    private void handleTiling(Map<String, String> econdingParameters, GeoTiffWriteParams wp, GridCoverage2D sourceCoverage) throws WcsException {
        String tilingS;
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        SampleModel sampleModel = sourceImage.getSampleModel();
        int sourceTileW = sampleModel.getWidth();
        int sourceTileH = sampleModel.getHeight();
        Dimension tileDimensions = new Dimension(sourceTileW, sourceTileH);
        LOGGER.fine("Source tiling:" + tileDimensions.width + "x" + tileDimensions.height);
        GridEnvelope gr = sourceCoverage.getGridGeometry().getGridRange();
        if (gr.getSpan(0) < tileDimensions.width) {
            tileDimensions.width = gr.getSpan(0);
        }
        if (gr.getSpan(1) < tileDimensions.height) {
            tileDimensions.height = gr.getSpan(1);
        }
        LOGGER.fine("Source tiling reviewed to save space:" + tileDimensions.width + "x" + tileDimensions.height);
        if (econdingParameters.containsKey("tiling") && (tilingS = econdingParameters.get("tiling")) != null && Boolean.valueOf(tilingS).booleanValue()) {
            String tileH_;
            String tileW_;
            if (econdingParameters.containsKey("tilewidth") && (tileW_ = econdingParameters.get("tilewidth")) != null) {
                try {
                    int tileW = Integer.valueOf(tileW_);
                    if (tileW <= 0 || tileW % 16 != 0) {
                        throw new OWS20Exception("Provided tile width is invalid", this.ows20Code(WcsException.WcsExceptionCode.TilingInvalid), Integer.toString(tileW));
                    }
                    tileDimensions.width = tileW;
                }
                catch (Exception e) {
                    throw new OWS20Exception("Provided tile width is invalid", this.ows20Code(WcsException.WcsExceptionCode.TilingInvalid), tileW_);
                }
            }
            if (econdingParameters.containsKey("tileheight") && (tileH_ = econdingParameters.get("tileheight")) != null) {
                try {
                    int tileH = Integer.valueOf(tileH_);
                    if (tileH <= 0 || tileH % 16 != 0) {
                        throw new OWS20Exception("Provided tile height is invalid", this.ows20Code(WcsException.WcsExceptionCode.TilingInvalid), Integer.toString(tileH));
                    }
                    tileDimensions.height = tileH;
                }
                catch (Exception e) {
                    throw new OWS20Exception("Provided tile height is invalid", this.ows20Code(WcsException.WcsExceptionCode.TilingInvalid), tileH_);
                }
            }
        }
        if (tileDimensions.width != sourceTileW || tileDimensions.height != sourceTileH) {
            LOGGER.fine("Final tiling:" + tileDimensions.width + "x" + tileDimensions.height);
            wp.setTilingMode(2);
            wp.setTiling(tileDimensions.width, tileDimensions.height);
        } else {
            LOGGER.fine("Mantaining original tiling");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleCompression(Map<String, String> econdingParameters, GeoTiffWriteParams wp) throws WcsException {
        if (!econdingParameters.containsKey("compression")) return;
        String compressionS = econdingParameters.get("compression");
        if (compressionS == null) return;
        if (compressionS.equalsIgnoreCase("none")) return;
        if (compressionS.equals("LZW")) {
            wp.setCompressionMode(2);
            wp.setCompressionType("LZW");
            String predictorS = econdingParameters.get("predictor");
            if (predictorS == null) return;
            if (predictorS.equals("None")) {
                return;
            }
            if (predictorS.equals("Horizontal")) {
                wp.setTIFFCompressor((TIFFCompressor)new TIFFLZWCompressor(2));
                return;
            }
            if (!predictorS.equals("Floatingpoint")) throw new OWS20Exception("Invalid Predictor provided", this.ows20Code(WcsException.WcsExceptionCode.PredictorInvalid), predictorS);
            throw new OWS20Exception("Floating Point predictor is not supported", this.ows20Code(WcsException.WcsExceptionCode.PredictorNotSupported), predictorS);
        }
        if (compressionS.equals("JPEG")) {
            wp.setCompressionMode(2);
            wp.setCompressionType("JPEG");
            wp.setCompressionQuality(0.75f);
            if (!econdingParameters.containsKey("jpeg_quality")) return;
            String quality_ = econdingParameters.get("jpeg_quality");
            if (quality_ == null) return;
            try {
                int quality = Integer.valueOf(quality_);
                if (quality <= 0) throw new OWS20Exception("Provided quality value for the jpeg compression in invalid", this.ows20Code(WcsException.WcsExceptionCode.JpegQualityInvalid), quality_);
                if (quality > 100) throw new OWS20Exception("Provided quality value for the jpeg compression in invalid", this.ows20Code(WcsException.WcsExceptionCode.JpegQualityInvalid), quality_);
                wp.setCompressionQuality((float)quality / 100.0f);
                return;
            }
            catch (Exception e) {
                throw new OWS20Exception("Provided quality value for the jpeg compression in invalid", this.ows20Code(WcsException.WcsExceptionCode.JpegQualityInvalid), quality_);
            }
        }
        if (compressionS.equals("PackBits")) {
            wp.setCompressionMode(2);
            wp.setCompressionType("PackBits");
            return;
        }
        if (compressionS.equals("DEFLATE")) {
            wp.setCompressionMode(2);
            wp.setCompressionType("Deflate");
            return;
        }
        if (!compressionS.equals("Huffman")) throw new OWS20Exception("Provided compression does not seem supported", this.ows20Code(WcsException.WcsExceptionCode.CompressionInvalid), compressionS);
        wp.setCompressionMode(2);
        wp.setCompressionType("CCITT RLE");
    }

    @Override
    public String getConformanceClass(String format) {
        return "http://www.opengis.net/spec/GMLCOV_geotiff-coverages/1.0/conf/geotiff-coverage";
    }
}

