/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.responses.BaseCoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.gtopo30.GTopo30Writer;
import org.opengis.coverage.grid.GridCoverage;

public class GTopo30CoverageResponseDelegate
extends BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    public GTopo30CoverageResponseDelegate(GeoServer geoserver) {
        super(geoserver, Arrays.asList("GTopo30"), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("GTopo30", "zip");
                this.put("application/gtopo30", "zip");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("GTopo30", "application/gtopo30");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(GridCoverage2D sourceCoverage, String outputFormat, Map<String, String> econdingParameters, OutputStream output) throws ServiceException, IOException {
        ZipOutputStream outZ = new ZipOutputStream(output);
        output = outZ;
        GTopo30Writer writer = new GTopo30Writer((Object)outZ);
        try {
            writer.write((GridCoverage)sourceCoverage, null);
        }
        finally {
            try {
                writer.dispose();
            }
            catch (Throwable e) {}
            sourceCoverage.dispose(false);
        }
    }
}

