/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.responses;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.responses.BaseCoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.gce.arcgrid.ArcGridWriter;
import org.opengis.coverage.grid.GridCoverage;

public class AscCoverageResponseDelegate
extends BaseCoverageResponseDelegate
implements CoverageResponseDelegate {
    public AscCoverageResponseDelegate(GeoServer geoserver) {
        super(geoserver, Arrays.asList("ArcGrid", "ArcGrid-GZIP"), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("ArcGrid", "asc");
                this.put("ArcGrid-GZIP", "asc.gz");
                this.put("text/plain", "asc");
                this.put("application/x-gzip", "ArcGrid-GZIP");
            }
        }, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("ArcGrid", "text/plain");
                this.put("ArcGrid-GZIP", "application/x-gzip");
            }
        });
    }

    private boolean isOutputCompressed(String outputFormat) {
        return "ArcGrid-GZIP".equalsIgnoreCase(outputFormat) || "application/arcgrid;gzipped=\"true\"".equals(outputFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(GridCoverage2D sourceCoverage, String outputFormat, Map<String, String> econdingParameters, OutputStream output) throws ServiceException, IOException {
        if (sourceCoverage == null) {
            throw new IllegalStateException(new StringBuffer("It seems prepare() has not been called").append(" or has not succeed").toString());
        }
        GZIPOutputStream gzipOut = null;
        if (this.isOutputCompressed(outputFormat)) {
            gzipOut = new GZIPOutputStream(output);
            output = gzipOut;
        }
        ArcGridWriter writer = null;
        try {
            writer = new ArcGridWriter((Object)output);
            writer.write((GridCoverage)sourceCoverage, null);
            if (gzipOut != null) {
                gzipOut.finish();
                gzipOut.flush();
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.dispose();
                }
            }
            catch (Throwable e) {}
            if (gzipOut != null) {
                IOUtils.closeQuietly((OutputStream)gzipOut);
            }
            sourceCoverage.dispose(true);
        }
    }
}

