/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PlanarImage;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.platform.Operation;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;

public class CoverageCleanerCallback
extends AbstractDispatcherCallback {
    static final Logger LOGGER = Logging.getLogger(CoverageCleanerCallback.class);
    static final ThreadLocal<List<GridCoverage>> COVERAGES = new ThreadLocal();

    public Object operationExecuted(Request request, Operation operation, Object result) {
        if (result instanceof GridCoverage) {
            CoverageCleanerCallback.addCoverages((GridCoverage)result);
        } else if (result instanceof GridCoverage[]) {
            CoverageCleanerCallback.addCoverages((GridCoverage[])result);
        }
        return result;
    }

    public void finished(Request request) {
        this.clean();
    }

    public static void addCoverages(GridCoverage ... coverages) {
        List<GridCoverage> list = COVERAGES.get();
        if (list == null) {
            list = new ArrayList<GridCoverage>();
            COVERAGES.set(list);
        }
        list.addAll(Arrays.asList(coverages));
    }

    public static void disposeCoverage(GridCoverage coverage) {
        RenderedImage ri = coverage.getRenderedImage();
        if (coverage instanceof GridCoverage2D) {
            ((GridCoverage2D)coverage).dispose(true);
        }
        if (ri instanceof PlanarImage) {
            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        try {
            List<GridCoverage> coverages = COVERAGES.get();
            if (coverages != null) {
                for (GridCoverage coverage : coverages) {
                    try {
                        CoverageCleanerCallback.disposeCoverage(coverage);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to fully dispose coverage: " + coverage, e);
                    }
                }
            }
        }
        finally {
            COVERAGES.remove();
        }
    }
}

