/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.gmaps;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.Service;
import org.geowebcache.service.ServiceException;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.ServletUtils;

public class GMapsConverter
extends Service {
    public static final String SERVICE_GMAPS = "gmaps";
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private GridSetBroker gsb;

    protected GMapsConverter() {
        super(SERVICE_GMAPS);
    }

    public GMapsConverter(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb) {
        super(SERVICE_GMAPS);
        this.sb = sb;
        this.tld = tld;
        this.gsb = gsb;
    }

    public ConveyorTile getConveyor(HttpServletRequest request, HttpServletResponse response) throws ServiceException, GeoWebCacheException {
        String layerId = super.getLayersParameter(request);
        String encoding = request.getCharacterEncoding();
        Map params = request.getParameterMap();
        String strFormat = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"format");
        String strZoom = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"zoom");
        String strX = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"x");
        String strY = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"y");
        String strCached = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"cached");
        String strMetaTiled = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"metatiled");
        long[] gridLoc = GMapsConverter.convert(Integer.parseInt(strZoom), Integer.parseInt(strX), Integer.parseInt(strY));
        String layers = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"layers");
        if (layers == null || layers.length() == 0) {
            layers = ServletUtils.stringFromMap((Map)params, (String)encoding, (String)"layer");
        }
        TileLayer tileLayer = this.tld.getTileLayer(layers);
        Map filteringParameters = tileLayer.getModifiableParameters(params, encoding);
        MimeType mimeType = null;
        try {
            if (strFormat == null) {
                strFormat = "image/png";
            }
            mimeType = MimeType.createFromFormat((String)strFormat);
        }
        catch (MimeException me) {
            throw new ServiceException("Unable to determine requested format, " + strFormat);
        }
        ConveyorTile ret = new ConveyorTile(this.sb, layerId, this.gsb.WORLD_EPSG3857.getName(), gridLoc, mimeType, filteringParameters, request, response);
        if (strCached != null && !Boolean.parseBoolean(strCached)) {
            ret.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            if (strMetaTiled != null && !Boolean.parseBoolean(strMetaTiled)) {
                ret.setHint("not_cached,not_metatiled");
            } else {
                ret.setHint("not_cached");
            }
        }
        return ret;
    }

    public void handleRequest(ConveyorTile tile) throws GeoWebCacheException {
        if (tile.getHint() != null) {
            if (!tile.getHint().equals("not_cached,not_metatiled") && !tile.getHint().equals("not_cached")) {
                throw new GeoWebCacheException("Hint " + tile.getHint() + " is not known.");
            }
            TileLayer tl = this.tld.getTileLayer(tile.getLayerId());
            if (tl == null) {
                throw new GeoWebCacheException("Unknown layer " + tile.getLayerId());
            }
            if (!tl.isCacheBypassAllowed().booleanValue()) {
                throw new GeoWebCacheException("Layer " + tile.getLayerId() + " is not configured to allow bypassing the cache.");
            }
            tile.setTileLayer(tl);
            tl.getNoncachedTile(tile);
            Service.writeTileResponse((ConveyorTile)tile, (boolean)false);
        }
    }

    public static long[] convert(long zoomLevel, long x, long y) throws ServiceException {
        long extent = (long)Math.pow(2.0, zoomLevel);
        if (x < 0L || x > extent - 1L) {
            throw new ServiceException("The X coordinate is not sane: " + x);
        }
        if (y < 0L || y > extent - 1L) {
            throw new ServiceException("The Y coordinate is not sane: " + y);
        }
        long[] gridLoc = new long[]{x, extent - y - 1L, zoomLevel};
        return gridLoc;
    }
}

