/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.RasterByteABGRProvider;
import it.geosolutions.imageio.plugins.png.RasterByteGrayAlphaProvider;
import it.geosolutions.imageio.plugins.png.RasterByteRepackSingleBandProvider;
import it.geosolutions.imageio.plugins.png.RasterByteSingleBandProvider;
import it.geosolutions.imageio.plugins.png.RasterIntABGRProvider;
import it.geosolutions.imageio.plugins.png.RasterShortABGRProvider;
import it.geosolutions.imageio.plugins.png.RasterShortGrayAlphaProvider;
import it.geosolutions.imageio.plugins.png.RasterShortSingleBandProvider;
import it.geosolutions.imageio.plugins.png.ScanlineProvider;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;

public class ScanlineProviderFactory {
    public static ScanlineProvider getProvider(RenderedImage image) {
        Raster raster;
        ColorModel cm = image.getColorModel();
        SampleModel sm = image.getSampleModel();
        if (image instanceof BufferedImage) {
            raster = ((BufferedImage)image).getRaster();
            if (raster.getParent() != null) {
                raster = image.getData(new Rectangle(0, 0, raster.getWidth(), raster.getHeight()));
            }
        } else {
            raster = image.getData();
        }
        if (cm instanceof ComponentColorModel && sm.getDataType() == 0) {
            if (sm.getNumBands() == 3 || sm.getNumBands() == 4) {
                return new RasterByteABGRProvider(raster, cm.hasAlpha());
            }
            if (sm.getNumBands() == 2 && cm.hasAlpha()) {
                return new RasterByteGrayAlphaProvider(raster);
            }
            if (sm.getNumBands() == 1 && sm.getDataType() == 0) {
                if (sm instanceof MultiPixelPackedSampleModel) {
                    if (cm.getPixelSize() == 8) {
                        return new RasterByteSingleBandProvider(raster, 8, raster.getWidth());
                    }
                    if (cm.getPixelSize() == 4) {
                        int scanlineLength = (raster.getWidth() + 1) / 2;
                        return new RasterByteSingleBandProvider(raster, 4, scanlineLength);
                    }
                    if (cm.getPixelSize() == 2) {
                        int scanlineLength = (raster.getWidth() + 2) / 4;
                        return new RasterByteSingleBandProvider(raster, 2, scanlineLength);
                    }
                    if (cm.getPixelSize() == 1) {
                        int scanlineLength = (raster.getWidth() + 4) / 8;
                        return new RasterByteSingleBandProvider(raster, 1, scanlineLength);
                    }
                } else {
                    if (cm.getPixelSize() == 8) {
                        return new RasterByteSingleBandProvider(raster, 8, raster.getWidth());
                    }
                    if (cm.getPixelSize() == 4) {
                        int scanlineLength = (raster.getWidth() + 1) / 2;
                        return new RasterByteRepackSingleBandProvider(raster, 4, scanlineLength);
                    }
                    if (cm.getPixelSize() == 2) {
                        int scanlineLength = (raster.getWidth() + 2) / 4;
                        return new RasterByteRepackSingleBandProvider(raster, 2, scanlineLength);
                    }
                    if (cm.getPixelSize() == 1) {
                        int scanlineLength = (raster.getWidth() + 4) / 8;
                        return new RasterByteRepackSingleBandProvider(raster, 1, scanlineLength);
                    }
                }
            }
        } else if (cm instanceof ComponentColorModel && sm.getDataType() == 1) {
            if (sm.getNumBands() == 3 || sm.getNumBands() == 4) {
                return new RasterShortABGRProvider(raster, cm.hasAlpha());
            }
            if (sm.getNumBands() == 2 && cm.hasAlpha()) {
                return new RasterShortGrayAlphaProvider(raster);
            }
            if (sm.getNumBands() == 1) {
                return new RasterShortSingleBandProvider(raster);
            }
        } else if (cm instanceof DirectColorModel && sm.getDataType() == 3) {
            if (sm.getNumBands() == 3 || sm.getNumBands() == 4) {
                return new RasterIntABGRProvider(raster, cm.hasAlpha());
            }
        } else if (cm instanceof IndexColorModel) {
            int scanlineLength;
            IndexColorModel icm = (IndexColorModel)cm;
            int pixelSize = icm.getPixelSize();
            if ((pixelSize & pixelSize - 1) != 0) {
                int nextPower = (int)(Math.floor(Math.log(pixelSize) / Math.log(2.0)) + 1.0);
                pixelSize = (int)Math.pow(2.0, nextPower);
            }
            if (sm.getDataType() == 0) {
                if (sm instanceof MultiPixelPackedSampleModel) {
                    if (pixelSize == 8) {
                        return new RasterByteSingleBandProvider(raster, 8, raster.getWidth(), icm);
                    }
                    if (pixelSize == 4) {
                        scanlineLength = (raster.getWidth() + 1) / 2;
                        return new RasterByteSingleBandProvider(raster, 4, scanlineLength, icm);
                    }
                    if (pixelSize == 2) {
                        scanlineLength = (raster.getWidth() + 2) / 4;
                        return new RasterByteSingleBandProvider(raster, 2, scanlineLength, icm);
                    }
                    if (pixelSize == 1) {
                        scanlineLength = (raster.getWidth() + 4) / 8;
                        return new RasterByteSingleBandProvider(raster, 1, scanlineLength, icm);
                    }
                } else {
                    if (pixelSize == 8) {
                        return new RasterByteSingleBandProvider(raster, 8, raster.getWidth(), icm);
                    }
                    if (pixelSize == 4) {
                        scanlineLength = (raster.getWidth() + 1) / 2;
                        return new RasterByteRepackSingleBandProvider(raster, 4, scanlineLength, icm);
                    }
                    if (pixelSize == 2) {
                        scanlineLength = (raster.getWidth() + 2) / 4;
                        return new RasterByteRepackSingleBandProvider(raster, 2, scanlineLength, icm);
                    }
                    if (pixelSize == 1) {
                        scanlineLength = (raster.getWidth() + 4) / 8;
                        return new RasterByteRepackSingleBandProvider(raster, 1, scanlineLength, icm);
                    }
                }
            } else if (sm.getDataType() == 1 && sm instanceof MultiPixelPackedSampleModel) {
                if (pixelSize == 16) {
                    scanlineLength = raster.getWidth() * 2;
                    return new RasterShortSingleBandProvider(raster, 16, scanlineLength, icm);
                }
                if (pixelSize == 8) {
                    scanlineLength = raster.getWidth() + (raster.getWidth() % 2 == 0 ? 0 : 1);
                    return new RasterShortSingleBandProvider(raster, 8, scanlineLength, icm);
                }
                if (pixelSize == 4) {
                    scanlineLength = (raster.getWidth() + 1) / 2;
                    return new RasterShortSingleBandProvider(raster, 4, scanlineLength, icm);
                }
                if (pixelSize == 2) {
                    scanlineLength = (raster.getWidth() + 2) / 4;
                    return new RasterShortSingleBandProvider(raster, 2, scanlineLength, icm);
                }
                if (pixelSize == 1) {
                    scanlineLength = (raster.getWidth() + 4) / 8;
                    return new RasterShortSingleBandProvider(raster, 1, scanlineLength, icm);
                }
            }
        }
        return null;
    }
}

