/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;

public final class RasterByteGrayAlphaProvider
extends AbstractScanlineProvider {
    final byte[] bytes;
    boolean alphaFirst;

    public RasterByteGrayAlphaProvider(Raster raster) {
        super(raster, 8, raster.getWidth() * 2);
        this.bytes = ((DataBufferByte)raster.getDataBuffer()).getData();
        int[] bandOffsets = ((ComponentSampleModel)raster.getSampleModel()).getBandOffsets();
        this.alphaFirst = bandOffsets[0] != 0;
    }

    public void next(byte[] row, int offset, int length) {
        int bytesIdx = this.cursor.next();
        if (this.alphaFirst) {
            int i = offset;
            int max = offset + length;
            while (i < max) {
                byte a = this.bytes[bytesIdx++];
                byte g = this.bytes[bytesIdx++];
                row[i++] = g;
                row[i++] = a;
            }
        } else {
            System.arraycopy(this.bytes, bytesIdx, row, offset, length);
        }
    }
}

