/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;

public final class RasterByteABGRProvider
extends AbstractScanlineProvider {
    final byte[] bytes;
    final boolean bgrOrder;
    final boolean hasAlpha;

    public RasterByteABGRProvider(Raster raster, boolean hasAlpha) {
        super(raster, 8, raster.getWidth() * (hasAlpha ? 4 : 3));
        this.hasAlpha = hasAlpha;
        this.bytes = ((DataBufferByte)raster.getDataBuffer()).getData();
        ComponentSampleModel sm = (ComponentSampleModel)raster.getSampleModel();
        this.bgrOrder = sm.getBandOffsets()[0] != 0;
    }

    public void next(byte[] row, int offset, int length) {
        int bytesIdx = this.cursor.next();
        int i = offset;
        int max = offset + length;
        if (!this.bgrOrder) {
            System.arraycopy(this.bytes, bytesIdx, row, offset, length);
        } else if (this.hasAlpha) {
            while (i < max) {
                byte a = this.bytes[bytesIdx++];
                byte b = this.bytes[bytesIdx++];
                byte g = this.bytes[bytesIdx++];
                byte r = this.bytes[bytesIdx++];
                row[i++] = r;
                row[i++] = g;
                row[i++] = b;
                row[i++] = a;
            }
        } else {
            while (i < max) {
                byte b = this.bytes[bytesIdx++];
                byte g = this.bytes[bytesIdx++];
                byte r = this.bytes[bytesIdx++];
                row[i++] = r;
                row[i++] = g;
                row[i++] = b;
            }
        }
    }
}

