/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngWriter;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkTRNS;
import it.geosolutions.imageio.plugins.png.ScanlineProvider;
import it.geosolutions.imageio.plugins.png.ScanlineProviderFactory;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PNGWriter {
    private static final Logger LOGGER = Logger.getAnonymousLogger();

    public RenderedImage writePNG(RenderedImage image, OutputStream outStream, float quality, FilterType filterType) throws Exception {
        int level = Math.round(9.0f * (1.0f - quality));
        RenderedImage original = image;
        ScanlineProvider scanlines = ScanlineProviderFactory.getProvider(image);
        if (scanlines == null) {
            throw new IllegalArgumentException("Could not find a scanline extractor for " + original);
        }
        ColorModel colorModel = image.getColorModel();
        boolean indexed = colorModel instanceof IndexColorModel;
        ImageInfo ii = this.getImageInfo(image, scanlines, colorModel, indexed);
        PngWriter pw = new PngWriter(outStream, ii);
        pw.setShouldCloseStream(false);
        try {
            pw.setCompLevel(level);
            pw.setFilterType(filterType);
            if (indexed) {
                IndexColorModel icm = (IndexColorModel)colorModel;
                PngChunkPLTE palette = pw.getMetadata().createPLTEChunk();
                int ncolors = icm.getMapSize();
                palette.setNentries(ncolors);
                for (int i = 0; i < ncolors; ++i) {
                    int red = icm.getRed(i);
                    int green = icm.getGreen(i);
                    int blue = icm.getBlue(i);
                    palette.setEntry(i, red, green, blue);
                }
                if (icm.hasAlpha()) {
                    PngChunkTRNS transparent = new PngChunkTRNS(ii);
                    int[] alpha = new int[ncolors];
                    for (int i = 0; i < ncolors; ++i) {
                        int a;
                        alpha[i] = a = icm.getAlpha(i);
                    }
                    transparent.setPalletteAlpha(alpha);
                    pw.getChunksList().queue((PngChunk)transparent);
                }
            }
            for (int row = 0; row < image.getHeight(); ++row) {
                pw.writeRow((IImageLine)scanlines);
            }
            pw.end();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to encode the PNG", e);
            throw e;
        }
        finally {
            pw.close();
        }
        return image;
    }

    public boolean isScanlineSupported(RenderedImage image) {
        ScanlineProvider scanlines = ScanlineProviderFactory.getProvider(image);
        return scanlines != null;
    }

    private ImageInfo getImageInfo(RenderedImage image, ScanlineProvider scanlines, ColorModel colorModel, boolean indexed) {
        int numColorComponents = colorModel.getNumColorComponents();
        boolean grayscale = !indexed && numColorComponents < 3;
        byte bitDepth = scanlines.getBitDepth();
        boolean hasAlpha = !indexed && colorModel.hasAlpha();
        ImageInfo ii = new ImageInfo(image.getWidth(), image.getHeight(), (int)bitDepth, hasAlpha, grayscale, indexed);
        return ii;
    }
}

