/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.ScanlineCursor;
import it.geosolutions.imageio.plugins.png.ScanlineProvider;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;

public abstract class AbstractScanlineProvider
implements ScanlineProvider {
    protected final int width;
    protected final int height;
    protected final int scanlineLength;
    protected final ScanlineCursor cursor;
    protected final IndexColorModel palette;
    protected final byte bitDepth;
    protected int currentRow = 0;

    public AbstractScanlineProvider(Raster raster, int bitDepth, int scanlineLength) {
        this(raster, (byte)bitDepth, scanlineLength, (IndexColorModel)null);
    }

    public AbstractScanlineProvider(Raster raster, int bitDepth, int scanlineLength, IndexColorModel palette) {
        this(raster, (byte)bitDepth, scanlineLength, palette);
    }

    protected AbstractScanlineProvider(Raster raster, byte bitDepth, int scanlineLength, IndexColorModel palette) {
        this.width = raster.getWidth();
        this.height = raster.getHeight();
        this.bitDepth = bitDepth;
        this.palette = palette;
        this.cursor = new ScanlineCursor(raster);
        this.scanlineLength = scanlineLength;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final byte getBitDepth() {
        return this.bitDepth;
    }

    public final IndexColorModel getPalette() {
        return this.palette;
    }

    public final int getScanlineLength() {
        return this.scanlineLength;
    }

    public void readFromPngRaw(byte[] raw, int len, int offset, int step) {
        throw new UnsupportedOperationException("This bridge works write only");
    }

    public void endReadFromPngRaw() {
        throw new UnsupportedOperationException("This bridge works write only");
    }

    public void writeToPngRaw(byte[] raw) {
        this.next(raw, 1, raw.length - 1);
    }
}

