/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.util.DefaultProgressListener;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.ProgressListener;

public class RequestUtils {
    private static final Logger LOGGER = Logging.getLogger(RequestUtils.class);

    public static String getVersionOws20(List<String> providedList, List<String> acceptedList) {
        TreeSet<Version> provided = new TreeSet<Version>();
        for (String v : providedList) {
            provided.add(new Version(v));
        }
        if (acceptedList == null || acceptedList.isEmpty()) {
            return ((Version)provided.last()).toString();
        }
        ArrayList<Version> accepted = new ArrayList<Version>();
        for (String v : acceptedList) {
            RequestUtils.checkVersionNumber20(v, "AcceptVersions");
            accepted.add(new Version(v));
        }
        Version negotiated = null;
        for (Version version : accepted) {
            if (!provided.contains(version)) continue;
            negotiated = version;
            break;
        }
        if (negotiated == null) {
            throw new OWS20Exception("Could not find any matching version", OWS20Exception.OWSExceptionCode.VersionNegotiationFailed);
        }
        return negotiated.toString();
    }

    public static void checkVersionNumber20(String v, String locator) throws ServiceException {
        if (!v.matches("[0-9]{1,2}\\.[0-9]{1,2}(\\.[0-9]{1,2})?")) {
            String msg = v + " is an invalid version number";
            throw new OWS20Exception("Could not find any matching version," + msg, OWS20Exception.OWSExceptionCode.VersionNegotiationFailed, locator);
        }
    }

    public static GridCoverage2D readBestCoverage(GridCoverage2DReader reader, Object params, GridGeometry2D readGG, Interpolation interpolation, OverviewPolicy overviewPolicy, Hints hints) throws IOException {
        int length;
        try {
            ReferencedEnvelope coverageEnvelope = new ReferencedEnvelope((Envelope)reader.getOriginalEnvelope());
            if (!coverageEnvelope.intersects((BoundingBox)ReferencedEnvelope.reference((Envelope)readGG.getEnvelope()))) {
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to compare data and request envelopes, proceeding with rendering anyways", e);
        }
        Parameter readGGParam = (Parameter)AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        readGGParam.setValue((Object)readGG);
        Parameter readInterpolation = (Parameter)ImageMosaicFormat.INTERPOLATION.createValue();
        readInterpolation.setValue((Object)interpolation);
        Parameter readOverview = (Parameter)AbstractGridFormat.OVERVIEW_POLICY.createValue();
        readOverview.setValue((Object)overviewPolicy);
        GridCoverage2D coverage = null;
        GeneralParameterValue[] readParams = (GeneralParameterValue[])params;
        int n = length = readParams == null ? 0 : readParams.length;
        if (length > 0) {
            String readGGName = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
            String readInterpolationName = ImageMosaicFormat.INTERPOLATION.getName().toString();
            String overviewPolicyName = AbstractGridFormat.OVERVIEW_POLICY.getName().toString();
            boolean foundInterpolation = false;
            boolean foundGG = false;
            boolean foundOverviewPolicy = false;
            for (int i = 0; i < length; ++i) {
                String paramName = readParams[i].getDescriptor().getName().toString();
                if (paramName.equalsIgnoreCase(readGGName)) {
                    ((Parameter)readParams[i]).setValue((Object)readGG);
                    foundGG = true;
                    continue;
                }
                if (paramName.equalsIgnoreCase(readInterpolationName)) {
                    ((Parameter)readParams[i]).setValue((Object)interpolation);
                    foundInterpolation = true;
                    continue;
                }
                if (!paramName.equalsIgnoreCase(overviewPolicyName)) continue;
                ((Parameter)readParams[i]).setValue((Object)overviewPolicy);
                foundOverviewPolicy = true;
            }
            if (!(foundGG && foundInterpolation && foundOverviewPolicy)) {
                ArrayList<Object> paramList = new ArrayList<Object>();
                paramList.addAll(Arrays.asList(readParams));
                if (!foundGG) {
                    paramList.add(readGGParam);
                }
                if (!foundInterpolation) {
                    paramList.add(readInterpolation);
                }
                if (!foundOverviewPolicy && readOverview != null && readOverview.getValue() != null) {
                    paramList.add(readOverview);
                }
                readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
            }
            coverage = reader.read(readParams);
        } else {
            coverage = reader.read(new GeneralParameterValue[]{readGGParam, readInterpolation});
        }
        return coverage;
    }

    public static AffineTransform getAffineTransform(MathTransform gridToCRS) {
        if (gridToCRS == null) {
            return null;
        }
        if (gridToCRS instanceof AffineTransform) {
            return (AffineTransform)gridToCRS;
        }
        return null;
    }

    public static GridCoverage2D readSampleGridCoverage(GridCoverage2DReader reader) throws Exception {
        GeneralEnvelope originalEnvelope = reader.getOriginalEnvelope();
        GridEnvelope originalRange = reader.getOriginalGridRange();
        Format coverageFormat = reader.getFormat();
        ParameterValueGroup readParams = coverageFormat.getReadParameters();
        Map parameters = CoverageUtils.getParametersKVP((ParameterValueGroup)readParams);
        int minX = originalRange.getLow(0);
        int minY = originalRange.getLow(1);
        int width = originalRange.getSpan(0);
        int height = originalRange.getSpan(1);
        int maxX = minX + (width <= 5 ? width : 5);
        int maxY = minY + (height <= 5 ? height : 5);
        GridEnvelope2D testRange = new GridEnvelope2D(minX, minY, maxX, maxY);
        MathTransform gridToWorldCorner = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        GeneralEnvelope testEnvelope = CRS.transform((MathTransform)gridToWorldCorner, (Envelope)new GeneralEnvelope((Rectangle2D)testRange.getBounds()));
        testEnvelope.setCoordinateReferenceSystem(originalEnvelope.getCoordinateReferenceSystem());
        String maxAllowedTiles = ImageMosaicFormat.MAX_ALLOWED_TILES.getName().toString();
        if (parameters.keySet().contains(maxAllowedTiles)) {
            parameters.put(maxAllowedTiles, 1);
        }
        parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), new GridGeometry2D((GridEnvelope)testRange, (Envelope)testEnvelope));
        return reader.read(CoverageUtils.getParameters((ParameterValueGroup)readParams, (Map)parameters, (boolean)true));
    }

    public static GridCoverage2D readSampleGridCoverage(CoverageInfo ci) throws Exception {
        GridCoverage2DReader reader = RequestUtils.getCoverageReader(ci);
        return RequestUtils.readSampleGridCoverage(reader);
    }

    public static GridCoverage2DReader getCoverageReader(CoverageInfo ci) throws IOException, Exception {
        CoverageStoreInfo store = ci.getStore();
        GridCoverageReader reader_ = ci.getGridCoverageReader((ProgressListener)new DefaultProgressListener(), GeoTools.getDefaultHints());
        if (reader_ == null) {
            throw new Exception("Unable to acquire a reader for this coverage with format: " + store.getFormat().getName());
        }
        GridCoverage2DReader reader = (GridCoverage2DReader)reader_;
        return reader;
    }

    public static void checkVersion(String version) {
        if (version == null) {
            throw new WCS20Exception("Missing version", OWS20Exception.OWSExceptionCode.MissingParameterValue, version);
        }
        if (!"2.0.1".equals(version) && !"2.0.0".equals(version)) {
            throw new WCS20Exception("Could not understand version:" + version);
        }
    }

    public static void checkService(String serviceName) {
        if (serviceName == null) {
            throw new WCS20Exception("Missing service name", OWS20Exception.OWSExceptionCode.MissingParameterValue, "service");
        }
        if (!"WCS".equals(serviceName)) {
            throw new WCS20Exception("Error in service name, epected value: WCS", OWS20Exception.OWSExceptionCode.InvalidParameterValue, serviceName);
        }
    }
}

