/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.util.ISO8601Formatter;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.util.NCNameResourceCodec;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.util.Utilities;
import org.vfny.geoserver.wcs.WcsException;

public class WCSDimensionsHelper {
    static final BigDecimal[] DURATIONS = new BigDecimal[]{new BigDecimal(31536000000L), new BigDecimal(2628000000L), new BigDecimal(86400000L), new BigDecimal(3600000L), new BigDecimal(60000), new BigDecimal(1000L)};
    static final String[] DURATION_UNITS = new String[]{"year", "month", "day", "hour", "minute", "second"};
    DimensionInfo timeDimension;
    DimensionInfo elevationDimension;
    Map<String, DimensionInfo> additionalDimensions;
    ReaderDimensionsAccessor accessor;
    ISO8601Formatter formatter = new ISO8601Formatter();
    String elevationResolutionUnit;
    double elevationResolutionValue;
    String timeResolutionUnit;
    long timeResolutionValue;
    String coverageId;

    public WCSDimensionsHelper(CoverageInfo ci) throws IOException {
        this.coverageId = NCNameResourceCodec.encode((ResourceInfo)ci);
        this.accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)ci.getGridCoverageReader(null, null));
        HashMap<String, DimensionInfo> dimensions = new HashMap<String, DimensionInfo>();
        for (Map.Entry entry : ci.getMetadata().entrySet()) {
            if (!(entry.getValue() instanceof DimensionInfo)) continue;
            dimensions.put((String)entry.getKey(), (DimensionInfo)entry.getValue());
        }
        if (!dimensions.isEmpty()) {
            this.initDimensions(dimensions);
        }
    }

    public WCSDimensionsHelper(final DimensionInfo timeDimension, GridCoverage2DReader reader, String coverageId) throws IOException {
        this((Map<String, DimensionInfo>)new HashMap<String, DimensionInfo>(){
            {
                this.put("time", timeDimension);
            }
        }, reader, coverageId);
    }

    public WCSDimensionsHelper(Map<String, DimensionInfo> dimensions, GridCoverage2DReader reader, String coverageId) throws IOException {
        this.accessor = new ReaderDimensionsAccessor(reader);
        this.coverageId = coverageId;
        if (dimensions != null && !dimensions.isEmpty()) {
            this.initDimensions(dimensions);
        }
    }

    private void initDimensions(Map<String, DimensionInfo> dimensions) {
        BigDecimal resolution;
        Utilities.ensureNonNull((String)"dimensions", dimensions);
        HashMap<String, DimensionInfo> updatedDimensions = new HashMap<String, DimensionInfo>();
        updatedDimensions.putAll(dimensions);
        if (updatedDimensions.containsKey("time")) {
            this.timeDimension = (DimensionInfo)updatedDimensions.remove("time");
            if (this.timeDimension != null && (resolution = this.timeDimension.getResolution()) != null) {
                this.setupTimeResolution(resolution);
            }
        }
        if (updatedDimensions.containsKey("elevation")) {
            this.elevationDimension = (DimensionInfo)updatedDimensions.remove("elevation");
            resolution = this.elevationDimension.getResolution();
            if (resolution != null) {
                this.elevationResolutionValue = resolution.doubleValue();
                this.elevationResolutionUnit = this.elevationDimension.getUnitSymbol();
            }
        }
        this.additionalDimensions = updatedDimensions;
    }

    private void setupTimeResolution(BigDecimal resolution) {
        for (int i = 0; i < DURATIONS.length; ++i) {
            BigDecimal duration = DURATIONS[i];
            if (resolution.remainder(duration).longValue() != 0L) continue;
            this.timeResolutionValue = resolution.divide(duration).longValue();
            this.timeResolutionUnit = DURATION_UNITS[i];
            return;
        }
        throw new WcsException("Dimension's resolution requires milliseconds for full representation, but this cannot be represented in WCS 2.0 describe coverage output");
    }

    public DimensionInfo getTimeDimension() {
        return this.timeDimension;
    }

    public DimensionInfo getElevationDimension() {
        return this.elevationDimension;
    }

    public Map<String, DimensionInfo> getAdditionalDimensions() {
        return this.additionalDimensions;
    }

    public TreeSet<Object> getTimeDomain() throws IOException {
        return this.accessor.getTimeDomain();
    }

    public TreeSet<Object> getElevationDomain() throws IOException {
        return this.accessor.getElevationDomain();
    }

    public List<String> getDomain(String domainName) throws IOException {
        return this.accessor.getDomain(domainName);
    }

    public String getBeginTime() throws IOException {
        Date minTime = this.accessor.getMinTime();
        return this.format(minTime);
    }

    public String getEndTime() throws IOException {
        Date maxTime = this.accessor.getMaxTime();
        return this.format(maxTime);
    }

    public String getBeginElevation() throws IOException {
        Double minElevation = this.accessor.getMinElevation();
        return minElevation.toString();
    }

    public String getEndElevation() throws IOException {
        Double maxElevation = this.accessor.getMaxElevation();
        return maxElevation.toString();
    }

    public String getDefaultValue(String domainName) throws IOException {
        if (this.additionalDimensions != null && !this.additionalDimensions.isEmpty() && this.additionalDimensions.containsKey(domainName)) {
            return this.accessor.getCustomDomainDefaultValue(domainName);
        }
        return null;
    }

    public String format(Date time) {
        if (time != null) {
            return this.formatter.format(time);
        }
        return null;
    }

    public String getTimeResolutionUnit() {
        return this.timeResolutionUnit;
    }

    public long getTimeResolutionValue() {
        return this.timeResolutionValue;
    }

    public String getElevationResolutionUnit() {
        return this.elevationResolutionUnit;
    }

    public double getElevationResolutionValue() {
        return this.elevationResolutionValue;
    }

    public String getCoverageId() {
        return this.coverageId;
    }

    public static Map<String, DimensionInfo> getDimensionsFromMetadata(MetadataMap metadata) {
        HashMap<String, DimensionInfo> dimensionsMap = new HashMap<String, DimensionInfo>();
        if (metadata != null && !metadata.isEmpty()) {
            Set metadataKeys = metadata.keySet();
            for (String key : metadataKeys) {
                DimensionInfo dimension;
                if (!WCSDimensionsHelper.isADimension(key) || (dimension = (DimensionInfo)metadata.get(key, DimensionInfo.class)) == null || !dimension.isEnabled()) continue;
                if (key.startsWith("custom_dimension_")) {
                    key = key.substring("custom_dimension_".length());
                }
                dimensionsMap.put(key, dimension);
            }
        }
        return dimensionsMap;
    }

    public static DimensionDescriptor getDimensionDescriptor(StructuredGridCoverage2DReader reader, String coverageName, String dimensionName) {
        try {
            List descriptors = reader.getDimensionDescriptors(coverageName);
            for (DimensionDescriptor dd : descriptors) {
                if (!dd.getName().equalsIgnoreCase(dimensionName)) continue;
                return dd;
            }
            return null;
        }
        catch (IOException e) {
            throw new WCS20Exception("Failed to locate the reader's " + dimensionName + " dimension descriptor", e);
        }
    }

    private static final boolean isADimension(String key) {
        return key != null && (key.equals("time") || key.equals("elevation") || key.startsWith("custom_dimension_"));
    }
}

