/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.util.ISO8601Formatter;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wcs.WcsException;

class TimeDimensionHelper {
    static final Logger LOGGER = Logging.getLogger(TimeDimensionHelper.class);
    static final BigDecimal[] DURATIONS = new BigDecimal[]{new BigDecimal(31536000000L), new BigDecimal(2628000000L), new BigDecimal(86400000L), new BigDecimal(3600000L), new BigDecimal(60000), new BigDecimal(1000L)};
    static final String[] DURATION_UNITS = new String[]{"year", "month", "day", "hour", "minute", "second"};
    DimensionInfo timeDimension;
    ReaderDimensionsAccessor accessor;
    ISO8601Formatter formatter = new ISO8601Formatter();
    String resolutionUnit;
    long resolutionValue;
    String coverageId;

    public TimeDimensionHelper(DimensionInfo timeDimension, GridCoverage2DReader reader, String coverageId) throws IOException {
        this.timeDimension = timeDimension;
        this.accessor = new ReaderDimensionsAccessor(reader);
        this.coverageId = coverageId;
        if (timeDimension.getResolution() != null) {
            this.setupResolution(timeDimension.getResolution());
        }
    }

    private void setupResolution(BigDecimal resolution) {
        for (int i = 0; i < DURATIONS.length; ++i) {
            BigDecimal duration = DURATIONS[i];
            if (resolution.remainder(duration).longValue() != 0L) continue;
            this.resolutionValue = resolution.divide(duration).longValue();
            this.resolutionUnit = DURATION_UNITS[i];
            return;
        }
        throw new WcsException("Dimension's resolution requires milliseconds for full representation, but this cannot be represented in WCS 2.0 describe coverage output");
    }

    public DimensionInfo getTimeDimension() {
        return this.timeDimension;
    }

    public TreeSet<Object> getTimeDomain() throws IOException {
        return this.accessor.getTimeDomain();
    }

    public String getBeginPosition() throws IOException {
        Date minTime = this.accessor.getMinTime();
        return this.format(minTime);
    }

    public String getEndPosition() throws IOException {
        Date maxTime = this.accessor.getMaxTime();
        return this.format(maxTime);
    }

    public String format(Date time) {
        if (time != null) {
            return this.formatter.format(time);
        }
        return null;
    }

    public DimensionPresentation getPresentation() {
        return this.timeDimension.getPresentation();
    }

    public String getResolutionUnit() {
        return this.resolutionUnit;
    }

    public long getResolutionValue() {
        return this.resolutionValue;
    }

    public String getCoverageId() {
        return this.coverageId;
    }
}

