/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wcs2_0.response.CoverageMimeTypeMapper;
import org.geotools.util.logging.Logging;

public class ImgMimeTypeMapper
implements CoverageMimeTypeMapper {
    static final Logger LOGGER = Logging.getLogger(ImgMimeTypeMapper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMimeType(CoverageInfo cInfo) throws IOException {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        File sourceFile = loader.url(cInfo.getStore().getURL());
        if (sourceFile == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Original source is null");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Original source: " + sourceFile.getAbsolutePath());
        }
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            inStream = ImageIO.createImageInputStream(sourceFile);
            if (inStream == null) {
                String string = null;
                return string;
            }
            Iterator<ImageReader> readers = ImageIO.getImageReaders(inStream);
            if (readers.hasNext()) {
                reader = readers.next();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Found reader for format: " + reader.getFormatName());
                }
                String string = reader.getOriginatingProvider().getMIMETypes()[0];
                return string;
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Unable to map mime type for coverage: " + cInfo.toString());
            }
        }
        finally {
            block37: {
                block36: {
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block36;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    if (reader != null) {
                        reader.dispose();
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block37;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
        return null;
    }
}

