/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.response;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.response.FileReference;
import org.geoserver.wcs2_0.response.TranslatorHelper;
import org.geoserver.wcs2_0.response.WCS20CoverageMetadataProvider;
import org.geoserver.wcs2_0.response.WCSDimensionsHelper;
import org.geoserver.wcs2_0.response.WCSDimensionsValueParser;
import org.geoserver.wcs2_0.util.EnvelopeAxesLabelsMapper;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform2D;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

class GMLTransformer
extends TransformerBase {
    protected final EnvelopeAxesLabelsMapper envelopeDimensionsMapper;
    protected FileReference fileReference;
    protected String mimeType;

    public GMLTransformer(EnvelopeAxesLabelsMapper envelopeDimensionsMapper) {
        this.envelopeDimensionsMapper = envelopeDimensionsMapper;
    }

    public void setFileReference(FileReference fileReference) {
        this.fileReference = fileReference;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new GMLTranslator(handler);
    }

    class GMLTranslator
    extends TransformerBase.TranslatorSupport {
        protected List<WCS20CoverageMetadataProvider> extensions;
        private WCS20CoverageMetadataProvider.Translator translator;
        protected TranslatorHelper helper;

        public GMLTranslator(ContentHandler contentHandler) {
            super(contentHandler, null, null);
            this.translator = new WCS20CoverageMetadataProvider.Translator(){

                @Override
                public void start(String element, Attributes attributes) {
                    GMLTranslator.this.start(element, attributes);
                }

                @Override
                public void start(String element) {
                    GMLTranslator.this.start(element);
                }

                @Override
                public void end(String element) {
                    GMLTranslator.this.end(element);
                }

                @Override
                public void chars(String text) {
                    GMLTranslator.this.chars(text);
                }
            };
            this.helper = new TranslatorHelper();
            this.extensions = GeoServerExtensions.extensions(WCS20CoverageMetadataProvider.class);
        }

        public void encode(Object o) throws IllegalArgumentException {
            NamespaceSupport namespaces = this.getNamespaceSupport();
            namespaces.declarePrefix("wcscrs", "http://www.opengis.net/wcs/service-extension/crs/1.0");
            namespaces.declarePrefix("int", "http://www.opengis.net/WCS_service-extension_interpolation/1.0");
            namespaces.declarePrefix("gml", "http://www.opengis.net/gml/3.2");
            namespaces.declarePrefix("gmlcov", "http://www.opengis.net/gmlcov/1.0");
            namespaces.declarePrefix("swe", "http://www.opengis.net/swe/2.0");
            namespaces.declarePrefix("xlink", "http://www.w3.org/1999/xlink");
            namespaces.declarePrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            for (WCS20CoverageMetadataProvider cp : this.extensions) {
                cp.registerNamespaces(namespaces);
            }
            if (!(o instanceof GridCoverage2D)) {
                throw new IllegalArgumentException("Provided object is not a GridCoverage2D:" + (o != null ? o.getClass().toString() : "null"));
            }
            GridCoverage2D gc2d = (GridCoverage2D)o;
            String gcName = gc2d.getName().toString(Locale.getDefault());
            CoordinateReferenceSystem crs = gc2d.getCoordinateReferenceSystem2D();
            List<String> axesNames = GMLTransformer.this.envelopeDimensionsMapper.getAxesNames((Envelope)gc2d.getEnvelope2D(), true);
            Integer EPSGCode = null;
            try {
                EPSGCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
            }
            catch (FactoryException e) {
                throw new IllegalStateException("Unable to lookup epsg code for this CRS:" + crs, e);
            }
            if (EPSGCode == null) {
                throw new IllegalStateException("Unable to lookup epsg code for this CRS:" + crs);
            }
            String srsName = "http://www.opengis.net/def/crs/EPSG/0/" + EPSGCode;
            boolean axisSwap = CRS.getAxisOrder((CoordinateReferenceSystem)crs).equals((Object)CRS.AxisOrder.EAST_NORTH);
            AttributesImpl attributes = new AttributesImpl();
            this.helper.registerNamespaces(this.getNamespaceSupport(), attributes);
            attributes.addAttribute("", "gml:id", "gml:id", "", gc2d.getName().toString(Locale.getDefault()));
            this.start("gml:RectifiedGridCoverage", attributes);
            StringBuilder builder = new StringBuilder();
            for (String axisName : axesNames) {
                builder.append(axisName).append(" ");
            }
            String axesLabel = builder.substring(0, builder.length() - 1);
            try {
                GeneralEnvelope envelope = new GeneralEnvelope(gc2d.getEnvelope());
                this.handleBoundedBy(envelope, axisSwap, srsName, axesLabel, null);
            }
            catch (IOException ex) {
                throw new WCS20Exception(ex);
            }
            builder.setLength(0);
            axesNames = GMLTransformer.this.envelopeDimensionsMapper.getAxesNames((Envelope)gc2d.getEnvelope2D(), false);
            for (String axisName : axesNames) {
                builder.append(axisName).append(" ");
            }
            axesLabel = builder.substring(0, builder.length() - 1);
            this.handleDomainSet(gc2d.getGridGeometry(), gc2d.getDimension(), gcName, srsName, axisSwap);
            this.handleRangeType(gc2d);
            GridEnvelope2D ge2D = gc2d.getGridGeometry().getGridRange2D();
            this.handleCoverageFunction(ge2D, axisSwap);
            this.handleRange(gc2d);
            try {
                this.handleMetadata(null, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.end("gml:RectifiedGridCoverage");
        }

        public void handleCoverageFunction(GridEnvelope2D gridRange, boolean axisSwap) {
            this.start("gml:coverageFunction");
            this.start("gml:GridFunction");
            AttributesImpl gridAttrs = new AttributesImpl();
            gridAttrs.addAttribute("", "axisOrder", "axisOrder", "", axisSwap ? "+2 +1" : "+1 +2");
            this.element("gml:sequenceRule", "Linear", gridAttrs);
            this.element("gml:startPoint", gridRange.x + " " + gridRange.y);
            this.end("gml:GridFunction");
            this.end("gml:coverageFunction");
        }

        public void handleMetadata(Object context, WCSDimensionsHelper dimensionsHelper) throws IOException {
            this.start("gmlcov:metadata");
            this.start("gmlcov:Extension");
            if (dimensionsHelper != null) {
                this.handleTimeMetadata(dimensionsHelper);
                this.handleElevationMetadata(dimensionsHelper);
                this.handleAdditionalDimensionMetadata(dimensionsHelper);
            }
            for (WCS20CoverageMetadataProvider extension : this.extensions) {
                extension.encode(this.translator, context);
            }
            this.end("gmlcov:Extension");
            this.end("gmlcov:metadata");
        }

        private void handleAdditionalDimensionMetadata(WCSDimensionsHelper helper) throws IOException {
            Utilities.ensureNonNull((String)"helper", (Object)helper);
            Map<String, DimensionInfo> additionalDimensions = helper.getAdditionalDimensions();
            Set<String> dimensionsName = additionalDimensions.keySet();
            for (String dimensionName : dimensionsName) {
                DimensionInfo customDimension = additionalDimensions.get(dimensionName);
                if (customDimension == null) continue;
                this.setAdditionalDimensionMetadata(dimensionName, customDimension, helper);
            }
        }

        private void setAdditionalDimensionMetadata(String name, DimensionInfo dimension, WCSDimensionsHelper helper) throws IOException {
            Utilities.ensureNonNull((String)"helper", (Object)helper);
            String startTag = this.initStartMetadataTag("wcsgs:DimensionDomain", name, dimension, helper);
            this.start(startTag);
            List<String> domain = helper.getDomain(name);
            int i = 0;
            for (String item : domain) {
                Date date = WCSDimensionsValueParser.parseAsDate(item);
                if (date != null) {
                    String dimensionId = helper.getCoverageId() + "_dd_" + i;
                    this.encodeDate(date, helper, dimensionId);
                    continue;
                }
                Double number = WCSDimensionsValueParser.parseAsDouble(item);
                if (number != null) {
                    this.element("wcsgs:SingleValue", item.toString());
                    continue;
                }
                NumberRange<Double> range = WCSDimensionsValueParser.parseAsDoubleRange(item);
                if (range != null) {
                    this.encodeInterval(((Double)range.getMinValue()).toString(), ((Double)range.getMaxValue()).toString(), null, null);
                    continue;
                }
                if (item instanceof String) {
                    this.element("wcsgs:SingleValue", item.toString());
                }
                ++i;
            }
            this.end("wcsgs:DimensionDomain");
        }

        private String initStartMetadataTag(String dimensionTag, String name, DimensionInfo dimension, WCSDimensionsHelper helper) throws IOException {
            String uom = dimension.getUnitSymbol();
            String defaultValue = null;
            String prolog = null;
            if (dimensionTag.equals("wcsgs:DimensionDomain")) {
                prolog = "wcsgs:DimensionDomain name = \"" + name + "\"";
                defaultValue = helper.getDefaultValue(name);
            } else if (dimensionTag.equals("wcsgs:ElevationDomain")) {
                prolog = "wcsgs:ElevationDomain";
                defaultValue = helper.getBeginElevation();
            } else if (dimensionTag.equals("wcsgs:TimeDomain")) {
                prolog = "wcsgs:TimeDomain";
                defaultValue = helper.getEndTime();
            }
            return prolog + (uom != null ? " uom=\"" + uom + "\"" : "") + (defaultValue != null ? " default=\"" + defaultValue + "\"" : "");
        }

        private void handleTimeMetadata(WCSDimensionsHelper helper) throws IOException {
            Utilities.ensureNonNull((String)"helper", (Object)helper);
            DimensionInfo timeDimension = helper.getTimeDimension();
            if (timeDimension != null) {
                this.start(this.initStartMetadataTag("wcsgs:TimeDomain", null, timeDimension, helper));
                DimensionPresentation presentation = timeDimension.getPresentation();
                String id = helper.getCoverageId();
                switch (presentation) {
                    case CONTINUOUS_INTERVAL: {
                        this.encodeTimePeriod(helper.getBeginTime(), helper.getEndTime(), id + "_tp_0", null, null);
                        break;
                    }
                    case DISCRETE_INTERVAL: {
                        this.encodeTimePeriod(helper.getBeginTime(), helper.getEndTime(), id + "_tp_0", helper.getTimeResolutionUnit(), helper.getTimeResolutionValue());
                        break;
                    }
                    default: {
                        TreeSet<Object> domain = helper.getTimeDomain();
                        int i = 0;
                        for (Object item : domain) {
                            if (item instanceof Date) {
                                this.encodeDate((Date)item, helper, id + "_td_" + i);
                            } else if (item instanceof DateRange) {
                                this.encodeDateRange((DateRange)item, helper, id + "_td_" + i);
                            }
                            ++i;
                        }
                    }
                }
                this.end("wcsgs:TimeDomain");
            }
        }

        private void handleElevationMetadata(WCSDimensionsHelper helper) throws IOException {
            DimensionInfo elevationDimension = helper.getElevationDimension();
            if (elevationDimension != null) {
                this.start(this.initStartMetadataTag("wcsgs:ElevationDomain", null, elevationDimension, helper));
                DimensionPresentation presentation = elevationDimension.getPresentation();
                switch (presentation) {
                    case CONTINUOUS_INTERVAL: {
                        this.encodeInterval(helper.getBeginElevation(), helper.getEndElevation(), null, null);
                        break;
                    }
                    case DISCRETE_INTERVAL: {
                        this.encodeInterval(helper.getBeginElevation(), helper.getEndElevation(), helper.getElevationResolutionUnit(), helper.getElevationResolutionValue());
                        break;
                    }
                    default: {
                        TreeSet<Object> domain = helper.getElevationDomain();
                        for (Object item : domain) {
                            if (item instanceof Number) {
                                this.element("wcsgs:SingleValue", item.toString());
                                continue;
                            }
                            if (!(item instanceof NumberRange)) continue;
                            NumberRange range = (NumberRange)item;
                            this.encodeInterval(range.getMinValue().toString(), range.getMaxValue().toString(), null, null);
                        }
                    }
                }
                this.end("wcsgs:ElevationDomain");
            }
        }

        private void encodeDateRange(DateRange range, WCSDimensionsHelper helper, String id) {
            this.encodeTimePeriod(helper.format(range.getMinValue()), helper.format(range.getMaxValue()), id, null, null);
        }

        private void encodeDate(Date item, WCSDimensionsHelper helper, String id) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "gml:id", "gml:id", "", id);
            this.start("gml:TimeInstant", atts);
            this.element("gml:timePosition", helper.format(item));
            this.end("gml:TimeInstant");
        }

        public void encodeTimePeriod(String beginPosition, String endPosition, String timePeriodId, String intervalUnit, Long intervalValue) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "gml:id", "gml:id", "", timePeriodId);
            this.start("gml:TimePeriod", atts);
            this.element("gml:beginPosition", beginPosition);
            this.element("gml:endPosition", endPosition);
            if (intervalUnit != null && intervalValue != null) {
                atts = new AttributesImpl();
                atts.addAttribute("", "unit", "unit", "", intervalUnit);
                this.element("gml:TimeInterval", intervalValue.toString(), atts);
            }
            this.end("gml:TimePeriod");
        }

        public void encodeInterval(String beginPosition, String endPosition, String intervalUnit, Double intervalValue) {
            AttributesImpl atts = new AttributesImpl();
            this.start("wcsgs:Range", atts);
            this.element("wcsgs:start", beginPosition);
            this.element("wcsgs:end", endPosition);
            if (intervalUnit != null && intervalValue != null) {
                atts = new AttributesImpl();
                atts.addAttribute("", "unit", "unit", "", intervalUnit);
                this.element("wcsgs:Interval", intervalValue.toString(), atts);
            }
            this.end("wcsgs:Range");
        }

        public void handleBoundedBy(GeneralEnvelope envelope, boolean axisSwap, String srsName, String axisLabels, WCSDimensionsHelper dimensionHelper) throws IOException {
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            CoordinateSystem cs = crs.getCoordinateSystem();
            String uomLabels = this.extractUoM(crs, cs.getAxis(axisSwap ? 1 : 0).getUnit()) + " " + this.extractUoM(crs, cs.getAxis(axisSwap ? 0 : 1).getUnit());
            boolean hasElevation = false;
            boolean hasTime = false;
            if (dimensionHelper != null) {
                if (dimensionHelper.getElevationDimension() != null) {
                    uomLabels = uomLabels + " m";
                    hasElevation = true;
                }
                if (dimensionHelper.getTimeDimension() != null) {
                    uomLabels = uomLabels + " s";
                    hasTime = true;
                }
            }
            int srsDimension = cs.getDimension() + (hasElevation ? 1 : 0);
            String lower = envelope.getLowerCorner().getOrdinate(axisSwap ? 1 : 0) + " " + envelope.getLowerCorner().getOrdinate(axisSwap ? 0 : 1) + (hasElevation ? " " + dimensionHelper.getBeginElevation() : "");
            String upper = envelope.getUpperCorner().getOrdinate(axisSwap ? 1 : 0) + " " + envelope.getUpperCorner().getOrdinate(axisSwap ? 0 : 1) + (hasElevation ? " " + dimensionHelper.getEndElevation() : "");
            AttributesImpl envelopeAttrs = new AttributesImpl();
            envelopeAttrs.addAttribute("", "srsName", "srsName", "", srsName);
            envelopeAttrs.addAttribute("", "axisLabels", "axisLabels", "", axisLabels);
            envelopeAttrs.addAttribute("", "uomLabels", "uomLabels", "", uomLabels);
            envelopeAttrs.addAttribute("", "srsDimension", "srsDimension", "", String.valueOf(srsDimension));
            this.start("gml:boundedBy");
            String envelopeName = dimensionHelper != null && (hasTime || hasElevation) ? "gml:EnvelopeWithTimePeriod" : "gml:Envelope";
            this.start(envelopeName, envelopeAttrs);
            this.element("gml:lowerCorner", lower);
            this.element("gml:upperCorner", upper);
            if (dimensionHelper != null && hasTime) {
                this.element("gml:beginPosition", dimensionHelper.getBeginTime());
                this.element("gml:endPosition", dimensionHelper.getEndTime());
            }
            this.end(envelopeName);
            this.end("gml:boundedBy");
        }

        public String extractUoM(CoordinateReferenceSystem crs, Unit<?> uom) {
            if (crs instanceof GeographicCRS) {
                return "Deg";
            }
            return UnitFormat.getInstance().format(uom);
        }

        public void handleRange(GridCoverage2D gc2d) {
            this.start("gml:rangeSet");
            if (GMLTransformer.this.fileReference != null) {
                this.encodeFileReference(GMLTransformer.this.fileReference);
            } else {
                this.encodeAsDataBlocks(gc2d);
            }
            this.end("gml:rangeSet");
        }

        private void encodeFileReference(FileReference fileReference) {
            this.start("gml:File");
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "xlink:arcrole", "xlink:arcrole", "", "fileReference");
            atts.addAttribute("", "xlink:href", "xlink:href", "", "cid:" + fileReference.getReference());
            atts.addAttribute("", "xlink:role", "xlink:role", "", fileReference.getConformanceClass());
            this.element("gml:rangeParameters", "", atts);
            this.element("gml:fileReference", "cid:" + fileReference.getReference());
            this.element("gml:fileStructure", "");
            this.element("gml:mimeType", fileReference.getMimeType());
            this.end("gml:File");
        }

        private void encodeAsDataBlocks(GridCoverage2D gc2d) {
            this.start("gml:DataBlock");
            this.start("gml:rangeParameters");
            this.end("gml:rangeParameters");
            this.start("tupleList");
            RenderedImage raster = gc2d.getRenderedImage();
            int numBands = raster.getSampleModel().getNumBands();
            int dataType = raster.getSampleModel().getDataType();
            double[] valuesD = new double[numBands];
            int[] valuesI = new int[numBands];
            RectIter iterator = RectIterFactory.create((RenderedImage)raster, (Rectangle)PlanarImage.wrapRenderedImage((RenderedImage)raster).getBounds());
            iterator.startLines();
            while (!iterator.finishedLines()) {
                iterator.startPixels();
                while (!iterator.finishedPixels()) {
                    switch (dataType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            int i;
                            iterator.getPixel(valuesI);
                            for (i = 0; i < numBands; ++i) {
                                this.chars(String.valueOf(valuesI[i]));
                                if (i + 1 >= numBands) continue;
                                this.chars(",");
                            }
                            break;
                        }
                        case 4: 
                        case 5: {
                            int i;
                            iterator.getPixel(valuesD);
                            for (i = 0; i < numBands; ++i) {
                                this.chars(String.valueOf(valuesD[i]));
                                if (i + 1 >= numBands) continue;
                                this.chars(",");
                            }
                            break;
                        }
                    }
                    this.chars(" ");
                    iterator.nextPixel();
                }
                iterator.nextLine();
                this.chars("\n");
            }
            this.end("tupleList");
            this.end("gml:DataBlock");
        }

        public void handleRangeType(GridCoverage2D gc2d) {
            GridSampleDimension[] bands;
            this.start("gml:rangeType");
            this.start("swe:DataRecord");
            for (GridSampleDimension sd : bands = gc2d.getSampleDimensions()) {
                AttributesImpl fieldAttr = new AttributesImpl();
                fieldAttr.addAttribute("", "name", "name", "", sd.getDescription().toString());
                this.start("swe:field", fieldAttr);
                this.start("swe:Quantity");
                this.start("swe:description");
                this.chars(sd.getDescription().toString());
                this.end("swe:description");
                AttributesImpl uomAttr = new AttributesImpl();
                Unit uom = sd.getUnits();
                uomAttr.addAttribute("", "code", "code", "", uom == null ? "W.m-2.Sr-1" : UnitFormat.getInstance().format((Object)uom));
                this.start("swe:uom", uomAttr);
                this.end("swe:uom");
                this.start("swe:constraint");
                this.start("swe:AllowedValues");
                this.handleSampleDimensionRange((SampleDimension)sd);
                this.end("swe:AllowedValues");
                this.end("swe:constraint");
                this.handleSampleDimensionNilValues(gc2d, sd.getNoDataValues());
                this.end("swe:Quantity");
                this.end("swe:field");
            }
            this.end("swe:DataRecord");
            this.end("gml:rangeType");
        }

        public void handleSampleDimensionNilValues(GridCoverage2D gc2d, GridSampleDimension sd) {
            this.handleSampleDimensionNilValues(gc2d, sd != null ? sd.getNoDataValues() : null);
        }

        public void handleSampleDimensionNilValues(GridCoverage2D gc2d, double[] nodataValues) {
            this.start("swe:nilValues");
            this.start("swe:NilValues");
            if (nodataValues != null && nodataValues.length > 0) {
                for (double nodata : nodataValues) {
                    AttributesImpl nodataAttr = new AttributesImpl();
                    nodataAttr.addAttribute("", "reason", "reason", "", "http://www.opengis.net/def/nil/OGC/0/unknown");
                    this.element("swe:nilValue", String.valueOf(nodata), nodataAttr);
                }
            } else if (gc2d != null) {
                NoDataContainer noDataProperty = CoverageUtilities.getNoDataProperty((GridCoverage2D)gc2d);
                if (noDataProperty != null) {
                    String nodata = Double.valueOf(noDataProperty.getAsSingleValue()).toString();
                    AttributesImpl nodataAttr = new AttributesImpl();
                    nodataAttr.addAttribute("", "reason", "reason", "", "http://www.opengis.net/def/nil/OGC/0/unknown");
                    this.element("swe:nilValue", nodata, nodataAttr);
                } else {
                    Number nodata = CoverageUtilities.suggestNoDataValue((int)gc2d.getRenderedImage().getSampleModel().getDataType());
                    AttributesImpl nodataAttr = new AttributesImpl();
                    nodataAttr.addAttribute("", "reason", "reason", "", "http://www.opengis.net/def/nil/OGC/0/unknown");
                    this.element("swe:nilValue", nodata.toString(), nodataAttr);
                }
            }
            this.end("swe:NilValues");
            this.end("swe:nilValues");
        }

        public void handleSampleDimensionRange(CoverageDimensionInfo sd) {
            if (!this.setRange((NumberRange<? extends Number>)sd.getRange())) {
                SampleDimensionType sdType = sd.getDimensionType();
                this.handleSampleDimensionType(sdType);
            }
        }

        private void handleSampleDimensionType(SampleDimensionType sdType) {
            if (sdType == null) {
                sdType = SampleDimensionType.REAL_64BITS;
            }
            NumberRange indicativeRange = TypeMap.getRange((SampleDimensionType)sdType);
            this.setRange((NumberRange<? extends Number>)indicativeRange);
        }

        private boolean setRange(NumberRange<? extends Number> range) {
            if (range != null && !Double.isInfinite(range.getMaximum()) && !Double.isInfinite(range.getMinimum())) {
                this.start("swe:interval");
                this.chars(range.getMinValue() + " " + range.getMaxValue());
                this.end("swe:interval");
                return true;
            }
            return false;
        }

        public void handleSampleDimensionRange(SampleDimension sd) {
            boolean setRange = false;
            if (sd instanceof GridSampleDimension) {
                GridSampleDimension gridSd = (GridSampleDimension)sd;
                setRange = this.setRange((NumberRange<? extends Number>)gridSd.getRange());
            }
            if (!setRange) {
                SampleDimensionType sdType = sd.getSampleDimensionType();
                this.handleSampleDimensionType(sdType);
            }
        }

        public void handleDomainSet(GridGeometry2D gg2D, int gridDimension, String gcName, String srsName, boolean axesSwap) {
            String gridId = "grid00__" + gcName;
            GridEnvelope gridEnvelope = gg2D.getGridRange();
            StringBuilder lowSb = new StringBuilder();
            for (int i : gridEnvelope.getLow().getCoordinateValues()) {
                lowSb.append(i).append(' ');
            }
            StringBuilder highSb = new StringBuilder();
            for (int i : gridEnvelope.getHigh().getCoordinateValues()) {
                highSb.append(i).append(' ');
            }
            AttributesImpl gridAttrs = new AttributesImpl();
            gridAttrs.addAttribute("", "gml:id", "gml:id", "", gridId);
            gridAttrs.addAttribute("", "dimension", "dimension", "", String.valueOf(gridDimension));
            this.start("gml:domainSet");
            this.start("gml:RectifiedGrid", gridAttrs);
            this.start("gml:limits");
            this.start("gml:GridEnvelope");
            this.element("gml:low", lowSb.toString().trim());
            this.element("gml:high", highSb.toString().trim());
            this.end("gml:GridEnvelope");
            this.end("gml:limits");
            this.element("gml:axisLabels", "i j");
            MathTransform2D transform = gg2D.getGridToCRS2D(PixelOrientation.CENTER);
            if (!(transform instanceof AffineTransform2D)) {
                throw new IllegalStateException("Invalid grid to worl provided:" + transform.toString());
            }
            AffineTransform2D g2W = (AffineTransform2D)transform;
            AttributesImpl pointAttr = new AttributesImpl();
            pointAttr.addAttribute("", "gml:id", "gml:id", "", "p00_" + gcName);
            pointAttr.addAttribute("", "srsName", "srsName", "", srsName);
            this.start("gml:origin");
            this.start("gml:Point", pointAttr);
            this.element("gml:pos", axesSwap ? g2W.getTranslateY() + " " + g2W.getTranslateX() : g2W.getTranslateX() + " " + g2W.getTranslateY());
            this.end("gml:Point");
            this.end("gml:origin");
            AttributesImpl offsetAttr = new AttributesImpl();
            offsetAttr.addAttribute("", "srsName", "srsName", "", srsName);
            this.element("gml:offsetVector", Double.valueOf(axesSwap ? g2W.getShearX() : g2W.getScaleX()) + " " + Double.valueOf(axesSwap ? g2W.getScaleX() : g2W.getShearX()), offsetAttr);
            this.element("gml:offsetVector", Double.valueOf(axesSwap ? g2W.getScaleY() : g2W.getShearY()) + " " + Double.valueOf(axesSwap ? g2W.getShearY() : g2W.getScaleY()), offsetAttr);
            this.end("gml:RectifiedGrid");
            this.end("gml:domainSet");
        }
    }

    static class TAG {
        private static final String RANGE = "wcsgs:Range";
        private static final String INTERVAL_START = "wcsgs:start";
        private static final String INTERVAL_END = "wcsgs:end";
        private static final String INTERVAL_PERIOD = "wcsgs:Interval";
        private static final String SINGLE_VALUE = "wcsgs:SingleValue";
        private static final String ADDITIONAL_DIMENSION = "wcsgs:DimensionDomain";
        private static final String TIME_DOMAIN = "wcsgs:TimeDomain";
        private static final String ELEVATION_DOMAIN = "wcsgs:ElevationDomain";

        TAG() {
        }
    }
}

