/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import java.util.List;
import net.opengis.wcs20.ScaleAxisByFactorType;
import net.opengis.wcs20.ScaleAxisType;
import net.opengis.wcs20.Wcs20Factory;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.geoserver.wcs2_0.kvp.AbstractAxisValueKvpParser;

public class ScaleAxesKvpParser
extends AbstractAxisValueKvpParser<ScaleAxisType> {
    public ScaleAxesKvpParser() {
        super("scaleaxes", ScaleAxisType.class);
    }

    public Object parse(String value) throws Exception {
        ScaleAxisByFactorType sabf = Wcs20Factory.eINSTANCE.createScaleAxisByFactorType();
        List items = this.parseItem(value);
        sabf.getScaleAxis().addAll(items);
        return sabf;
    }

    @Override
    protected ScaleAxisType buildItem(String axisName, String value) {
        ScaleAxisType sa = Wcs20Factory.eINSTANCE.createScaleAxisType();
        try {
            sa.setAxis(axisName.trim());
            sa.setScaleFactor(Double.valueOf(value).doubleValue());
        }
        catch (NumberFormatException e) {
            this.throwInvalidSyntaxException(null);
        }
        return sa;
    }

    @Override
    protected void throwInvalidSyntaxException(Exception e) {
        WCS20Exception ex = new WCS20Exception("Invalid ScaleAxes syntax, expecting a comma separate list of axisName(scale)*", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "scaleAxes");
        if (e != null) {
            ex.initCause(e);
        }
        throw ex;
    }
}

