/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.kvp;

import net.opengis.wcs20.RangeIntervalType;
import net.opengis.wcs20.RangeItemType;
import net.opengis.wcs20.RangeSubsetType;
import net.opengis.wcs20.Wcs20Factory;
import org.geoserver.ows.KvpParser;
import org.geoserver.wcs2_0.exception.WCS20Exception;

public class RangeSubsetKvpParser
extends KvpParser {
    public RangeSubsetKvpParser() {
        super("rangesubset", RangeSubsetType.class);
    }

    public Object parse(String value) throws Exception {
        String[] components;
        RangeSubsetType result = Wcs20Factory.eINSTANCE.createRangeSubsetType();
        if ((value = value.trim()).matches(".*,\\s*,.*")) {
            this.throwInvalidSyntaxException();
        } else if (value.startsWith(",") || value.endsWith(",")) {
            this.throwInvalidSyntaxException();
        }
        for (String component : components = value.split("\\s*,\\s*")) {
            if (component.contains(":")) {
                String[] lowHigh = component.split(":");
                if (lowHigh.length != 2) {
                    this.throwInvalidSyntaxException();
                }
                RangeIntervalType ri = Wcs20Factory.eINSTANCE.createRangeIntervalType();
                ri.setStartComponent(lowHigh[0]);
                ri.setEndComponent(lowHigh[1]);
                RangeItemType item = Wcs20Factory.eINSTANCE.createRangeItemType();
                item.setRangeInterval(ri);
                result.getRangeItems().add((Object)item);
                continue;
            }
            RangeItemType item = Wcs20Factory.eINSTANCE.createRangeItemType();
            item.setRangeComponent(component);
            result.getRangeItems().add((Object)item);
        }
        return result;
    }

    protected void throwInvalidSyntaxException() {
        throw new WCS20Exception("Invalid RangeSubset syntax, expecting a list of band names or band ranges (b1:b2)", WCS20Exception.WCS20ExceptionCode.InvalidEncodingSyntax, "rangeSubset");
    }
}

