/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs2_0.exception;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import net.opengis.ows20.ExceptionReportType;
import net.opengis.ows20.ExceptionType;
import net.opengis.ows20.Ows20Factory;
import org.geoserver.ows.Request;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.ows.v2_0.OWS;
import org.geotools.ows.v2_0.OWSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;

public class OWS20ServiceExceptionHandler
extends ServiceExceptionHandler {
    public static boolean force200httpcode = Boolean.getBoolean("force200");
    protected boolean verboseExceptions = false;
    protected boolean useServiceVersion = false;

    public OWS20ServiceExceptionHandler() {
        super(Collections.EMPTY_LIST);
    }

    public OWS20ServiceExceptionHandler(List services) {
        super(services);
    }

    public OWS20ServiceExceptionHandler(Service service) {
        super(Arrays.asList(service));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleServiceException(ServiceException exception, Request request) {
        String code;
        OWS20Exception.OWSExceptionCode exCode;
        LOGGER.warning("OWS20SEH: handling " + exception);
        String version = null;
        if (this.useServiceVersion && request.getServiceDescriptor() != null) {
            version = request.getServiceDescriptor().getVersion().toString();
        }
        ExceptionReportType report = OWS20ServiceExceptionHandler.exceptionReport(exception, this.verboseExceptions, version);
        HttpServletResponse response = request.getHttpResponse();
        if (!request.isSOAP()) {
            response.setContentType("application/xml");
        }
        OWS20Exception ows2ex = exception instanceof OWS20Exception ? (OWS20Exception)exception : (exception.getCause() != null && exception.getCause() instanceof OWS20Exception ? (OWS20Exception)exception.getCause() : ((exCode = OWS20Exception.OWSExceptionCode.getByCode((String)(code = exception.getCode()))) != null ? new OWS20Exception(exception.getMessage(), (Throwable)exception, exCode, exception.getLocator()) : new OWS20Exception(exception.getMessage(), (Throwable)exception, OWS20Exception.OWSExceptionCode.NoApplicableCode, exception.getLocator())));
        OWSConfiguration configuration = new OWSConfiguration();
        Encoder encoder = new Encoder((Configuration)configuration, configuration.schema());
        encoder.setIndenting(true);
        encoder.setIndentSize(2);
        encoder.setLineWidth(60);
        encoder.setOmitXMLDeclaration(request.isSOAP());
        String schemaLocation = "http://schemas.opengis.net/ows/2.0/owsExceptionReport.xsd";
        encoder.setSchemaLocation("http://www.opengis.net/ows/2.0", schemaLocation);
        try {
            if (ows2ex.getHttpCode() != null) {
                response.setStatus(ows2ex.getHttpCode().intValue());
            }
            if (force200httpcode) {
                response.setStatus(200);
            }
            encoder.encode((Object)report, OWS.ExceptionReport, (OutputStream)response.getOutputStream());
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", ex);
        }
        finally {
            try {
                response.getOutputStream().flush();
            }
            catch (IOException ioe) {}
        }
    }

    public void setUseServiceVersion(boolean useServiceVersion) {
        this.useServiceVersion = useServiceVersion;
    }

    public static ExceptionReportType exceptionReport(ServiceException exception, boolean verboseExceptions, String version) {
        ExceptionType e = Ows20Factory.eINSTANCE.createExceptionType();
        if (exception.getCode() != null) {
            e.setExceptionCode(exception.getCode());
        } else {
            e.setExceptionCode("NoApplicableCode");
        }
        e.setLocator(exception.getLocator());
        StringBuffer sb = new StringBuffer();
        OwsUtils.dumpExceptionMessages((ServiceException)exception, (StringBuffer)sb, (boolean)true);
        sb.append("\n");
        sb.append(exception.getExceptionText());
        if (verboseExceptions) {
            sb.append("\nDetails:\n");
            ByteArrayOutputStream trace = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(trace));
            sb.append(new String(trace.toByteArray()));
        }
        e.setExceptionText(sb.toString());
        ExceptionReportType report = Ows20Factory.eINSTANCE.createExceptionReportType();
        version = version != null ? version : "2.0.0";
        report.setVersion(version);
        report.getException().add((Object)e);
        return report;
    }
}

