/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.scale.ScaleOpImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class ScaleNearestOpImage2
extends ScaleOpImage {
    protected InterpolationNearest interpN = null;
    private final boolean nullROINoData;
    private final boolean nullNoDataNotNullROI;
    private final boolean notNullNoDataNullROI;

    public ScaleNearestOpImage2(RenderedImage source, ImageLayout layout, Map configuration, BorderExtender extender, Interpolation interp, float scaleX, float scaleY, float transX, float transY, boolean useRoiAccessor) {
        super(source, layout, configuration, true, extender, interp, scaleX, scaleY, transX, transY, useRoiAccessor, null);
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        SampleModel sm = source.getSampleModel();
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        this.interpolator = interp;
        if (this.interpolator instanceof InterpolationNearest) {
            this.isNearestNew = true;
            this.interpN = (InterpolationNearest)this.interpolator;
            this.interp = this.interpN;
            this.interpN.setROIdata(this.roiBounds, this.roiIter);
            this.destinationNoDataDouble = new double[1];
            if (this.noData != null) {
                this.hasNoData = true;
                this.destinationNoDataDouble[0] = this.interpN.getDestinationNoData();
            } else if (this.hasROI) {
                this.destinationNoDataDouble[0] = this.interpN.getDestinationNoData();
            }
        }
        if (!this.hasROI && !this.hasNoData) {
            this.nullROINoData = true;
            this.nullNoDataNotNullROI = false;
            this.notNullNoDataNullROI = false;
        } else if (this.hasROI && !this.hasNoData) {
            this.nullROINoData = false;
            this.notNullNoDataNullROI = false;
            this.nullNoDataNotNullROI = true;
        } else if (!this.hasROI && this.hasNoData) {
            this.nullROINoData = false;
            this.notNullNoDataNullROI = true;
            this.nullNoDataNotNullROI = false;
        } else {
            this.nullROINoData = false;
            this.nullNoDataNotNullROI = true;
            this.notNullNoDataNullROI = true;
        }
        this.subsampleBits = interp.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.one = 1 << this.subsampleBits;
        this.interp_width = interp.getWidth();
        this.interp_height = interp.getHeight();
        this.interp_left = interp.getLeftPadding();
        this.interp_top = interp.getTopPadding();
        switch (sm.getDataType()) {
            case 0: {
                this.destinationNoDataByte = new byte[1];
                this.destinationNoDataByte[0] = (byte)((byte)this.destinationNoDataDouble[0] & 0xFF);
                break;
            }
            case 1: {
                this.destinationNoDataUShort = new short[1];
                this.destinationNoDataUShort[0] = (short)((short)this.destinationNoDataDouble[0] & 0xFFFF);
                break;
            }
            case 2: {
                this.destinationNoDataShort = new short[1];
                this.destinationNoDataShort[0] = (short)this.destinationNoDataDouble[0];
                break;
            }
            case 3: {
                this.destinationNoDataInt = new int[1];
                this.destinationNoDataInt[0] = (int)this.destinationNoDataDouble[0];
                break;
            }
            case 4: {
                this.destinationNoDataFloat = new float[1];
                this.destinationNoDataFloat[0] = (float)this.destinationNoDataDouble[0];
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data Type");
            }
        }
        this.isBinary = sm instanceof MultiPixelPackedSampleModel && sm.getSampleSize(0) == 1 && (sm.getDataType() == 0 || sm.getDataType() == 1 || sm.getDataType() == 3);
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect, Raster[] rois) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int srcPixelStride = srcAccessor.getPixelStride();
        int srcScanlineStride = srcAccessor.getScanlineStride();
        int[] xpos = new int[dwidth];
        int[] ypos = new int[dheight];
        int[] yposRoi = null;
        int roiScanlineStride = 0;
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        if (this.useRoiAccessor) {
            roi = rois[0];
            roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
            roiScanlineStride = roiAccessor.getScanlineStride();
            yposRoi = new int[dheight];
        }
        int[] xfracValues = new int[dwidth];
        int[] yfracValues = new int[dheight];
        this.preComputePositionsInt(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracValues, yfracValues, roiScanlineStride, yposRoi);
        this.dataType = dest.getSampleModel().getDataType();
        switch (this.dataType) {
            case 0: {
                this.byteLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        byte[] dstData = null;
        byte[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        for (int k = 0; k < dnumBands; ++k) {
            srcData = srcDataArrays[k];
            dstData = dstDataArrays[k];
            int dstlineOffset = dstBandOffsets[k];
            int bandOffset = bandOffsets[k];
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstlineOffset;
                int posy = ypos[j] + bandOffset;
                for (int i = 0; i < dwidth; ++i) {
                    int y0;
                    int x0;
                    int w;
                    int windex;
                    int posx = xpos[i];
                    int pos = posx + posy;
                    if (this.nullROINoData) {
                        dstData[dstPixelOffset] = srcData[pos];
                    } else if (this.nullNoDataNotNullROI) {
                        if (this.useRoiAccessor) {
                            windex = posx / dnumBands + yposRoi[j];
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataByte[0] : srcData[pos];
                        } else {
                            x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataByte[0] : srcData[pos]) : this.destinationNoDataByte[0];
                        }
                    } else if (this.notNullNoDataNullROI) {
                        dstData[dstPixelOffset] = this.noData.contains(srcData[pos]) ? this.destinationNoDataByte[0] : srcData[pos];
                    } else if (this.useRoiAccessor) {
                        if (this.noData.contains(srcData[pos])) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte[0];
                        } else {
                            windex = posx / dnumBands + yposRoi[j];
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataByte[0] : srcData[pos];
                        }
                    } else {
                        dstData[dstPixelOffset] = this.noData.contains(srcData[pos]) ? this.destinationNoDataByte[0] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataByte[0] : srcData[pos]) : this.destinationNoDataByte[0]);
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstlineOffset += dstScanlineStride;
            }
        }
    }

    private void ushortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        short[] dstData = null;
        short[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        int posyROI = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        for (int k = 0; k < dnumBands; ++k) {
            srcData = srcDataArrays[k];
            dstData = dstDataArrays[k];
            int dstlineOffset = dstBandOffsets[k];
            int bandOffset = bandOffsets[k];
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstlineOffset;
                int posy = ypos[j] + bandOffset;
                if (this.useRoiAccessor) {
                    posyROI = yposRoi[j];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int y0;
                    int x0;
                    int w;
                    int windex;
                    int posx = xpos[i];
                    int pos = posx + posy;
                    if (!this.hasROI && !this.hasNoData) {
                        dstData[dstPixelOffset] = srcData[pos];
                    } else if (this.hasROI && !this.hasNoData) {
                        if (this.useRoiAccessor) {
                            windex = posx / dnumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataUShort[0] : srcData[pos];
                        } else {
                            x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataUShort[0] : srcData[pos]) : this.destinationNoDataUShort[0];
                        }
                    } else if (!this.hasROI && this.hasNoData) {
                        dstData[dstPixelOffset] = this.noData.contains(srcData[pos]) ? this.destinationNoDataUShort[0] : srcData[pos];
                    } else if (this.hasROI && this.hasNoData) {
                        if (this.useRoiAccessor) {
                            if (this.noData.contains(srcData[pos])) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort[0];
                            } else {
                                windex = posx / dnumBands + posyROI;
                                int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataUShort[0] : srcData[pos];
                            }
                        } else {
                            dstData[dstPixelOffset] = this.noData.contains(srcData[pos]) ? this.destinationNoDataUShort[0] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataUShort[0] : srcData[pos]) : this.destinationNoDataUShort[0]);
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstlineOffset += dstScanlineStride;
            }
        }
    }

    private void shortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        short[] dstData = null;
        short[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        int posyROI = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        for (int k = 0; k < dnumBands; ++k) {
            srcData = srcDataArrays[k];
            dstData = dstDataArrays[k];
            int dstlineOffset = dstBandOffsets[k];
            int bandOffset = bandOffsets[k];
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstlineOffset;
                int posy = ypos[j] + bandOffset;
                if (this.useRoiAccessor) {
                    posyROI = yposRoi[j];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int y0;
                    int x0;
                    int w;
                    int windex;
                    int posx = xpos[i];
                    int pos = posx + posy;
                    if (!this.hasROI && !this.hasNoData) {
                        dstData[dstPixelOffset] = srcData[pos];
                    } else if (this.hasROI && !this.hasNoData) {
                        if (this.useRoiAccessor) {
                            windex = posx / dnumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataShort[0] : srcData[pos];
                        } else {
                            x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataShort[0] : srcData[pos]) : this.destinationNoDataShort[0];
                        }
                    } else if (!this.hasROI && this.hasNoData) {
                        dstData[dstPixelOffset] = this.noData.contains(srcData[pos]) ? this.destinationNoDataShort[0] : srcData[pos];
                    } else if (this.hasROI && this.hasNoData) {
                        if (this.useRoiAccessor) {
                            if (this.noData.contains(srcData[pos])) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort[0];
                            } else {
                                windex = posx / dnumBands + posyROI;
                                int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataShort[0] : srcData[pos];
                            }
                        } else {
                            dstData[dstPixelOffset] = this.noData.contains(srcData[pos]) ? this.destinationNoDataShort[0] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataShort[0] : srcData[pos]) : this.destinationNoDataShort[0]);
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstlineOffset += dstScanlineStride;
            }
        }
    }

    private void intLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstData = null;
        int[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        int posyROI = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        for (int k = 0; k < dnumBands; ++k) {
            srcData = srcDataArrays[k];
            dstData = dstDataArrays[k];
            int dstlineOffset = dstBandOffsets[k];
            int bandOffset = bandOffsets[k];
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstlineOffset;
                int posy = ypos[j] + bandOffset;
                if (this.useRoiAccessor) {
                    posyROI = yposRoi[j];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int y0;
                    int x0;
                    int w;
                    int windex;
                    int posx = xpos[i];
                    int pos = posx + posy;
                    if (!this.hasROI && !this.hasNoData) {
                        dstData[dstPixelOffset] = srcData[pos];
                    } else if (this.hasROI && !this.hasNoData) {
                        if (this.useRoiAccessor) {
                            windex = posx / dnumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataInt[0] : srcData[pos];
                        } else {
                            x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataInt[0] : srcData[pos]) : this.destinationNoDataInt[0];
                        }
                    } else if (!this.hasROI && this.hasNoData) {
                        dstData[dstPixelOffset] = this.noData.contains(srcData[pos]) ? this.destinationNoDataInt[0] : srcData[pos];
                    } else if (this.hasROI && this.hasNoData) {
                        if (this.useRoiAccessor) {
                            if (this.noData.contains(srcData[pos])) {
                                dstData[dstPixelOffset] = this.destinationNoDataInt[0];
                            } else {
                                windex = posx / dnumBands + posyROI;
                                int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataInt[0] : srcData[pos];
                            }
                        } else {
                            dstData[dstPixelOffset] = this.noData.contains(srcData[pos]) ? this.destinationNoDataInt[0] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataInt[0] : srcData[pos]) : this.destinationNoDataInt[0]);
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstlineOffset += dstScanlineStride;
            }
        }
    }

    private void floatLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        float[] dstData = null;
        float[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        int posyROI = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        for (int k = 0; k < dnumBands; ++k) {
            srcData = srcDataArrays[k];
            dstData = dstDataArrays[k];
            int dstlineOffset = dstBandOffsets[k];
            int bandOffset = bandOffsets[k];
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstlineOffset;
                int posy = ypos[j] + bandOffset;
                if (this.useRoiAccessor) {
                    posyROI = yposRoi[j];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int y0;
                    int x0;
                    int w;
                    int windex;
                    int posx = xpos[i];
                    int pos = posx + posy;
                    if (!this.hasROI && !this.hasNoData) {
                        dstData[dstPixelOffset] = srcData[pos];
                    } else if (this.hasROI && !this.hasNoData) {
                        if (this.useRoiAccessor) {
                            windex = posx / dnumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat[0] : srcData[pos];
                        } else {
                            x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataFloat[0] : srcData[pos]) : this.destinationNoDataFloat[0];
                        }
                    } else if (!this.hasROI && this.hasNoData) {
                        dstData[dstPixelOffset] = this.isNegativeInf && srcData[pos] == Float.NEGATIVE_INFINITY || this.isPositiveInf && srcData[pos] == Float.NEGATIVE_INFINITY || this.isRangeNaN && Float.isNaN(srcData[pos]) ? this.destinationNoDataFloat[0] : (this.noData.contains(srcData[pos]) ? this.destinationNoDataFloat[0] : srcData[pos]);
                    } else if (this.hasROI && this.hasNoData) {
                        if (this.useRoiAccessor) {
                            if (this.isNegativeInf && srcData[pos] == Float.NEGATIVE_INFINITY || this.isPositiveInf && srcData[pos] == Float.NEGATIVE_INFINITY || this.isRangeNaN && Float.isNaN(srcData[pos])) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat[0];
                            } else if (this.noData.contains(srcData[pos])) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat[0];
                            } else {
                                windex = posx / dnumBands + posyROI;
                                int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat[0] : srcData[pos];
                            }
                        } else {
                            dstData[dstPixelOffset] = this.isNegativeInf && srcData[pos] == Float.NEGATIVE_INFINITY || this.isPositiveInf && srcData[pos] == Float.NEGATIVE_INFINITY || this.isRangeNaN && Float.isNaN(srcData[pos]) ? this.destinationNoDataFloat[0] : (this.noData.contains(srcData[pos]) ? this.destinationNoDataFloat[0] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataFloat[0] : srcData[pos]) : this.destinationNoDataFloat[0]));
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstlineOffset += dstScanlineStride;
            }
        }
    }

    private void doubleLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        double[] dstData = null;
        double[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        int posyROI = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        for (int k = 0; k < dnumBands; ++k) {
            srcData = srcDataArrays[k];
            dstData = dstDataArrays[k];
            int dstlineOffset = dstBandOffsets[k];
            int bandOffset = bandOffsets[k];
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstlineOffset;
                int posy = ypos[j] + bandOffset;
                if (this.useRoiAccessor) {
                    posyROI = yposRoi[j];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int y0;
                    int x0;
                    int w;
                    int windex;
                    int posx = xpos[i];
                    int pos = posx + posy;
                    if (!this.hasROI && !this.hasNoData) {
                        dstData[dstPixelOffset] = srcData[pos];
                    } else if (this.hasROI && !this.hasNoData) {
                        if (this.useRoiAccessor) {
                            windex = posx / dnumBands + posyROI;
                            int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble[0] : srcData[pos];
                        } else {
                            x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataDouble[0] : srcData[pos]) : this.destinationNoDataDouble[0];
                        }
                    } else if (!this.hasROI && this.hasNoData) {
                        dstData[dstPixelOffset] = this.isNegativeInf && srcData[pos] == Double.NEGATIVE_INFINITY || this.isPositiveInf && srcData[pos] == Double.NEGATIVE_INFINITY || this.isRangeNaN && Double.isNaN(srcData[pos]) ? this.destinationNoDataDouble[0] : (this.noData.contains(srcData[pos]) ? this.destinationNoDataDouble[0] : srcData[pos]);
                    } else if (this.hasROI && this.hasNoData) {
                        if (this.useRoiAccessor) {
                            if (this.isNegativeInf && srcData[pos] == Double.NEGATIVE_INFINITY || this.isPositiveInf && srcData[pos] == Double.NEGATIVE_INFINITY || this.isRangeNaN && Double.isNaN(srcData[pos])) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble[0];
                            } else if (this.noData.contains(srcData[pos])) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble[0];
                            } else {
                                windex = posx / dnumBands + posyROI;
                                int n = w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                                dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble[0] : srcData[pos];
                            }
                        } else {
                            dstData[dstPixelOffset] = this.isNegativeInf && srcData[pos] == Double.NEGATIVE_INFINITY || this.isPositiveInf && srcData[pos] == Double.NEGATIVE_INFINITY || this.isRangeNaN && Double.isNaN(srcData[pos]) ? this.destinationNoDataDouble[0] : (this.noData.contains(srcData[pos]) ? this.destinationNoDataDouble[0] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataDouble[0] : srcData[pos]) : this.destinationNoDataDouble[0]));
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstlineOffset += dstScanlineStride;
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        this.computeRect(sources, dest, destRect, null);
    }
}

